/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.message;

import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseMessageValidator;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;
import org.eclipse.wst.wsi.internal.core.util.SetCookie2Validator;

public class WSI1105
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public WSI1105(BaseMessageValidator impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        SetCookie2Validator cookieVal = new SetCookie2Validator();
        String headers = entryContext.getMessageEntry().getHTTPHeaders();
        if (entryContext.getMessageEntry().getType().equalsIgnoreCase("response")) {
            String setCookie2 = (String)HTTPUtils.getHttpHeaderTokens(headers, ":").get("Set-Cookie2".toUpperCase());
            if (setCookie2 == null) {
                this.result = "notApplicable";
            } else if (cookieVal.isSetCookie2(setCookie2.trim())) {
                this.result = "passed";
            } else {
                this.result = "warning";
                this.failureDetail = this.validator.createFailureDetail("\nMessage:\nHeaders:\n" + entryContext.getMessageEntry().getHTTPHeaders() + "\nSOAP message:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
            }
        } else {
            String cookie = (String)HTTPUtils.getHttpHeaderTokens(headers, ":").get("Cookie");
            if (cookie == null) {
                this.result = "notApplicable";
            } else if (cookieVal.isCookie(cookie.trim())) {
                this.result = "passed";
            } else {
                this.result = "warning";
                this.failureDetail = this.validator.createFailureDetail("\nMessage:\nHeaders:\n" + entryContext.getMessageEntry().getHTTPHeaders() + "\nSOAP message:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

