/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.IJavascriptValidationStrategy;

public class JavascriptValidationStrategy
implements IJavascriptValidationStrategy {
    IJavascriptValidationStrategy delegate = null;

    public JavascriptValidationStrategy(ISourceViewer viewer) {
        this.createDelegate(viewer);
    }

    private void createDelegate(ISourceViewer viewer) {
        this.delegate = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.jsdt.ui", "javascriptValidationHelper");
        int i = 0;
        while (this.delegate == null && i < cf.length) {
            try {
                IJavascriptValidationStrategy p = (IJavascriptValidationStrategy)cf[i].createExecutableExtension("class");
                if (p != null) {
                    this.delegate = p;
                }
            }
            catch (CoreException e) {
                JavaScriptPlugin.getDefault().getLog().log((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), "Loading IJavascriptValidationStrategy extension has failed.", (Throwable)e));
            }
            ++i;
        }
        this.setSourceViewer(viewer);
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        if (this.delegate != null) {
            this.delegate.setProgressMonitor(monitor);
        }
    }

    public void initialReconcile() {
        if (this.delegate != null) {
            this.delegate.initialReconcile();
        }
    }

    public void setDocument(IDocument document) {
        if (this.delegate != null) {
            this.delegate.setDocument(document);
        }
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (this.delegate != null) {
            this.delegate.reconcile(dirtyRegion, subRegion);
        }
    }

    public void reconcile(IRegion partition) {
        if (this.delegate != null) {
            this.delegate.reconcile(partition);
        }
    }

    @Override
    public void setSourceViewer(ISourceViewer viewer) {
        if (this.delegate != null) {
            this.delegate.setSourceViewer(viewer);
        }
    }

    @Override
    public void aboutToBeReconciled() {
        if (this.delegate != null) {
            this.delegate.aboutToBeReconciled();
        }
    }
}

