/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.internal.DefaultSaveable;
import org.eclipse.ui.internal.SaveableHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class SaveablesList
implements ISaveablesLifecycleListener {
    private ListenerList<ISaveablesLifecycleListener> listeners = new ListenerList();
    private Map<Object, Set<Saveable>> modelMap = new LinkedHashMap<Object, Set<Saveable>>();
    private Map<Saveable, Integer> modelRefCounts = new LinkedHashMap<Saveable, Integer>();
    private Map<Saveable, List<Saveable>> equalKeys = new IdentityHashMap<Saveable, List<Saveable>>();
    private Set<ISaveablesSource> nonPartSources = new HashSet<ISaveablesSource>();

    public Saveable[] getOpenModels() {
        HashSet allDistinctModels = new HashSet();
        Iterator<Set<Saveable>> saveables = this.modelMap.values().iterator();
        while (saveables.hasNext()) {
            allDistinctModels.addAll(saveables.next());
        }
        return allDistinctModels.toArray(new Saveable[allDistinctModels.size()]);
    }

    private boolean addModel(Object source, Saveable model) {
        if (model == null) {
            this.logWarning("Ignored attempt to add invalid saveable", source, model);
            return false;
        }
        boolean result = false;
        Set<Saveable> modelsForSource = this.modelMap.get(source);
        if (modelsForSource == null) {
            modelsForSource = new HashSet<Saveable>();
            this.modelMap.put(source, modelsForSource);
        }
        if (modelsForSource.add(model)) {
            result = this.incrementRefCount(this.modelRefCounts, model);
        } else {
            this.logWarning("Ignored attempt to add saveable that was already registered", source, model);
        }
        return result;
    }

    private boolean incrementRefCount(Map<Saveable, Integer> referenceMap, Saveable key) {
        boolean result = false;
        Integer refCount = referenceMap.get(key);
        if (refCount == null) {
            result = true;
            refCount = 0;
        }
        if (referenceMap == this.modelRefCounts) {
            if (result) {
                this.rememberRefKey(key);
            } else {
                this.incrementRefKeys(key);
            }
        }
        referenceMap.put(key, refCount + 1);
        return result;
    }

    private void rememberRefKey(Saveable key) {
        ArrayList<Saveable> equals = new ArrayList<Saveable>();
        equals.add(key);
        this.equalKeys.put(key, equals);
    }

    private void incrementRefKeys(Saveable key) {
        Saveable keyUsedInCountMap = this.findExistingRefKey(key);
        if (keyUsedInCountMap == null) {
            this.rememberRefKey(key);
            return;
        }
        List<Saveable> equals = this.equalKeys.get(keyUsedInCountMap);
        equals.add(key);
        this.equalKeys.put(key, equals);
    }

    private boolean decrementRefCount(Saveable key) {
        int refCountValue;
        boolean result = false;
        Integer refCount = this.modelRefCounts.get(key);
        Saveable keyToDecrement = key;
        if (refCount == null && keyToDecrement != (key = this.fixKeyIfKnown(key))) {
            refCount = this.modelRefCounts.get(key);
        }
        if (refCount == null) {
            Assert.isTrue((boolean)false, (String)(keyToDecrement + ": " + keyToDecrement.getName()));
        }
        if ((refCountValue = refCount.intValue()) == 1) {
            this.modelRefCounts.remove(key);
            result = true;
            this.forgetRefKeys(key);
        } else {
            Saveable keyUsedInCountMap;
            Collection equals = this.equalKeys.get(keyToDecrement);
            long instanceCount = this.count(keyToDecrement, equals);
            if (instanceCount == 1L) {
                this.forgetRefKeys(keyToDecrement);
                keyUsedInCountMap = (Saveable)equals.iterator().next();
            } else {
                this.decrementRefKeys(keyToDecrement);
                keyUsedInCountMap = key;
            }
            this.modelRefCounts.remove(keyToDecrement);
            this.modelRefCounts.put(keyUsedInCountMap, refCountValue - 1);
        }
        return result;
    }

    private long count(Saveable keyToDecrement, Collection<Saveable> equals) {
        return equals.stream().filter(x -> x == keyToDecrement).count();
    }

    private Saveable fixKeyIfKnown(Saveable key) {
        Collection keys = this.equalKeys.get(key);
        if (keys == null) {
            return key;
        }
        Saveable goodKey = null;
        for (Saveable saveable : keys) {
            Integer refCount = this.modelRefCounts.get(saveable);
            if (refCount == null) continue;
            goodKey = saveable;
            break;
        }
        if (goodKey == null) {
            return key;
        }
        return goodKey;
    }

    private void forgetRefKeys(Saveable key) {
        Collection keys = this.equalKeys.get(key);
        if (keys != null) {
            this.equalKeys.remove(key);
            keys.removeIf(x -> x == key);
        }
    }

    private void decrementRefKeys(Saveable key) {
        List<Saveable> keys = this.equalKeys.get(key);
        if (keys != null) {
            int i = 0;
            while (i < keys.size()) {
                if (keys.get(i) == key) {
                    keys.remove(i);
                    break;
                }
                ++i;
            }
        }
    }

    private Saveable findExistingRefKey(Saveable key) {
        Saveable existingKey = null;
        Set<Saveable> keys = this.modelRefCounts.keySet();
        for (Saveable s : keys) {
            if (!s.equals(key)) continue;
            existingKey = s;
            break;
        }
        return existingKey;
    }

    private boolean removeModel(Object source, Saveable model) {
        boolean result = false;
        Set<Saveable> modelsForSource = this.modelMap.get(source);
        if (modelsForSource == null) {
            this.logWarning("Ignored attempt to remove a saveable when no saveables were known", source, model);
        } else if (modelsForSource.remove(model)) {
            result = this.decrementRefCount(model);
            if (modelsForSource.isEmpty()) {
                this.modelMap.remove(source);
            }
        } else {
            this.logWarning("Ignored attempt to remove a saveable that was not registered", source, model);
        }
        return result;
    }

    private void logWarning(String message, Object source, Saveable model) {
        AssertionFailedException assertionFailedException = new AssertionFailedException("unknown saveable: " + model + " from part: " + source);
        assertionFailedException.fillInStackTrace();
        WorkbenchPlugin.log(StatusUtil.newStatus(2, message, (Throwable)assertionFailedException));
    }

    @Override
    public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
        if (!(event.getSource() instanceof IWorkbenchPart)) {
            this.updateNonPartSource((ISaveablesSource)event.getSource());
            return;
        }
        Saveable[] modelArray = event.getSaveables();
        switch (event.getEventType()) {
            case 1: {
                this.addModels(event.getSource(), modelArray);
                break;
            }
            case 2: {
                Saveable[] models = event.getSaveables();
                HashMap<Saveable, Integer> modelsDecrementing = new HashMap<Saveable, Integer>();
                HashSet<Saveable> modelsClosing = new HashSet<Saveable>();
                Saveable[] saveableArray = models;
                int n = models.length;
                int n2 = 0;
                while (n2 < n) {
                    Saveable model = saveableArray[n2];
                    this.incrementRefCount(modelsDecrementing, model);
                    ++n2;
                }
                this.fillModelsClosing(modelsClosing, modelsDecrementing);
                boolean canceled = this.promptForSavingIfNecessary(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), modelsClosing, modelsDecrementing, !event.isForce());
                if (!canceled) break;
                event.setVeto(true);
                break;
            }
            case 3: {
                this.removeModels(event.getSource(), modelArray);
                break;
            }
            case 4: {
                this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, event.getEventType(), event.getSaveables(), false));
            }
        }
    }

    private void updateNonPartSource(ISaveablesSource source) {
        Saveable[] saveables = source.getSaveables();
        if (saveables.length == 0) {
            this.nonPartSources.remove(source);
        } else {
            this.nonPartSources.add(source);
        }
    }

    private void removeModels(Object source, Saveable[] modelArray) {
        ArrayList<Saveable> removed = new ArrayList<Saveable>();
        Saveable[] saveableArray = modelArray;
        int n = modelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Saveable model = saveableArray[n2];
            if (this.removeModel(source, model)) {
                removed.add(model);
            }
            ++n2;
        }
        if (removed.size() > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 1, removed.toArray(new Saveable[removed.size()]), false));
        }
    }

    private void addModels(Object source, Saveable[] modelArray) {
        ArrayList<Saveable> added = new ArrayList<Saveable>();
        Saveable[] saveableArray = modelArray;
        int n = modelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Saveable model = saveableArray[n2];
            if (this.addModel(source, model)) {
                added.add(model);
            }
            ++n2;
        }
        if (added.size() > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 1, added.toArray(new Saveable[added.size()]), false));
        }
    }

    private void fireModelLifecycleEvent(SaveablesLifecycleEvent event) {
        for (ISaveablesLifecycleListener listener : this.listeners) {
            listener.handleLifecycleEvent(event);
        }
    }

    public void addModelLifecycleListener(ISaveablesLifecycleListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeModelLifecycleListener(ISaveablesLifecycleListener listener) {
        this.listeners.remove((Object)listener);
    }

    public Object preCloseParts(List<IWorkbenchPart> partsToClose, boolean save, IWorkbenchWindow window) {
        return this.preCloseParts(partsToClose, save, window, window);
    }

    public Object preCloseParts(List<IWorkbenchPart> partsToClose, boolean save, IShellProvider shellProvider, IWorkbenchWindow window) {
        return this.preCloseParts(partsToClose, false, save, shellProvider, window);
    }

    public Object preCloseParts(List<IWorkbenchPart> partsToClose, boolean addNonPartSources, boolean save, IShellProvider shellProvider, IWorkbenchWindow window) {
        boolean canceled;
        PostCloseInfo postCloseInfo = new PostCloseInfo();
        for (IWorkbenchPart part : partsToClose) {
            int response;
            postCloseInfo.partsClosing.add(part);
            ISaveablePart saveable = SaveableHelper.getSaveable(part);
            if (saveable != null && save && !saveable.isSaveOnCloseNeeded()) continue;
            if (save && saveable instanceof ISaveablePart2) {
                ISaveablePart2 saveablePart2 = (ISaveablePart2)saveable;
                response = SaveableHelper.savePart(saveablePart2, window, true);
                if (response == 2) {
                    return null;
                }
                if (response != 3) continue;
            }
            Saveable[] saveableArray = this.getSaveables(part);
            int n = saveableArray.length;
            response = 0;
            while (response < n) {
                Saveable saveableModel = saveableArray[response];
                this.incrementRefCount(postCloseInfo.modelsDecrementing, saveableModel);
                ++response;
            }
        }
        this.fillModelsClosing(postCloseInfo.modelsClosing, postCloseInfo.modelsDecrementing);
        if (addNonPartSources) {
            ISaveablesSource[] iSaveablesSourceArray = this.getNonPartSources();
            int n = iSaveablesSourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Saveable[] saveables;
                ISaveablesSource nonPartSource = iSaveablesSourceArray[n2];
                Saveable[] saveableArray = saveables = nonPartSource.getSaveables();
                int n3 = saveables.length;
                int n4 = 0;
                while (n4 < n3) {
                    Saveable saveable = saveableArray[n4];
                    if (saveable.isDirty()) {
                        postCloseInfo.modelsClosing.add(saveable);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if (save && (canceled = this.promptForSavingIfNecessary(shellProvider, window, postCloseInfo.modelsClosing, postCloseInfo.modelsDecrementing, true))) {
            return null;
        }
        return postCloseInfo;
    }

    private boolean promptForSavingIfNecessary(IWorkbenchWindow window, Set<Saveable> modelsClosing, Map<Saveable, Integer> modelsDecrementing, boolean canCancel) {
        return this.promptForSavingIfNecessary(window, window, modelsClosing, modelsDecrementing, canCancel);
    }

    private boolean promptForSavingIfNecessary(IShellProvider shellProvider, IWorkbenchWindow window, Set<Saveable> modelsClosing, Map<Saveable, Integer> modelsDecrementing, boolean canCancel) {
        boolean shouldCancel;
        ArrayList<Saveable> modelsToOptionallySave = new ArrayList<Saveable>();
        for (Saveable modelDecrementing : modelsDecrementing.keySet()) {
            if (!modelDecrementing.isDirty() || modelsClosing.contains(modelDecrementing)) continue;
            modelsToOptionallySave.add(modelDecrementing);
        }
        boolean bl = shouldCancel = modelsToOptionallySave.isEmpty() ? false : this.promptForSaving(modelsToOptionallySave, shellProvider, window, canCancel, true);
        if (shouldCancel) {
            return true;
        }
        ArrayList<Saveable> modelsToSave = new ArrayList<Saveable>();
        for (Saveable modelClosing : modelsClosing) {
            if (!modelClosing.isDirty()) continue;
            modelsToSave.add(modelClosing);
        }
        return modelsToSave.isEmpty() ? false : this.promptForSaving(modelsToSave, shellProvider, window, canCancel, false);
    }

    private void fillModelsClosing(Set<Saveable> modelsClosing, Map<Saveable, Integer> modelsDecrementing) {
        for (Map.Entry<Saveable, Integer> entry : modelsDecrementing.entrySet()) {
            Saveable model = entry.getKey();
            if (!entry.getValue().equals(this.modelRefCounts.get(model))) continue;
            modelsClosing.add(model);
        }
    }

    public boolean promptForSaving(List<Saveable> modelsToSave, IShellProvider shellProvider, IRunnableContext runnableContext, final boolean canCancel, boolean stillOpenElsewhere) {
        block22: {
            IPreferenceStore apiPreferenceStore;
            block23: {
                Object dialog;
                boolean dontPrompt;
                if (modelsToSave.size() <= 0) break block22;
                boolean canceled = SaveableHelper.waitForBackgroundSaveJobs(modelsToSave);
                if (canceled) {
                    return true;
                }
                apiPreferenceStore = PrefUtil.getAPIPreferenceStore();
                boolean bl = dontPrompt = stillOpenElsewhere && !apiPreferenceStore.getBoolean("PROMPT_WHEN_SAVEABLE_STILL_OPEN");
                if (dontPrompt) {
                    modelsToSave.clear();
                    return false;
                }
                if (modelsToSave.size() != 1) break block23;
                Saveable model = modelsToSave.get(0);
                int choice = 1;
                if (stillOpenElsewhere) {
                    LinkedHashMap<String, Integer> buttonLabelToIdMap = new LinkedHashMap<String, Integer>();
                    buttonLabelToIdMap.put(WorkbenchMessages.SaveableHelper_Save, 0);
                    buttonLabelToIdMap.put(WorkbenchMessages.SaveableHelper_Dont_Save, 3);
                    if (canCancel) {
                        buttonLabelToIdMap.put(WorkbenchMessages.SaveableHelper_Cancel, 1);
                    }
                    String message = NLS.bind((String)WorkbenchMessages.EditorManager_saveChangesOptionallyQuestion, (Object)model.getName());
                    MessageDialogWithToggle dialogWithToggle = new MessageDialogWithToggle(shellProvider.getShell(), WorkbenchMessages.Save_Resource, null, message, 3, buttonLabelToIdMap, 0, WorkbenchMessages.EditorManager_closeWithoutPromptingOption, false){

                        protected int getShellStyle() {
                            return (canCancel ? 64 : 0) | 0x20 | 0x800 | 0x10000 | 0x10000000 | 1.getDefaultOrientation();
                        }
                    };
                    dialog = dialogWithToggle;
                } else {
                    String[] buttons = canCancel ? new String[]{WorkbenchMessages.SaveableHelper_Save, WorkbenchMessages.SaveableHelper_Dont_Save, WorkbenchMessages.SaveableHelper_Cancel} : new String[]{WorkbenchMessages.SaveableHelper_Save, WorkbenchMessages.SaveableHelper_Dont_Save};
                    String message = NLS.bind((String)WorkbenchMessages.EditorManager_saveChangesQuestion, (Object)model.getName());
                    dialog = new MessageDialog(shellProvider.getShell(), WorkbenchMessages.Save_Resource, null, message, 3, 0, buttons){

                        protected int getShellStyle() {
                            return (canCancel ? 64 : 0) | 0x20 | 0x800 | 0x10000 | 0x10000000 | 2.getDefaultOrientation();
                        }
                    };
                }
                choice = SaveableHelper.testGetAutomatedResponse();
                if (SaveableHelper.testGetAutomatedResponse() == -1) {
                    choice = dialog.open();
                    if (stillOpenElsewhere) {
                        switch (choice) {
                            case 2: {
                                choice = 0;
                                break;
                            }
                            case 3: {
                                choice = 1;
                                break;
                            }
                            case 1: {
                                choice = 2;
                                break;
                            }
                        }
                        MessageDialogWithToggle dialogWithToggle = (MessageDialogWithToggle)dialog;
                        if (choice != 2 && dialogWithToggle.getToggleState()) {
                            apiPreferenceStore.setValue("PROMPT_WHEN_SAVEABLE_STILL_OPEN", false);
                        }
                    }
                }
                switch (choice) {
                    case 0: {
                        break block22;
                    }
                    case 1: {
                        modelsToSave.clear();
                        break block22;
                    }
                    default: {
                        return true;
                    }
                }
            }
            MyListSelectionDialog dlg = new MyListSelectionDialog(shellProvider.getShell(), modelsToSave, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), stillOpenElsewhere ? WorkbenchMessages.EditorManager_saveResourcesOptionallyMessage : WorkbenchMessages.EditorManager_saveResourcesMessage, canCancel, stillOpenElsewhere);
            dlg.setInitialSelections(modelsToSave.toArray());
            dlg.setTitle(WorkbenchMessages.EditorManager_saveResourcesTitle);
            if (SaveableHelper.testGetAutomatedResponse() == -1) {
                Object[] objects;
                int result = dlg.open();
                if (result == 1) {
                    return true;
                }
                if (dlg.getDontPromptSelection()) {
                    apiPreferenceStore.setValue("PROMPT_WHEN_SAVEABLE_STILL_OPEN", false);
                }
                modelsToSave = new ArrayList<Saveable>();
                Object[] objectArray = objects = dlg.getResult();
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof Saveable) {
                        modelsToSave.add((Saveable)object);
                    }
                    ++n2;
                }
            }
        }
        return this.saveModels(modelsToSave, shellProvider, runnableContext);
    }

    public boolean saveModels(List<Saveable> finalModels, IShellProvider shellProvider, IRunnableContext runnableContext) {
        return this.saveModels(finalModels, shellProvider, runnableContext, true);
    }

    public boolean saveModels(List<Saveable> finalModels, IShellProvider shellProvider, IRunnableContext runnableContext, boolean blockUntilSaved) {
        IRunnableWithProgress progressOp = monitor -> {
            EventLoopProgressMonitor monitorWrap = new EventLoopProgressMonitor(monitor);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitorWrap, (String)WorkbenchMessages.Saving_Modifications, (int)finalModels.size());
            for (Saveable model : finalModels) {
                if (!model.isDirty()) {
                    subMonitor.worked(1);
                    continue;
                }
                SaveableHelper.doSaveModel(model, (IProgressMonitor)subMonitor.split(1), shellProvider, blockUntilSaved);
                if (subMonitor.isCanceled()) break;
            }
            monitorWrap.done();
        };
        return !SaveableHelper.runProgressMonitorOperation(WorkbenchMessages.Save_All, progressOp, runnableContext, shellProvider);
    }

    public void postClose(Object postCloseInfoObject) {
        PostCloseInfo postCloseInfo = (PostCloseInfo)postCloseInfoObject;
        ArrayList<Saveable> removed = new ArrayList<Saveable>();
        for (IWorkbenchPart part : postCloseInfo.partsClosing) {
            Set<Saveable> saveables = this.modelMap.get(part);
            if (saveables == null) continue;
            saveables = new HashSet<Saveable>(saveables);
            for (Saveable saveable : saveables) {
                if (!this.removeModel(part, saveable)) continue;
                removed.add(saveable);
            }
        }
        if (removed.size() > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 3, removed.toArray(new Saveable[removed.size()]), false));
        }
    }

    private Saveable[] getSaveables(IWorkbenchPart part) {
        if (part instanceof ISaveablesSource) {
            ISaveablesSource source = (ISaveablesSource)((Object)part);
            return source.getSaveables();
        }
        if (SaveableHelper.isSaveable(part)) {
            return new Saveable[]{new DefaultSaveable(part)};
        }
        return new Saveable[0];
    }

    public void postOpen(IWorkbenchPart part) {
        this.addModels(part, this.getSaveables(part));
    }

    public void dirtyChanged(IWorkbenchPart part) {
        Saveable[] saveables = this.getSaveables(part);
        if (saveables.length > 0) {
            this.fireModelLifecycleEvent(new SaveablesLifecycleEvent(this, 4, saveables, false));
        }
    }

    public Object[] testGetSourcesForModel(Saveable model) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Map.Entry<Object, Set<Saveable>> entry : this.modelMap.entrySet()) {
            Set<Saveable> values = entry.getValue();
            if (!values.contains(model)) continue;
            result.add(entry.getKey());
        }
        return result.toArray();
    }

    public ISaveablesSource[] getNonPartSources() {
        return this.nonPartSources.toArray(new ISaveablesSource[this.nonPartSources.size()]);
    }

    public IWorkbenchPart[] getPartsForSaveable(Saveable model) {
        ArrayList<IWorkbenchPart> result = new ArrayList<IWorkbenchPart>();
        for (Map.Entry<Object, Set<Saveable>> entry : this.modelMap.entrySet()) {
            Set<Saveable> values = entry.getValue();
            if (!values.contains(model) || !(entry.getKey() instanceof IWorkbenchPart)) continue;
            result.add((IWorkbenchPart)entry.getKey());
        }
        return result.toArray(new IWorkbenchPart[result.size()]);
    }

    protected Map<Saveable, Integer> getModelRefCounts() {
        return this.modelRefCounts;
    }

    protected Map<Object, Set<Saveable>> getModelMap() {
        return this.modelMap;
    }

    protected Map<Saveable, List<Saveable>> getEqualKeys() {
        return this.equalKeys;
    }

    private static final class MyListSelectionDialog
    extends ListSelectionDialog {
        private final boolean canCancel;
        private Button checkbox;
        private boolean dontPromptSelection;
        private boolean stillOpenElsewhere;

        private MyListSelectionDialog(Shell shell, Object input, IStructuredContentProvider contentprovider, ILabelProvider labelProvider, String message, boolean canCancel, boolean stillOpenElsewhere) {
            super(shell, input, contentprovider, labelProvider, message);
            this.canCancel = canCancel;
            this.stillOpenElsewhere = stillOpenElsewhere;
            int shellStyle = this.getShellStyle();
            if (!canCancel) {
                shellStyle &= 0xFFFFFFBF;
            }
            this.setShellStyle(shellStyle | 0x10000000);
        }

        public boolean getDontPromptSelection() {
            return this.dontPromptSelection;
        }

        @Override
        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, WorkbenchMessages.SaveableHelper_Save_Selected, true);
            if (this.canCancel) {
                this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            }
        }

        @Override
        protected Control createDialogArea(Composite parent) {
            Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
            if (this.stillOpenElsewhere) {
                Composite checkboxComposite = new Composite(dialogAreaComposite, 0);
                checkboxComposite.setLayout((Layout)new GridLayout(2, false));
                this.checkbox = new Button(checkboxComposite, 32);
                this.checkbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                    boolean bl = this.dontPromptSelection = this.checkbox.getSelection();
                }));
                GridData gd = new GridData();
                gd.horizontalAlignment = 1;
                this.checkbox.setLayoutData((Object)gd);
                Label label = new Label(checkboxComposite, 0);
                label.setText(WorkbenchMessages.EditorManager_closeWithoutPromptingOption);
                gd = new GridData();
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalAlignment = 1;
            }
            return dialogAreaComposite;
        }
    }

    private static class PostCloseInfo {
        private List<IWorkbenchPart> partsClosing = new ArrayList<IWorkbenchPart>();
        private Map<Saveable, Integer> modelsDecrementing = new HashMap<Saveable, Integer>();
        private Set<Saveable> modelsClosing = new HashSet<Saveable>();

        private PostCloseInfo() {
        }
    }
}

