/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.core.Team;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.preferences.FileTypeTable;
import org.eclipse.ui.PlatformUI;

public class CommitWizardFileTypePage
extends WizardPage {
    private final Collection fExtensions;
    private final Collection<FileTypeTable.Item> fNames;

    public CommitWizardFileTypePage(Collection unknownExtensions, Collection unknownNames) {
        super(CVSUIMessages.CommitWizardFileTypePage_0);
        this.setTitle(CVSUIMessages.CommitWizardFileTypePage_0);
        this.setDescription(CVSUIMessages.CommitWizardFileTypePage_2);
        this.fNames = new ArrayList<FileTypeTable.Item>();
        for (String name : unknownNames) {
            this.fNames.add((FileTypeTable.Item)new FileTypeTable.Name(name, false));
        }
        this.fExtensions = new ArrayList();
        for (String extension : unknownExtensions) {
            this.fExtensions.add(new FileTypeTable.Extension(extension, false));
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.commit_file_types_page_context");
        Label label = new Label(composite, 64);
        label.setText(CVSUIMessages.CommitWizardFileTypePage_3);
        label.setLayoutData((Object)SWTUtils.createHFillGridData());
        Dialog.applyDialogFont((Control)composite);
        ArrayList<FileTypeTable.Item> items = new ArrayList<FileTypeTable.Item>();
        items.addAll(this.fNames);
        items.addAll(this.fExtensions);
        new FileTypeTable(composite, items, true);
        this.setControl((Control)composite);
    }

    public void getModesForExtensions(Map toSave, Map notToSave) {
        CommitWizardFileTypePage.getModes(this.fExtensions, toSave, notToSave);
    }

    public void getModesForNames(Map toSave, Map notToSave) {
        CommitWizardFileTypePage.getModes(this.fNames, toSave, notToSave);
    }

    private static void getModes(Collection items, Map toSave, Map notToSave) {
        for (FileTypeTable.Item item : items) {
            Map destination = item.save ? toSave : notToSave;
            destination.put(item.name, item.mode);
        }
    }

    public Command.KSubstOption getOption(IFile file) throws CVSException {
        String extension = file.getFileExtension();
        if (extension != null) {
            for (FileTypeTable.Item element : this.fExtensions) {
                if (!element.name.equals(extension)) continue;
                return element.mode == 1 ? Command.KSubstOption.getDefaultTextMode() : Command.KSUBST_BINARY;
            }
        } else {
            String name = file.getName();
            for (FileTypeTable.Item item : this.fNames) {
                if (!item.name.equals(name)) continue;
                return item.mode == 1 ? Command.KSubstOption.getDefaultTextMode() : Command.KSUBST_BINARY;
            }
        }
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
        ResourceSyncInfo fileInfo = cvsFile.getSyncInfo();
        return fileInfo != null ? fileInfo.getKeywordMode() : Command.KSubstOption.fromFile((IFile)file);
    }

    public static void saveExtensionMappings(Map modesToPersist) {
        String[] extensions = new String[modesToPersist.size()];
        int[] modes = new int[modesToPersist.size()];
        int index = 0;
        Iterator iter = modesToPersist.keySet().iterator();
        while (iter.hasNext()) {
            extensions[index] = (String)iter.next();
            modes[index] = (Integer)modesToPersist.get(extensions[index]);
            ++index;
        }
        Team.getFileContentManager().addExtensionMappings(extensions, modes);
    }

    public static void saveNameMappings(Map modesToPersist) {
        String[] names = new String[modesToPersist.size()];
        int[] modes = new int[modesToPersist.size()];
        int index = 0;
        Iterator iter = modesToPersist.keySet().iterator();
        while (iter.hasNext()) {
            names[index] = (String)iter.next();
            modes[index] = (Integer)modesToPersist.get(names[index]);
            ++index;
        }
        Team.getFileContentManager().addNameMappings(names, modes);
    }
}

