/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.ModeWizardSelectionPage;
import org.eclipse.team.internal.ccvs.ui.wizards.ResizableWizard;

public class ModeWizard
extends ResizableWizard {
    protected List fChanges;
    final ModeWizardSelectionPage fPage;

    public static ModeWizard run(Shell shell, IResource[] resources) {
        ModeWizard[] wizard = new ModeWizard[1];
        BusyIndicator.showWhile((Display)shell.getDisplay(), () -> {
            ModeWizard modeWizard = new ModeWizard(shell, resources);
        });
        ModeWizard.open(shell, wizard[0]);
        return wizard[0];
    }

    protected ModeWizard(Shell shell, IResource[] resources) {
        super(CVSUIMessages.ModeWizard_0, CVSUIPlugin.getPlugin().getDialogSettings(), 700, 480);
        this.setWindowTitle(CVSUIMessages.ModeWizard_1);
        this.fChanges = ModeWizard.getModeChanges(shell, resources);
        this.fPage = new ModeWizardSelectionPage(this.fChanges);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    protected static List getModeChanges(Shell shell, IResource[] resources) {
        ArrayList changes = new ArrayList();
        HashSet visited = new HashSet();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource currentResource = iResourceArray[n2];
            try {
                currentResource.accept(resource -> {
                    ICVSFile cvsFile;
                    IFile file;
                    block5: {
                        block4: {
                            try {
                                if (!visited.contains(resource) && resource.getType() == 1 && resource.exists()) break block4;
                                return true;
                            }
                            catch (TeamException e) {
                                throw new CoreException(e.getStatus());
                            }
                        }
                        visited.add(resource);
                        file = (IFile)resource;
                        cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
                        if (cvsFile.isManaged()) break block5;
                        return true;
                    }
                    ResourceSyncInfo info = cvsFile.getSyncInfo();
                    Command.KSubstOption mode = info.getKeywordMode();
                    changes.add(new ModeChange(file, mode));
                    return true;
                }, 2, false);
            }
            catch (CoreException e) {
                CVSUIPlugin.openError(shell, CVSUIMessages.ModeWizard_2, null, e);
            }
            ++n2;
        }
        return changes;
    }

    @Override
    public boolean performFinish() {
        String comment;
        List changes;
        ArrayList messages;
        block11: {
            block10: {
                messages = new ArrayList();
                changes = this.fPage.getChanges();
                if (!changes.isEmpty()) break block10;
                return true;
            }
            comment = this.fPage.getComment(this.getShell());
            if (comment != null) break block11;
            return false;
        }
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(CVSUIMessages.ModeWizard_3, 10000);
                            Map changesPerProvider = ModeWizard.getProviderMapping(changes);
                            monitor.worked(1000);
                            int workPerProvider = 9000 / changesPerProvider.size();
                            for (Map.Entry entry : changesPerProvider.entrySet()) {
                                Map providerFiles;
                                CVSTeamProvider provider = (CVSTeamProvider)entry.getKey();
                                IStatus status = provider.setKeywordSubstitution(providerFiles = (Map)entry.getValue(), comment, Policy.subMonitorFor(monitor, workPerProvider));
                                if (status.getCode() == 0) continue;
                                messages.add(status);
                            }
                            CVSUIPlugin.broadcastPropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.team.cvs.ui.P_DECORATORS_CHANGED", null, null));
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
            if (!messages.isEmpty()) {
                MultiStatus statusToDisplay;
                boolean error = false;
                MultiStatus combinedStatus = new MultiStatus("org.eclipse.team.cvs.ui", 0, CVSUIMessages.ModeWizard_4, null);
                int i = 0;
                while (i < messages.size()) {
                    IStatus status = (IStatus)messages.get(i);
                    if (status.getSeverity() == 4 || status.getCode() == -10) {
                        error = true;
                    }
                    combinedStatus.merge(status);
                    ++i;
                }
                String message = null;
                if (combinedStatus.getChildren().length == 1) {
                    message = combinedStatus.getMessage();
                    statusToDisplay = combinedStatus.getChildren()[0];
                } else {
                    statusToDisplay = combinedStatus;
                }
                String title = error ? CVSUIMessages.ModeWizard_5 : CVSUIMessages.ModeWizard_6;
                CVSUIPlugin.openError(this.getShell(), title, message, new CVSException((IStatus)statusToDisplay));
            }
            return super.performFinish();
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        catch (InvocationTargetException e) {
            CVSUIPlugin.openError(this.getShell(), CVSUIMessages.ModeWizard_4, null, e);
            return false;
        }
    }

    static Map getProviderMapping(Collection changes) {
        HashMap table = new HashMap();
        for (ModeChange change : changes) {
            if (!change.hasChanged()) continue;
            IFile file = change.getFile();
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)file.getProject(), (String)CVSProviderPlugin.getTypeId());
            if (!table.containsKey(provider)) {
                table.put(provider, new HashMap());
            }
            Map providerMap = (Map)table.get(provider);
            providerMap.put(file, change.getNewMode());
        }
        return table;
    }

    public static class ModeChange {
        private final IFile fFile;
        private final Command.KSubstOption fMode;
        private Command.KSubstOption fNewMode;

        public ModeChange(IFile file, Command.KSubstOption mode) {
            this.fFile = file;
            this.fMode = mode;
            this.fNewMode = mode;
        }

        public IFile getFile() {
            return this.fFile;
        }

        public Command.KSubstOption getMode() {
            return this.fMode;
        }

        public Command.KSubstOption getNewMode() {
            return this.fNewMode;
        }

        public boolean hasChanged() {
            return !this.fMode.equals((Object)this.fNewMode);
        }

        public void setNewMode(Command.KSubstOption mode) {
            this.fNewMode = mode;
        }

        public int compareTo(Object o) {
            return this.fFile.getName().compareTo(((ModeChange)o).getFile().getName());
        }
    }
}

