/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RemoteProjectFolder;
import org.eclipse.ui.IWorkbenchPart;

public class ProjectMetaFileOperation
extends CVSOperation {
    private ICVSRemoteFolder[] remoteFolders;
    private boolean metaFileExists;
    private boolean retrieveContent;

    public static ICVSRemoteFolder[] updateFoldersWithProjectName(IWorkbenchPart part, ICVSRemoteFolder[] folders) throws InvocationTargetException, InterruptedException {
        ProjectMetaFileOperation op = new ProjectMetaFileOperation(part, folders, true);
        op.run();
        return op.getUpdatedFolders();
    }

    public ProjectMetaFileOperation(IWorkbenchPart part, ICVSRemoteFolder[] remoteFolders, boolean retrieveContent) {
        super(part);
        this.remoteFolders = remoteFolders;
        this.retrieveContent = retrieveContent;
    }

    private void checkForMetafileAndUpdateFoldersWithRemoteProjectName(ICVSRemoteFolder[] folders, IProgressMonitor monitor) throws CVSException {
        this.metaFileExists = false;
        monitor.beginTask(null, folders.length * 100);
        int i = 0;
        while (i < folders.length) {
            block26: {
                InputStream in;
                block24: {
                    RemoteFolder rf;
                    block25: {
                        ICVSRemoteFolder folder = (ICVSRemoteFolder)folders[i].forTag(folders[i].getTag());
                        try {
                            folder.members(Policy.subMonitorFor(monitor, 50));
                        }
                        catch (TeamException e) {
                            throw CVSException.wrapException((CoreException)((Object)e));
                        }
                        in = null;
                        ICVSRemoteFile remote = (ICVSRemoteFile)folder.getFile(".project");
                        this.metaFileExists = true;
                        if (!this.retrieveContent || !(folder instanceof RemoteFolder)) break block24;
                        rf = (RemoteFolder)folder;
                        in = remote.getContents(Policy.subMonitorFor(monitor, 50));
                        if (in != null && !monitor.isCanceled()) break block25;
                        try {
                            if (in == null) break;
                            in.close();
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    try {
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        IProjectDescription projectDesc = workspace.loadProjectDescription(in);
                        RemoteProjectFolder rpf = new RemoteProjectFolder(rf, projectDesc.getName());
                        folders[i] = rpf;
                    }
                    catch (TeamException teamException) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            break block26;
                        }
                        catch (IOException iOException) {}
                        break block26;
                    }
                    catch (CoreException coreException) {
                        try {}
                        catch (Throwable throwable) {
                            try {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {
                            if (in != null) {
                                in.close();
                            }
                            break block26;
                        }
                        catch (IOException iOException) {}
                        break block26;
                    }
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        monitor.done();
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        this.checkForMetafileAndUpdateFoldersWithRemoteProjectName(this.remoteFolders, monitor);
    }

    public boolean metaFileExists() {
        return this.metaFileExists;
    }

    public ICVSRemoteFolder[] getUpdatedFolders() {
        return this.remoteFolders;
    }

    @Override
    protected String getTaskName() {
        return CVSUIMessages.ProjectMetaFile_taskName;
    }

    @Override
    public boolean canRunAsJob() {
        return false;
    }
}

