/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeValue;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeWizardPage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class JavaAttributeWizard
extends Wizard {
    private static String STORE_SECTION = "JavaAttributeWizard";
    private String fClassName;
    private IProject fProject;
    private ISchemaAttribute fAttInfo;
    private IPluginModelBase fModel;
    protected NewTypeWizardPage fMainPage;

    public JavaAttributeWizard(JavaAttributeValue value) {
        this(value.getProject(), value.getModel(), value.getAttributeInfo(), value.getClassName());
    }

    public JavaAttributeWizard(IProject project, IPluginModelBase model, ISchemaAttribute attInfo, String className) {
        this.fClassName = className;
        this.fModel = model;
        this.fProject = project;
        this.fAttInfo = attInfo;
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWPPRJ_WIZ);
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setWindowTitle(PDEUIMessages.JavaAttributeWizard_wtitle);
        this.setNeedsProgressMonitor(true);
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    public void addPages() {
        this.fMainPage = new JavaAttributeWizardPage(this.fProject, this.fModel, this.fAttInfo, this.fClassName);
        this.addPage((IWizardPage)this.fMainPage);
        ((JavaAttributeWizardPage)this.fMainPage).init();
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                JavaAttributeWizard.this.fMainPage.createType(monitor);
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), (IRunnableWithProgress)op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
            IResource resource = this.fMainPage.getModifiedResource();
            if (resource != null) {
                this.selectAndReveal(resource);
                if (this.fProject.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject jProject = JavaCore.create((IProject)this.fProject);
                    IJavaElement jElement = jProject.findElement(resource.getProjectRelativePath().removeFirstSegments(1));
                    if (jElement != null) {
                        JavaUI.openInEditor((IJavaElement)jElement);
                    }
                } else if (resource instanceof IFile) {
                    IWorkbenchPage page = PDEPlugin.getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource), (boolean)true);
                }
            }
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
        catch (InterruptedException e) {
            PDEPlugin.logException(e);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return true;
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)PDEPlugin.getActiveWorkbenchWindow());
    }

    public String getQualifiedName() {
        if (this.fMainPage.getCreatedType() == null) {
            return null;
        }
        return this.fMainPage.getCreatedType().getFullyQualifiedName('$');
    }

    public String getQualifiedNameWithArgs() {
        String classArgs;
        String name = this.getQualifiedName();
        if (name == null) {
            return null;
        }
        if (this.fMainPage instanceof JavaAttributeWizardPage && (classArgs = ((JavaAttributeWizardPage)this.fMainPage).getClassArgs()) != null && classArgs.length() > 0) {
            return String.valueOf(name) + ':' + classArgs;
        }
        return name;
    }
}

