/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.m2e.core.ui.internal.markers.EditorAwareMavenProblemResolution;
import org.eclipse.m2e.core.ui.internal.markers.MavenProblemResolution;
import org.eclipse.m2e.editor.internal.markers.MarkerResolutionWrapper;
import org.eclipse.m2e.editor.xml.MvnIndexPlugin;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomQuickAssistProcessor
implements IQuickAssistProcessor {
    static final Logger log = LoggerFactory.getLogger(PomQuickAssistProcessor.class);

    public boolean canAssist(IQuickAssistInvocationContext arg0) {
        return true;
    }

    public boolean canFix(Annotation an) {
        MarkerAnnotation mark;
        String hint;
        return an instanceof MarkerAnnotation && (hint = (mark = (MarkerAnnotation)an).getMarker().getAttribute("editor_hint", null)) != null;
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext context) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Iterator annotationIterator = context.getSourceViewer().getAnnotationModel().getAnnotationIterator();
        while (annotationIterator.hasNext()) {
            Annotation annotation = (Annotation)annotationIterator.next();
            if (!(annotation instanceof MarkerAnnotation)) continue;
            MarkerAnnotation mark = (MarkerAnnotation)annotation;
            try {
                Position position = context.getSourceViewer().getAnnotationModel().getPosition(annotation);
                int lineNum = context.getSourceViewer().getDocument().getLineOfOffset(position.getOffset()) + 1;
                int currentLineNum = context.getSourceViewer().getDocument().getLineOfOffset(context.getOffset()) + 1;
                if (currentLineNum != lineNum) continue;
                this.collectResolutionProposals(proposals, mark, context);
            }
            catch (Exception e) {
                MvnIndexPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.m2e.editor.xml", "Exception in pom quick assist.", (Throwable)e));
            }
        }
        if (!proposals.isEmpty()) {
            return proposals.toArray(new ICompletionProposal[0]);
        }
        return null;
    }

    private void collectResolutionProposals(List<ICompletionProposal> proposals, MarkerAnnotation mark, IQuickAssistInvocationContext context) {
        if (MavenProblemResolution.hasResolutions((IMarker)mark.getMarker())) {
            List resolutions = MavenProblemResolution.getResolutions((IMarker)mark.getMarker());
            for (IMarkerResolution res : resolutions) {
                Object proposal = res instanceof ICompletionProposal ? (ICompletionProposal)res : new MarkerResolutionWrapper(res, mark.getMarker());
                if (proposal instanceof MavenProblemResolution) {
                    MavenProblemResolution mres = (MavenProblemResolution)proposal;
                    if (!mres.includeProposal(proposals) || !(proposal instanceof EditorAwareMavenProblemResolution)) continue;
                    EditorAwareMavenProblemResolution eres = (EditorAwareMavenProblemResolution)proposal;
                    eres.setQuickAssistContext(context);
                    continue;
                }
                proposals.add((ICompletionProposal)proposal);
            }
        }
    }

    public String getErrorMessage() {
        return null;
    }
}

