/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.utils.generator;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.utils.generator.Info;
import org.eclipse.jubula.tools.internal.utils.generator.ToolkitInfo;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;

public class ComponentInfo
extends Info
implements Comparable {
    public static final String HID_PREFIX = "SWING";
    private Component m_component;
    private int m_level;
    private String m_helpid;
    private String m_type;
    private String m_shortType;
    private ToolkitInfo m_tkInfo;

    public ComponentInfo(Component component, ToolkitInfo tkInfo) {
        this(component, 0, tkInfo);
    }

    public ComponentInfo(Component component, int level, ToolkitInfo tkInfo) {
        super(CompSystemI18n.getString(component.getType()));
        this.m_component = component;
        this.m_level = level;
        this.m_type = this.m_component.getType();
        String[] tokens = StringUtils.split((String)this.m_type, (char)'.');
        int tokenLength = tokens.length;
        this.m_shortType = tokenLength > 0 ? tokens[tokenLength - 1] : this.m_type;
        this.m_tkInfo = tkInfo;
        this.m_helpid = String.valueOf(this.m_tkInfo.getHelpid()) + "_" + this.m_shortType;
    }

    public Component getComponent() {
        return this.m_component;
    }

    public int getLevel() {
        return this.m_level;
    }

    public String getHelpid() {
        return this.m_helpid;
    }

    public int compareTo(Object o) {
        ComponentInfo rhs = (ComponentInfo)o;
        return this.getI18nName().compareTo(rhs.getI18nName());
    }

    public String getType() {
        return this.m_type;
    }

    public String getShortType() {
        return this.m_shortType;
    }

    public ToolkitInfo getTkInfo() {
        return this.m_tkInfo;
    }
}

