/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.jgit.awtui.CommitGraphPane;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.RevWalkTextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;

@Command(usage="usage_Glog")
class Glog
extends RevWalkTextBuiltin {
    final JFrame frame = new JFrame();
    final CommitGraphPane graphPane;

    Glog() {
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Glog.this.frame.dispose();
            }
        });
        this.graphPane = new CommitGraphPane();
        JScrollPane graphScroll = new JScrollPane((Component)this.graphPane);
        JPanel buttons = new JPanel(new FlowLayout());
        JButton repaint = new JButton();
        repaint.setText(CLIText.get().repaint);
        repaint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Glog.this.graphPane.repaint();
            }
        });
        buttons.add(repaint);
        JPanel world = new JPanel(new BorderLayout());
        world.add((Component)buttons, "South");
        world.add((Component)graphScroll, "Center");
        this.frame.getContentPane().add(world);
    }

    @Override
    protected int walkLoop() throws Exception {
        this.graphPane.getCommitList().source(this.walk);
        this.graphPane.getCommitList().fillTo(Integer.MAX_VALUE);
        this.frame.setTitle("[" + this.repoName() + "]");
        this.frame.pack();
        this.frame.setVisible(true);
        return this.graphPane.getCommitList().size();
    }

    @Override
    protected void show(RevCommit c) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected RevWalk createWalk() {
        if (this.objects) {
            throw Glog.die(CLIText.get().cannotUseObjectsWithGlog);
        }
        PlotWalk w = new PlotWalk(this.db);
        w.sort(RevSort.BOUNDARY, true);
        return w;
    }

    private String repoName() {
        File gitDir = this.db.getDirectory();
        if (gitDir == null) {
            return this.db.toString();
        }
        String n = gitDir.getName();
        if (".git".equals(n)) {
            n = gitDir.getParentFile().getName();
        }
        return n;
    }
}

