/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.inactive;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.gmf.internal.xpand.inactive.StreamDecoder;

public class ContentDescriber
implements ITextContentDescriber {
    private final Pattern myImportClause = Pattern.compile("IMPORT\\s+");

    public int describe(Reader contents, IContentDescription description) throws IOException {
        char[] lookahead = new char[1024];
        int count = contents.read(lookahead);
        if (count == 0 || count == -1) {
            return 1;
        }
        return this.checkSpecificToGMF(CharBuffer.wrap(lookahead, 0, count));
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        contents = StreamDecoder.ensureMarkSupported(contents);
        int check = 1;
        try {
            char[] lookahead = new char[1024];
            contents.mark(lookahead.length + 1);
            int count = new InputStreamReader(contents, Charset.forName("US-ASCII")).read(lookahead);
            if (count == 0 || count == -1) {
                return 1;
            }
            check = this.checkSpecificToGMF(CharBuffer.wrap(lookahead, 0, count));
            if (check == 0) {
                return 0;
            }
        }
        finally {
            contents.reset();
        }
        StreamDecoder sd = new StreamDecoder(contents, null);
        if (sd.getEncoding() == null) {
            return check;
        }
        if (description != null) {
            description.setProperty(IContentDescription.CHARSET, (Object)sd.getEncoding().name());
        }
        return 2;
    }

    public QualifiedName[] getSupportedOptions() {
        return null;
    }

    private int checkSpecificToGMF(CharSequence s) throws IOException {
        Matcher m = this.myImportClause.matcher(s);
        if (m.find()) {
            if (m.hitEnd() || m.end() >= s.length()) {
                return 1;
            }
            char firstNonSpace = s.charAt(m.end());
            return firstNonSpace == '\"' || firstNonSpace == '\'' ? 2 : 0;
        }
        return 1;
    }
}

