/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.gmf.internal.validate.AbstractValidator;
import org.eclipse.gmf.internal.validate.DebugOptions;
import org.eclipse.gmf.internal.validate.DefUtils;
import org.eclipse.gmf.internal.validate.GMFValidationPlugin;
import org.eclipse.gmf.internal.validate.LabelProvider;
import org.eclipse.gmf.internal.validate.Messages;
import org.eclipse.gmf.internal.validate.Trace;
import org.eclipse.gmf.validate.ValidationOptions;

public class ValidatorChain
implements EValidator {
    private static final String DIAGNOSTIC_SOURCE = "org.eclipse.gmf.validation.failure";
    private EValidator[] validatorList;
    private ValidationOptions options;

    public ValidatorChain(EValidator[] validators) {
        this(validators, null);
    }

    public ValidatorChain(EValidator[] validators, ValidationOptions options) {
        if (validators == null || validators.length == 0) {
            throw new IllegalArgumentException("No validators specified");
        }
        this.validatorList = new EValidator[validators.length];
        int i = 0;
        while (i < validators.length) {
            EValidator nextValidator = validators[i];
            if (nextValidator == null) {
                throw new IllegalArgumentException("null validator passed");
            }
            this.validatorList[i] = nextValidator;
            ++i;
        }
        this.options = options;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.options != null && context != null) {
            AbstractValidator.setOptions(this.options, context);
        }
        boolean result = true;
        int i = 0;
        while (i < this.validatorList.length) {
            EValidator nextValidator = this.validatorList[i];
            try {
                result &= nextValidator.validate(eClass, eObject, diagnostics, context);
            }
            catch (Exception e) {
                ValidatorChain.reportValidationFailure(eObject, diagnostics, e);
            }
            ++i;
        }
        return result;
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.options != null && context != null) {
            AbstractValidator.setOptions(this.options, context);
        }
        boolean result = true;
        int i = 0;
        while (i < this.validatorList.length) {
            EValidator nextValidator = this.validatorList[i];
            try {
                result &= nextValidator.validate(eDataType, value, diagnostics, context);
            }
            catch (Exception e) {
                ValidatorChain.reportValidationFailure(value, diagnostics, e);
            }
            ++i;
        }
        return result;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.options != null && context != null) {
            AbstractValidator.setOptions(this.options, context);
        }
        boolean result = true;
        int i = 0;
        while (i < this.validatorList.length) {
            EValidator nextValidator = this.validatorList[i];
            try {
                result &= nextValidator.validate(eObject, diagnostics, context);
            }
            catch (Exception e) {
                ValidatorChain.reportValidationFailure(eObject, diagnostics, e);
            }
            ++i;
        }
        return result;
    }

    private static void reportValidationFailure(Object objFailedToValidate, DiagnosticChain diagnostics, Exception failure) {
        String messagePtn = Messages.unexpectedValidationError;
        String objLabel = null;
        try {
            objLabel = LabelProvider.getTextLabel(objFailedToValidate);
        }
        catch (RuntimeException e) {
            objLabel = String.valueOf(objFailedToValidate);
            Trace.catching(DebugOptions.EXCEPTIONS_CATCHING, e);
        }
        IStatus status = GMFValidationPlugin.createStatus(4, 300, MessageFormat.format(messagePtn, objLabel), failure);
        diagnostics.add(DefUtils.statusToDiagnostic(status, DIAGNOSTIC_SOURCE, objFailedToValidate));
        GMFValidationPlugin.log(status);
        Trace.catching(DebugOptions.EXCEPTIONS_CATCHING, failure);
    }
}

