/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class ResourceLocationProvider {
    private final List<IResource> selectedResources = new ArrayList<IResource>();
    private final List<URI> selectedURIs = new ArrayList<URI>();

    public ResourceLocationProvider(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            for (Object element : ((IStructuredSelection)selection).toList()) {
                if (element instanceof IResource) {
                    this.selectedResources.add((IResource)element);
                    continue;
                }
                if (!(element instanceof URI)) continue;
                this.selectedURIs.add((URI)element);
            }
        }
    }

    public List<IFile> getSelectedFiles(String extension, boolean explicit) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        if (extension == null) {
            return files;
        }
        this.addFiles(files, this.selectedResources, extension);
        if (!explicit) {
            this.addContainers(files, this.selectedResources, extension);
        }
        return files;
    }

    protected void addFiles(List<IFile> files, List<? extends IResource> resources, String extension) {
        for (IResource iResource : resources) {
            if (!(iResource instanceof IFile) || !extension.equals(((IFile)iResource).getFileExtension())) continue;
            files.add((IFile)iResource);
        }
    }

    protected void addContainers(List<IFile> files, List<? extends IResource> resources, String extension) {
        for (IResource iResource : resources) {
            if (!(iResource instanceof IContainer)) continue;
            try {
                List<IResource> members = Arrays.asList(((IContainer)iResource).members());
                this.addFiles(files, members, extension);
            }
            catch (CoreException coreException) {}
        }
    }

    public List<URI> getSelectedURIs(String extension, boolean explicit) {
        ArrayList<URI> uris = new ArrayList<URI>();
        if (extension == null) {
            return uris;
        }
        for (URI uri : this.selectedURIs) {
            if (!extension.equals(uri.fileExtension())) continue;
            uris.add(uri);
        }
        List<IFile> files = this.getSelectedFiles(extension, explicit);
        for (IFile file : files) {
            uris.add(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true));
        }
        return uris;
    }

    public final List<URI> getSelectedURIs(String extension) {
        return this.getSelectedURIs(extension, false);
    }
}

