/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.ui;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.internal.common.ui.Messages;
import org.eclipse.gmf.internal.common.ui.ModelSelectionPage;
import org.eclipse.gmf.internal.common.ui.ModelSelectionPageExtension;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class PredefinedModelExtension
implements ModelSelectionPageExtension {
    protected final ModelSelectionPage page;
    protected final List<URI> uris;

    public PredefinedModelExtension(ModelSelectionPage page, List<URI> uris) {
        this.page = page;
        this.uris = uris;
    }

    protected String getLabelText() {
        return Messages.PredefinedModelExtensionPredefinedModels;
    }

    @Override
    public void createControl(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        plate.setLayoutData((Object)data);
        plate.setLayout((Layout)new GridLayout());
        ExpandableComposite hlSection = new ExpandableComposite(plate, 0, 2);
        hlSection.setText(this.getLabelText());
        hlSection.setLayoutData((Object)new GridData());
        Composite hlPlate = new Composite((Composite)hlSection, 0);
        hlPlate.setLayout((Layout)new GridLayout());
        hlSection.setClient((Control)hlPlate);
        hlSection.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent e) {
                Composite pc = (Composite)PredefinedModelExtension.this.page.getControl();
                pc.layout(true, true);
            }

            public void expansionStateChanging(ExpansionEvent e) {
            }
        });
        for (URI uri : this.uris) {
            this.createHyperlink(hlPlate, uri);
        }
    }

    protected Hyperlink createHyperlink(Composite parent, final URI uri) {
        final Hyperlink hyperlink = new Hyperlink(parent, 0);
        hyperlink.setForeground(this.page.getShell().getDisplay().getSystemColor(9));
        hyperlink.setText(uri.toString());
        hyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                PredefinedModelExtension.this.setPredefinedModelURI(uri);
            }

            public void linkEntered(HyperlinkEvent e) {
                hyperlink.setUnderlined(true);
            }

            public void linkExited(HyperlinkEvent e) {
                hyperlink.setUnderlined(false);
            }
        });
        GridData data = new GridData();
        hyperlink.setLayoutData((Object)data);
        return hyperlink;
    }

    protected void setPredefinedModelURI(URI uri) {
        this.page.setURI(uri);
        this.page.updateURI();
    }

    @Override
    public void setResource(Resource resource) {
    }
}

