/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui;

import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.internal.security.ui.SecurityUIMsg;
import org.eclipse.equinox.internal.security.ui.X509CertificateAttribute;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;

public class X509CertificateAttributeContentProvider
implements IStructuredContentProvider {
    private static String LABEL_KEYUSAGE_DIGITALSIGNATURE = "digitalSignature";
    private static String LABEL_KEYUSAGE_NONREPUDIATION = "nonRepudiation";
    private static String LABEL_KEYUSAGE_KEYENCIPHERMENT = "keyEncipherment";
    private static String LABEL_KEYUSAGE_DATAENCIPHERMENT = "dataEncipherment";
    private static String LABEL_KEYUSAGE_KEYAGREEMENT = "keyAgreement";
    private static String LABEL_KEYUSAGE_CERTSIGN = "keyCertSign";
    private static String LABEL_KEYUSAGE_CRLSIGN = "cRLSign";
    private static String LABEL_KEYUSAGE_ENCIPHERONLY = "encipherOnly";
    private static String LABEL_KEYUSAGE_DECIPHERONLY = "decipherOnly";
    private ArrayList<X509CertificateAttribute> elements = new ArrayList();
    private Viewer viewer = null;
    private static String listDelim = ", ";
    private static final DateFormat _df = DateFormat.getDateTimeInstance(1, 0);
    private static String[] keyUsageStrings = new String[]{LABEL_KEYUSAGE_DIGITALSIGNATURE, LABEL_KEYUSAGE_NONREPUDIATION, LABEL_KEYUSAGE_KEYENCIPHERMENT, LABEL_KEYUSAGE_DATAENCIPHERMENT, LABEL_KEYUSAGE_KEYAGREEMENT, LABEL_KEYUSAGE_CERTSIGN, LABEL_KEYUSAGE_CRLSIGN, LABEL_KEYUSAGE_ENCIPHERONLY, LABEL_KEYUSAGE_DECIPHERONLY};

    public Object[] getElements(Object inputElement) {
        return this.elements.toArray();
    }

    public void dispose() {
    }

    public void setSelection(X509Certificate curCert) {
        this.inputChanged(this.viewer, null, curCert);
        if (this.viewer != null) {
            this.viewer.refresh();
        }
    }

    public void clear(boolean refresh) {
        this.elements.clear();
        if (refresh && this.viewer != null) {
            this.viewer.refresh();
        }
    }

    public void clear() {
        this.clear(true);
    }

    public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        this.viewer = aViewer;
        this.clear(false);
        if (newInput instanceof X509Certificate) {
            X509Certificate theCert = (X509Certificate)newInput;
            X509CertificateAttribute ver = new X509CertificateAttribute(SecurityUIMsg.CERTPROP_X509_VERSION, Integer.valueOf(theCert.getVersion()).toString());
            this.elements.add(ver);
            X509CertificateAttribute serialNum = new X509CertificateAttribute(SecurityUIMsg.CERTPROP_X509_SERIAL_NUM, theCert.getSerialNumber().toString());
            this.elements.add(serialNum);
            X509CertificateAttribute validFrom = new X509CertificateAttribute(SecurityUIMsg.CERTPROP_X509_VALID_FROM, _df.format(theCert.getNotBefore()), theCert.getNotBefore());
            this.elements.add(validFrom);
            X509CertificateAttribute validTo = new X509CertificateAttribute(SecurityUIMsg.CERTPROP_X509_VALID_TO, _df.format(theCert.getNotAfter()), theCert.getNotAfter());
            this.elements.add(validTo);
            X509CertificateAttribute issuedBy = new X509CertificateAttribute(SecurityUIMsg.CERTPROP_X509_ISSUED_BY, theCert.getIssuerX500Principal().getName(), theCert.getIssuerX500Principal());
            this.elements.add(issuedBy);
            X509CertificateAttribute IssuedToItem = new X509CertificateAttribute(SecurityUIMsg.CERTPROP_X509_ISSUED_TO, theCert.getSubjectX500Principal().getName(), theCert.getSubjectX500Principal());
            this.elements.add(IssuedToItem);
            X509CertificateAttribute sigAlgoItem = new X509CertificateAttribute(SecurityUIMsg.CERTPROP_X509_SIG_ALGO, theCert.getSigAlgName());
            this.elements.add(sigAlgoItem);
            boolean[] keyUsagesArray = theCert.getKeyUsage();
            StringBuffer keyUsages = new StringBuffer();
            if (keyUsagesArray != null && keyUsagesArray.length > 0) {
                int i = 0;
                while (i < keyUsagesArray.length) {
                    if (keyUsagesArray[i]) {
                        keyUsages.append(String.valueOf(keyUsageStrings[i]) + listDelim);
                    }
                    ++i;
                }
                X509CertificateAttribute keyUsage = new X509CertificateAttribute(SecurityUIMsg.CERTPROP_X509_KEY_USAGE, keyUsages.toString().substring(0, keyUsages.length() - 2), theCert.getKeyUsage());
                this.elements.add(keyUsage);
            }
            X509CertificateAttribute thumbPrintItem = new X509CertificateAttribute(SecurityUIMsg.CERTPROP_X509_THMBPRINT, this.getThumbprint(theCert, "SHA1"));
            this.elements.add(thumbPrintItem);
            PublicKey pubKey = theCert.getPublicKey();
            X509CertificateAttribute pubKeyInfoItem = new X509CertificateAttribute(SecurityUIMsg.CERTPROP_X509_THMBPRINTX509_PUBKEY_INFO, this.getHex(pubKey.getEncoded()));
            this.elements.add(pubKeyInfoItem);
            try {
                Collection<List<?>> subAltNamesVctr = theCert.getSubjectAlternativeNames();
                if (subAltNamesVctr != null && subAltNamesVctr.size() > 0) {
                    X509CertificateAttribute subAltItem = new X509CertificateAttribute(SecurityUIMsg.CERTPROP_X509_SUB_ALT_NAMES, "Has Subject Alternate Names", theCert.getSubjectAlternativeNames());
                    this.elements.add(subAltItem);
                }
            }
            catch (CertificateParsingException e1) {
                e1.printStackTrace();
            }
            int basicCnstrnts = theCert.getBasicConstraints();
            Integer basicConstraint = basicCnstrnts;
            StringBuffer basicCnstrntsBfr = new StringBuffer();
            if (basicCnstrnts == -1) {
                basicCnstrntsBfr.append(String.valueOf(SecurityUIMsg.LABEL_NAMECONSTRAINTS_NOTCA) + listDelim);
            } else {
                basicCnstrntsBfr.append(String.valueOf(SecurityUIMsg.LABEL_NAMECONSTRAINTS_ISCA) + listDelim);
                if (basicCnstrnts == Integer.MAX_VALUE) {
                    basicCnstrntsBfr.append(String.valueOf(NLS.bind((String)SecurityUIMsg.LABEL_NAMECONSTRAINTS_PATHLENGTH, (Object[])new Object[]{SecurityUIMsg.LABEL_NAMECONSTRAINTS_PATHLENGTH_UNLIMITED})) + listDelim);
                } else {
                    basicCnstrntsBfr.append(String.valueOf(NLS.bind((String)SecurityUIMsg.LABEL_NAMECONSTRAINTS_PATHLENGTH, (Object[])new Object[]{basicConstraint})) + listDelim);
                }
            }
            X509CertificateAttribute basicConstraints = new X509CertificateAttribute(SecurityUIMsg.CERTPROP_X509_BASIC_CNSTRNTS, basicCnstrntsBfr.toString().substring(0, basicCnstrntsBfr.length() - 2), basicConstraint);
            this.elements.add(basicConstraints);
            try {
                List<String> exKeyUsg = theCert.getExtendedKeyUsage();
                StringBuffer exKeyUsgBfr = new StringBuffer();
                if (exKeyUsg != null && exKeyUsg.size() > 0) {
                    Iterator<String> exKeyUsgIter = exKeyUsg.iterator();
                    while (exKeyUsgIter.hasNext()) {
                        exKeyUsgBfr.append(String.valueOf(exKeyUsgIter.next()) + listDelim);
                    }
                    X509CertificateAttribute exKeyUsgProp = new X509CertificateAttribute(SecurityUIMsg.CERTPROP_X509_EXKEY_USAGE, exKeyUsgBfr.toString().substring(0, exKeyUsgBfr.length() - 2), theCert.getExtendedKeyUsage());
                    this.elements.add(exKeyUsgProp);
                }
            }
            catch (CertificateParsingException e) {
                e.printStackTrace();
            }
        }
    }

    private String getHex(byte[] buf) {
        String result = "";
        if (buf != null) {
            int i = 0;
            while (i < buf.length) {
                if (i > 0) {
                    result = String.valueOf(result) + " ";
                }
                byte sValue = buf[i];
                int curInt = 0;
                String converted = Integer.toHexString(curInt += sValue);
                if (converted.length() > 2) {
                    converted = converted.substring(converted.length() - 2);
                }
                result = String.valueOf(result) + converted.toUpperCase();
                ++i;
            }
        }
        return result;
    }

    private MessageDigest getDigest(String thumAlg) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(thumAlg);
        }
        catch (Exception exception) {}
        return md;
    }

    private String getThumbprint(X509Certificate curCert, String thumAlg) {
        String thumbPrint = "";
        try {
            MessageDigest md = this.getDigest(thumAlg);
            md.update(curCert.getEncoded());
            byte[] rawDigest = md.digest();
            thumbPrint = this.getHex(rawDigest);
        }
        catch (Exception exception) {}
        return thumbPrint;
    }
}

