/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import org.eclipse.equinox.internal.cm.ConfigurationAdminFactory;
import org.eclipse.equinox.internal.cm.ConfigurationAdminImpl;
import org.eclipse.equinox.internal.cm.ConfigurationImpl;
import org.eclipse.equinox.internal.cm.ConfigurationStore;
import org.eclipse.equinox.internal.cm.SerializedTaskQueue;
import org.eclipse.equinox.internal.cm.TargetMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;

class ManagedServiceFactoryTracker
extends ServiceTracker<ManagedServiceFactory, ManagedServiceFactory> {
    final ConfigurationAdminFactory configurationAdminFactory;
    private final ConfigurationStore configurationStore;
    private final TargetMap targets = new TargetMap();
    private final SerializedTaskQueue queue = new SerializedTaskQueue("ManagedServiceFactory Update Queue");

    public ManagedServiceFactoryTracker(ConfigurationAdminFactory configurationAdminFactory, ConfigurationStore configurationStore, BundleContext context) {
        super(context, ManagedServiceFactory.class.getName(), null);
        this.configurationAdminFactory = configurationAdminFactory;
        this.configurationStore = configurationStore;
    }

    void notifyDeleted(ConfigurationImpl config) {
        config.checkLocked();
        String configLoc = config.getLocation();
        if (configLoc == null) {
            return;
        }
        boolean isMultiple = configLoc.startsWith("?");
        String factoryPid = config.getFactoryPid(false);
        List<ServiceReference<ManagedServiceFactory>> references = this.getManagedServiceFactoryReferences(factoryPid);
        for (ServiceReference<ManagedServiceFactory> ref : references) {
            if (this.hasMoreSpecificConfigPids(ref, factoryPid)) continue;
            boolean hasLocPermission = this.configurationAdminFactory.checkTargetPermission(configLoc, ref);
            ManagedServiceFactory serviceFactory = (ManagedServiceFactory)this.getService(ref);
            if (!hasLocPermission || serviceFactory == null || !isMultiple && !ConfigurationAdminImpl.getLocation(ref.getBundle()).equals(configLoc)) continue;
            this.asynchDeleted(serviceFactory, config.getPid(false));
        }
    }

    void notifyUpdated(ConfigurationImpl config) {
        config.checkLocked();
        String configLoc = config.getLocation();
        boolean isMultiple = configLoc != null && configLoc.startsWith("?");
        String factoryPid = config.getFactoryPid();
        List<ServiceReference<ManagedServiceFactory>> references = this.getManagedServiceFactoryReferences(factoryPid);
        for (ServiceReference<ManagedServiceFactory> ref : references) {
            if (this.hasMoreSpecificConfigPids(ref, factoryPid)) continue;
            boolean hasLocPermission = this.configurationAdminFactory.checkTargetPermission(configLoc, ref);
            ManagedServiceFactory serviceFactory = (ManagedServiceFactory)this.getService(ref);
            if (!hasLocPermission || serviceFactory == null || !isMultiple && !config.bind(ConfigurationAdminImpl.getLocation(ref.getBundle()))) continue;
            Dictionary<String, Object> properties = this.configurationAdminFactory.modifyConfiguration(ref, config);
            this.asynchUpdated(serviceFactory, config.getPid(), properties);
        }
    }

    void notifyUpdateLocation(ConfigurationImpl config, String oldLocation) {
        config.checkLocked();
        String configLoc = config.getLocation();
        if (configLoc == null ? oldLocation == null : configLoc.equals(oldLocation)) {
            return;
        }
        boolean oldIsMultiple = oldLocation != null && oldLocation.startsWith("?");
        boolean newIsMultiple = configLoc != null && configLoc.startsWith("?");
        String factoryPid = config.getFactoryPid();
        List<ServiceReference<ManagedServiceFactory>> references = this.getManagedServiceFactoryReferences(factoryPid);
        for (ServiceReference<ManagedServiceFactory> ref : references) {
            if (this.hasMoreSpecificConfigPids(ref, factoryPid)) continue;
            boolean hasOldPermission = this.configurationAdminFactory.checkTargetPermission(oldLocation, ref);
            boolean hasNewPermission = this.configurationAdminFactory.checkTargetPermission(configLoc, ref);
            ManagedServiceFactory serviceFactory = (ManagedServiceFactory)this.getService(ref);
            if (serviceFactory == null) continue;
            boolean delete = false;
            boolean update = false;
            String targetLocation = ConfigurationAdminImpl.getLocation(ref.getBundle());
            if (hasOldPermission != hasNewPermission) {
                if (hasOldPermission) {
                    delete = oldIsMultiple || targetLocation.equals(oldLocation);
                } else {
                    update = newIsMultiple || config.bind(targetLocation);
                }
            } else if (targetLocation.equals(oldLocation)) {
                delete = true;
            } else {
                boolean bl = update = newIsMultiple || config.bind(targetLocation);
            }
            if (delete) {
                this.asynchDeleted(serviceFactory, config.getPid());
                continue;
            }
            if (!update) continue;
            Dictionary<String, Object> properties = this.configurationAdminFactory.modifyConfiguration(ref, config);
            this.asynchUpdated(serviceFactory, config.getPid(), properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMoreSpecificConfigPids(ServiceReference<ManagedServiceFactory> ref, String pid) {
        List<List<String>> qualifiedPidsLists;
        TargetMap targetMap = this.targets;
        synchronized (targetMap) {
            qualifiedPidsLists = this.targets.getQualifiedPids(ref);
        }
        block3: for (List<String> qualifiedPids : qualifiedPidsLists) {
            for (String qualifiedPid : qualifiedPids) {
                if (qualifiedPid.length() <= pid.length() || !qualifiedPid.startsWith(pid)) continue block3;
                ConfigurationImpl config = this.configurationStore.findConfiguration(qualifiedPid);
                if (config == null) continue;
                return true;
            }
        }
        return false;
    }

    public ManagedServiceFactory addingService(ServiceReference<ManagedServiceFactory> reference) {
        ManagedServiceFactory service = (ManagedServiceFactory)this.context.getService(reference);
        if (service == null) {
            return null;
        }
        this.addReference(reference, service);
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference<ManagedServiceFactory> reference, ManagedServiceFactory service) {
        List<String> newPids = TargetMap.getPids(reference.getProperty("service.pid"));
        TargetMap targetMap = this.targets;
        synchronized (targetMap) {
            List<List<String>> previousPids = this.targets.getQualifiedPids(reference);
            if (newPids.size() == previousPids.size()) {
                boolean foundAll = false;
                for (String newPid : newPids) {
                    foundAll = false;
                    for (List<String> pids : previousPids) {
                        if (!pids.contains(newPid)) continue;
                        foundAll = true;
                        break;
                    }
                    if (!foundAll) break;
                }
                if (foundAll) {
                    return;
                }
            }
        }
        this.untrackManagedServiceFactory(reference);
        this.addingService(reference);
    }

    public void removedService(ServiceReference<ManagedServiceFactory> reference, ManagedServiceFactory service) {
        this.untrackManagedServiceFactory(reference);
        this.context.ungetService(reference);
    }

    private void addReference(ServiceReference<ManagedServiceFactory> reference, ManagedServiceFactory service) {
        List<List<String>> qualifiedPidLists = this.trackManagedServiceFactory(reference);
        this.updateManagedServiceFactory(qualifiedPidLists, reference, service);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateManagedServiceFactory(List<List<String>> qualifiedPidLists, ServiceReference<ManagedServiceFactory> reference, ManagedServiceFactory serviceFactory) {
        block3: for (List<String> qualifiedPids : qualifiedPidLists) {
            var7_7 = qualifiedPids.iterator();
            if (!var7_7.hasNext()) continue;
            qualifiedPid = var7_7.next();
            configs = this.configurationStore.getFactoryConfigurations(qualifiedPid);
            try {
                i = 0;
                while (i < configs.length) {
                    configs[i].lock();
                    ++i;
                }
                foundConfig = false;
                i = 0;
                while (i < configs.length) {
                    if (!configs[i].isDeleted()) {
                        location = configs[i].getLocation();
                        shouldBind = location == null || location.startsWith("?") == false;
                        hasLocPermission = this.configurationAdminFactory.checkTargetPermission(location, reference);
                        if (hasLocPermission) {
                            if (shouldBind && configs[i].bind(ConfigurationAdminImpl.getLocation(reference.getBundle())) || !shouldBind) {
                                properties = this.configurationAdminFactory.modifyConfiguration(reference, configs[i]);
                                this.asynchUpdated(serviceFactory, configs[i].getPid(), properties);
                                foundConfig = true;
                            } else {
                                this.configurationAdminFactory.log(2, "Configuration for service.pid=" + configs[i].getPid() + " could not be bound to " + ConfigurationAdminImpl.getLocation(reference.getBundle()));
                            }
                        }
                    }
                    ++i;
                }
                if (foundConfig) {
                }
            }
            finally {
                i = 0;
                ** while (i < configs.length)
            }
lbl-1000:
            // 1 sources

            {
                configs[i].unlock();
                ++i;
                continue;
lbl37:
                // 1 sources

            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<String>> trackManagedServiceFactory(ServiceReference<ManagedServiceFactory> reference) {
        TargetMap targetMap = this.targets;
        synchronized (targetMap) {
            return this.targets.add(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrackManagedServiceFactory(ServiceReference<ManagedServiceFactory> reference) {
        TargetMap targetMap = this.targets;
        synchronized (targetMap) {
            this.targets.remove(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServiceReference<ManagedServiceFactory>> getManagedServiceFactoryReferences(String pid) {
        TargetMap targetMap = this.targets;
        synchronized (targetMap) {
            List<ServiceReference<ManagedServiceFactory>> temp;
            List<ServiceReference<ManagedServiceFactory>> refs = temp = this.targets.getTargets(pid);
            Collections.sort(refs, Collections.reverseOrder());
            return refs;
        }
    }

    private void asynchDeleted(final ManagedServiceFactory service, final String pid) {
        this.queue.put(new Runnable(){

            @Override
            public void run() {
                try {
                    service.deleted(pid);
                }
                catch (Throwable t) {
                    ManagedServiceFactoryTracker.this.configurationAdminFactory.log(1, t.getMessage(), t);
                }
            }
        });
    }

    private void asynchUpdated(final ManagedServiceFactory service, final String pid, final Dictionary<String, Object> properties) {
        if (properties == null) {
            return;
        }
        this.queue.put(new Runnable(){

            @Override
            public void run() {
                try {
                    service.updated(pid, properties);
                }
                catch (ConfigurationException e) {
                    Throwable cause = e.getCause();
                    ManagedServiceFactoryTracker.this.configurationAdminFactory.log(1, e.getMessage(), cause != null ? cause : e);
                }
                catch (Throwable t) {
                    ManagedServiceFactoryTracker.this.configurationAdminFactory.log(1, t.getMessage(), t);
                }
            }
        });
    }
}

