/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.postprocessor.factories;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.internal.postprocessor.factories.IChangeFactory;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.util.CompareSwitch;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractChangeFactory
implements IChangeFactory {
    private CompareSwitch<DifferenceKind> differenceKindCompareSwitch = new DifferenceKindCompareSwitch();

    @Override
    public boolean handles(Diff input) {
        return this.getRelatedExtensionKind(input) != null;
    }

    @Override
    public Diff create(Diff input) {
        Diff ret = this.createExtension();
        DifferenceKind extensionKind = this.getRelatedExtensionKind(input);
        ret.setKind(extensionKind);
        ret.setSource(input.getSource());
        this.setRefiningChanges(ret, extensionKind, input);
        return ret;
    }

    public abstract Diff createExtension();

    public abstract void setRefiningChanges(Diff var1, DifferenceKind var2, Diff var3);

    @Override
    public Match getParentMatch(Diff input) {
        return input.getMatch();
    }

    @Override
    public Class<? extends Diff> getExtensionKind() {
        return Diff.class;
    }

    @Override
    public void fillRequiredDifferences(Comparison comparison, Diff extension) {
        this.fillRequiredDifferencesForMacroToMacro(extension);
        this.fillRequiredDifferencesForUnitToMacro(extension);
    }

    private void fillRequiredDifferencesForMacroToMacro(Diff macro) {
        LinkedHashSet<Diff> requiredExtensions = new LinkedHashSet<Diff>();
        LinkedHashSet<Diff> requiringExtensions = new LinkedHashSet<Diff>();
        for (Diff refiningDiff : macro.getRefinedBy()) {
            requiredExtensions.addAll(this.getDistinctRefinedDifferences((List<Diff>)refiningDiff.getRequires()));
            requiringExtensions.addAll(this.getDistinctRefinedDifferences((List<Diff>)refiningDiff.getRequiredBy()));
        }
        requiredExtensions.remove(macro);
        requiringExtensions.remove(macro);
        macro.getRequires().addAll(Collections2.filter(requiredExtensions, EMFComparePredicates.fromSide(macro.getSource())));
        macro.getRequiredBy().addAll(Collections2.filter(requiringExtensions, EMFComparePredicates.fromSide(macro.getSource())));
    }

    private void fillRequiredDifferencesForUnitToMacro(Diff macro) {
        LinkedHashSet<Diff> requiredExtensions = new LinkedHashSet<Diff>();
        LinkedHashSet<Diff> requiringExtensions = new LinkedHashSet<Diff>();
        for (Diff refiningDiff : macro.getRefinedBy()) {
            for (Diff unit : refiningDiff.getRequires()) {
                if (!unit.getRefines().isEmpty()) continue;
                requiredExtensions.add(unit);
            }
            for (Diff unit : refiningDiff.getRequiredBy()) {
                if (!unit.getRefines().isEmpty()) continue;
                requiringExtensions.add(unit);
            }
        }
        macro.getRequires().addAll(Collections2.filter(requiredExtensions, EMFComparePredicates.fromSide(macro.getSource())));
        macro.getRequiredBy().addAll(Collections2.filter(requiringExtensions, EMFComparePredicates.fromSide(macro.getSource())));
    }

    protected DifferenceKind getRelatedExtensionKind(Diff input) {
        return this.differenceKindCompareSwitch.doSwitch(input);
    }

    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(ReferenceChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionAdd(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(AttributeChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionAdd(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionDelete(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionChange(ResourceAttachmentChange input) {
        return false;
    }

    protected boolean isRelatedToAnExtensionMove(ResourceAttachmentChange input) {
        return false;
    }

    protected Set<Diff> getAllContainedDifferences(Diff input) {
        LinkedHashSet<Diff> result = new LinkedHashSet<Diff>();
        Comparison comparison = ComparisonUtil.getComparison(input);
        CompareSwitch<EObject> valueGetter = new CompareSwitch<EObject>(){

            @Override
            public EObject caseReferenceChange(ReferenceChange object) {
                return object.getValue();
            }

            @Override
            public EObject caseResourceAttachmentChange(ResourceAttachmentChange object) {
                return MatchUtil.getContainer(ComparisonUtil.getComparison(object), object);
            }

            @Override
            public EObject defaultCase(EObject object) {
                return null;
            }
        };
        EObject value = (EObject)valueGetter.doSwitch(input);
        if (value != null) {
            Match match = comparison.getMatch(value);
            result.addAll(this.getAllContainedDifferences(comparison, match));
        }
        return result;
    }

    protected final List<Diff> findCrossReferences(Comparison comparison, EObject lookup, Predicate<Diff> p) {
        return Lists.newArrayList((Iterable)Iterables.filter(comparison.getDifferences(lookup), p));
    }

    private Set<Diff> getAllContainedDifferences(Comparison comparison, Match match) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        LinkedHashSet prune = Sets.newLinkedHashSet();
        for (Diff candidate : match.getDifferences()) {
            if (this.getExtensionKind().isInstance(candidate)) continue;
            if (this.getRelatedExtensionKind(candidate) == null) {
                result.add(candidate);
                continue;
            }
            if (!(candidate instanceof ReferenceChange) || !((ReferenceChange)candidate).getReference().isContainment()) continue;
            prune.add(comparison.getMatch(((ReferenceChange)candidate).getValue()));
        }
        for (Match submatch : match.getSubmatches()) {
            if (prune.contains(submatch)) continue;
            result.addAll(this.getAllContainedDifferences(comparison, submatch));
        }
        return result;
    }

    private Set<Diff> getDistinctRefinedDifferences(List<Diff> refiningDifferences) {
        Iterator<Diff> unitDiffs = refiningDifferences.iterator();
        LinkedHashSet<Diff> extensions = new LinkedHashSet<Diff>();
        while (unitDiffs.hasNext()) {
            Diff unitDiff = unitDiffs.next();
            extensions.addAll((Collection<Diff>)unitDiff.getRefines());
        }
        return extensions;
    }

    private class DifferenceKindCompareSwitch
    extends CompareSwitch<DifferenceKind> {
        private DifferenceKindCompareSwitch() {
        }

        @Override
        public DifferenceKind caseAttributeChange(AttributeChange object) {
            DifferenceKind result = AbstractChangeFactory.this.isRelatedToAnExtensionAdd(object) ? DifferenceKind.ADD : (AbstractChangeFactory.this.isRelatedToAnExtensionDelete(object) ? DifferenceKind.DELETE : (AbstractChangeFactory.this.isRelatedToAnExtensionChange(object) ? DifferenceKind.CHANGE : (AbstractChangeFactory.this.isRelatedToAnExtensionMove(object) ? DifferenceKind.MOVE : (DifferenceKind)((Object)super.caseAttributeChange(object)))));
            return result;
        }

        @Override
        public DifferenceKind caseReferenceChange(ReferenceChange object) {
            DifferenceKind result = AbstractChangeFactory.this.isRelatedToAnExtensionAdd(object) ? DifferenceKind.ADD : (AbstractChangeFactory.this.isRelatedToAnExtensionDelete(object) ? DifferenceKind.DELETE : (AbstractChangeFactory.this.isRelatedToAnExtensionChange(object) ? DifferenceKind.CHANGE : (AbstractChangeFactory.this.isRelatedToAnExtensionMove(object) ? DifferenceKind.MOVE : (DifferenceKind)((Object)super.caseReferenceChange(object)))));
            return result;
        }

        @Override
        public DifferenceKind caseResourceAttachmentChange(ResourceAttachmentChange object) {
            DifferenceKind result = AbstractChangeFactory.this.isRelatedToAnExtensionAdd(object) ? DifferenceKind.ADD : (AbstractChangeFactory.this.isRelatedToAnExtensionDelete(object) ? DifferenceKind.DELETE : (AbstractChangeFactory.this.isRelatedToAnExtensionChange(object) ? DifferenceKind.CHANGE : (AbstractChangeFactory.this.isRelatedToAnExtensionMove(object) ? DifferenceKind.MOVE : (DifferenceKind)((Object)super.caseResourceAttachmentChange(object)))));
            return result;
        }
    }
}

