/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.op.ConnectProviderOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.AbstractGitCloneWizard;
import org.eclipse.egit.ui.internal.clone.GitCloneSourceProviderExtension;
import org.eclipse.egit.ui.internal.clone.GitCreateGeneralProjectPage;
import org.eclipse.egit.ui.internal.clone.GitProjectsImportPage;
import org.eclipse.egit.ui.internal.clone.GitSelectRepositoryPage;
import org.eclipse.egit.ui.internal.clone.GitSelectWizardPage;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.egit.ui.internal.clone.ProjectUtils;
import org.eclipse.egit.ui.internal.provisional.wizards.GitRepositoryInfo;
import org.eclipse.egit.ui.internal.provisional.wizards.IRepositorySearchResult;
import org.eclipse.egit.ui.internal.provisional.wizards.NoRepositoryInfoException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;

public class GitImportWizard
extends AbstractGitCloneWizard
implements IImportWizard {
    private static final String GIT_IMPORT_SECTION = "GitImportWizard";
    private GitSelectRepositoryPage selectRepoPage = new GitSelectRepositoryPage(false);
    private GitSelectWizardPage importWithDirectoriesPage = new GitSelectWizardPage(){

        public void setVisible(boolean visible) {
            if (GitImportWizard.this.existingRepo == null && visible && GitImportWizard.this.cloneDestination.cloneSettingsChanged()) {
                GitImportWizard.this.setCallerRunsCloneOperation(true);
                try {
                    final GitRepositoryInfo repositoryInfo = GitImportWizard.this.currentSearchResult.getGitRepositoryInfo();
                    GitImportWizard.this.performClone(repositoryInfo);
                    GitImportWizard.this.importWithDirectoriesPage.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            GitImportWizard.this.runCloneOperation(this.getContainer(), repositoryInfo);
                            (this).GitImportWizard.this.cloneDestination.saveSettingsForClonedRepo();
                        }
                    });
                }
                catch (URISyntaxException e) {
                    Activator.error(UIText.GitImportWizard_errorParsingURI, e);
                }
                catch (NoRepositoryInfoException e) {
                    Activator.error(UIText.GitImportWizard_noRepositoryInfo, e);
                }
                catch (Exception e) {
                    Activator.error(e.getMessage(), e);
                }
            }
            super.setVisible(visible);
        }
    };
    private GitProjectsImportPage projectsImportPage = new GitProjectsImportPage(){

        public void setVisible(boolean visible) {
            if (visible) {
                this.setProjectsList(GitImportWizard.this.importWithDirectoriesPage.getPath());
            }
            super.setVisible(visible);
        }
    };
    private GitCreateGeneralProjectPage createGeneralProjectPage = new GitCreateGeneralProjectPage(){

        @Override
        public void setVisible(boolean visible) {
            if (visible) {
                this.setPath(GitImportWizard.this.importWithDirectoriesPage.getPath());
            }
            super.setVisible(visible);
        }
    };
    private Repository existingRepo;

    public GitImportWizard() {
        this(null);
    }

    public GitImportWizard(IRepositorySearchResult searchResult) {
        super(searchResult);
        this.setWindowTitle(UIText.GitImportWizard_WizardTitle);
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
        this.setDialogSettings(GitImportWizard.getImportWizardDialogSettings());
    }

    @Override
    protected void addPreClonePages() {
        if (!this.hasSearchResult()) {
            this.addPage((IWizardPage)this.selectRepoPage);
        }
    }

    @Override
    protected void addPostClonePages() {
        this.addPage((IWizardPage)this.importWithDirectoriesPage);
        this.addPage((IWizardPage)this.projectsImportPage);
        this.addPage((IWizardPage)this.createGeneralProjectPage);
    }

    @Override
    protected List<GitCloneSourceProviderExtension.CloneSourceProvider> getCloneSourceProviders() {
        List<GitCloneSourceProviderExtension.CloneSourceProvider> cloneSourceProvider = super.getCloneSourceProviders();
        cloneSourceProvider.add(0, GitCloneSourceProviderExtension.CloneSourceProvider.LOCAL);
        return cloneSourceProvider;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectRepoPage) {
            this.existingRepo = this.selectRepoPage.getRepository();
            this.importWithDirectoriesPage.setRepository(this.selectRepoPage.getRepository());
            return this.importWithDirectoriesPage;
        }
        if (page == this.cloneDestination) {
            this.existingRepo = null;
            this.importWithDirectoriesPage.setRepository(this.getTargetRepository());
            return this.importWithDirectoriesPage;
        }
        if (page == this.importWithDirectoriesPage) {
            switch (this.importWithDirectoriesPage.getWizardSelection()) {
                case 0: {
                    return this.projectsImportPage;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.createGeneralProjectPage;
                }
            }
        } else if (page == this.createGeneralProjectPage || page == this.projectsImportPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    private Repository getTargetRepository() {
        if (this.existingRepo != null) {
            return this.existingRepo;
        }
        try {
            return org.eclipse.egit.core.Activator.getDefault().getRepositoryCache().lookupRepository(new File(this.cloneDestination.getDestinationFile(), ".git"));
        }
        catch (IOException e) {
            Activator.error("Error looking up repository at " + this.cloneDestination.getDestinationFile(), e);
            return null;
        }
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    GitImportWizard.this.importProjects(monitor);
                }
            });
        }
        catch (InvocationTargetException e) {
            Activator.handleError(e.getCause().getMessage(), e.getCause(), true);
            return false;
        }
        catch (InterruptedException e) {
            Activator.handleError(UIText.GitCreateProjectViaWizardWizard_AbortedMessage, e, true);
            return false;
        }
        return true;
    }

    public boolean canFinish() {
        switch (this.importWithDirectoriesPage.getWizardSelection()) {
            case 0: {
                return this.projectsImportPage.isPageComplete();
            }
            case 1: {
                return true;
            }
            case 2: {
                return this.createGeneralProjectPage.isPageComplete();
            }
        }
        return super.canFinish();
    }

    private void importProjects(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        switch (this.importWithDirectoriesPage.getWizardSelection()) {
            case 0: {
                final HashSet<ProjectRecord> projectsToCreate = new HashSet<ProjectRecord>();
                final ArrayList workingSets = new ArrayList();
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        projectsToCreate.addAll(GitImportWizard.this.projectsImportPage.getCheckedProjects());
                        IWorkingSet[] workingSetArray = GitImportWizard.this.projectsImportPage.getSelectedWorkingSets();
                        workingSets.addAll(Arrays.asList(workingSetArray));
                        GitImportWizard.this.projectsImportPage.saveWidgetValues();
                    }
                });
                ProjectUtils.createProjects(projectsToCreate, workingSets.toArray(new IWorkingSet[0]), monitor);
                break;
            }
            case 1: {
                final File[] repoDir = new File[1];
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        repoDir[0] = GitImportWizard.this.getTargetRepository().getDirectory();
                    }
                });
                final List<IProject> previousProjects = Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects());
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).run();
                    }
                });
                IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor actMonitor) throws CoreException {
                        IProject[] currentProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)actMonitor, (int)currentProjects.length);
                        IProject[] iProjectArray = currentProjects;
                        int n = currentProjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject current = iProjectArray[n2];
                            if (!previousProjects.contains(current)) {
                                ConnectProviderOperation cpo = new ConnectProviderOperation(current, repoDir[0]);
                                cpo.execute((IProgressMonitor)progress.newChild(1));
                            } else {
                                progress.worked(1);
                            }
                            ++n2;
                        }
                    }
                };
                try {
                    ResourcesPlugin.getWorkspace().run(wsr, monitor);
                    break;
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            case 2: {
                final String[] projectName = new String[1];
                final boolean[] defaultLocation = new boolean[1];
                final String[] path = new String[1];
                final File[] repoDir = new File[1];
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        projectName[0] = GitImportWizard.this.createGeneralProjectPage.getProjectName();
                        defaultLocation[0] = GitImportWizard.this.createGeneralProjectPage.isDefaultLocation();
                        path[0] = GitImportWizard.this.importWithDirectoriesPage.getPath();
                        repoDir[0] = GitImportWizard.this.getTargetRepository().getDirectory();
                    }
                });
                try {
                    IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

                        public void run(IProgressMonitor actMonitor) throws CoreException {
                            IProjectDescription desc = ResourcesPlugin.getWorkspace().newProjectDescription(projectName[0]);
                            desc.setLocation((IPath)new Path(path[0]));
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)actMonitor, (int)4);
                            IProject prj = ResourcesPlugin.getWorkspace().getRoot().getProject(desc.getName());
                            prj.create(desc, (IProgressMonitor)progress.newChild(1));
                            prj.open((IProgressMonitor)progress.newChild(1));
                            ConnectProviderOperation cpo = new ConnectProviderOperation(prj, repoDir[0]);
                            cpo.execute((IProgressMonitor)progress.newChild(1));
                            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(1, (IProgressMonitor)progress.newChild(1));
                        }
                    };
                    ResourcesPlugin.getWorkspace().run(wsr, monitor);
                    break;
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
    }

    static IDialogSettings getImportWizardDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = settings.getSection(GIT_IMPORT_SECTION);
        if (wizardSettings == null) {
            wizardSettings = settings.addNewSection(GIT_IMPORT_SECTION);
        }
        return wizardSettings;
    }
}

