/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.groups.RepositoryGroups;
import org.eclipse.egit.ui.internal.repository.RepositoriesView;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryGroupNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.RepositoryCache;
import org.eclipse.jgit.util.FS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class DropAdapterAssistant
extends CommonDropAdapterAssistant {
    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        String[] data;
        if (aTarget instanceof RepositoryGroupNode) {
            return this.handleRepositoryGroupNodeDrop((RepositoryGroupNode)aTarget, aDropTargetEvent);
        }
        if (aTarget instanceof IWorkspaceRoot) {
            return this.handleWorkspaceRootDrop(aDropTargetEvent);
        }
        String[] stringArray = data = (String[])aDropTargetEvent.data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            File dotgitfile;
            String folder = stringArray[n2];
            File repoFile = new File(folder);
            if (RepositoryCache.FileKey.isGitRepository((File)repoFile, (FS)FS.DETECTED)) {
                Activator.getDefault().getRepositoryUtil().addConfiguredRepository(repoFile);
            } else if (!repoFile.getName().equals(".git") && RepositoryCache.FileKey.isGitRepository((File)(dotgitfile = new File(repoFile, ".git")), (FS)FS.DETECTED)) {
                Activator.getDefault().getRepositoryUtil().addConfiguredRepository(dotgitfile);
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferData) {
        if (target instanceof RepositoryGroupNode) {
            return this.validateRepositoryGroupNodeDrop();
        }
        if (target instanceof IWorkspaceRoot) {
            return this.validateRepositoryGroupNodeDrop();
        }
        String[] folders = (String[])FileTransfer.getInstance().nativeToJava(transferData);
        if (folders == null) {
            return Status.CANCEL_STATUS;
        }
        String[] stringArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            File dotgitfile;
            String folder = stringArray[n2];
            File repoFile = new File(folder);
            if (!(RepositoryCache.FileKey.isGitRepository((File)repoFile, (FS)FS.DETECTED) || !repoFile.getName().equals(".git") && RepositoryCache.FileKey.isGitRepository((File)(dotgitfile = new File(repoFile, ".git")), (FS)FS.DETECTED))) {
                return Status.CANCEL_STATUS;
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    private IStatus validateRepositoryGroupNodeDrop() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (this.onlyRepositoryNodesSelected(selection)) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private IStatus handleRepositoryGroupNodeDrop(RepositoryGroupNode group, DropTargetEvent event) {
        IStructuredSelection selection;
        if (event.data instanceof IStructuredSelection && this.onlyRepositoryNodesSelected((ISelection)(selection = (IStructuredSelection)event.data))) {
            ArrayList<File> reposToAdd = new ArrayList<File>();
            for (Object treeNode : selection.toList()) {
                RepositoryNode repo = (RepositoryNode)treeNode;
                reposToAdd.add(repo.getRepository().getDirectory());
            }
            RepositoryGroups.getInstance().addRepositoriesToGroup((RepositoryGroup)group.getObject(), reposToAdd);
            this.refreshRepositoriesView();
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private IStatus handleWorkspaceRootDrop(DropTargetEvent event) {
        IStructuredSelection selection;
        if (event.data instanceof IStructuredSelection && this.onlyRepositoryNodesSelected((ISelection)(selection = (IStructuredSelection)event.data))) {
            ArrayList<File> reposToRemove = new ArrayList<File>();
            for (Object treeNode : selection.toList()) {
                RepositoryNode repo = (RepositoryNode)treeNode;
                reposToRemove.add(repo.getRepository().getDirectory());
            }
            RepositoryGroups.getInstance().removeFromGroups(reposToRemove);
            this.refreshRepositoriesView();
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    private void refreshRepositoriesView() {
        RepositoriesView view = (RepositoriesView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        view.refresh();
    }

    private boolean onlyRepositoryNodesSelected(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList().stream().allMatch(e -> this.isRegularRepository(e));
        }
        return false;
    }

    private boolean isRegularRepository(Object node) {
        if (node instanceof RepositoryNode) {
            RepositoryNode repoNode = (RepositoryNode)node;
            return repoNode.getParent() == null || repoNode.getParent().getType() == RepositoryTreeNodeType.REPOGROUP;
        }
        return false;
    }

    public boolean isSupportedType(TransferData aTransferType) {
        return FileTransfer.getInstance().isSupportedType(aTransferType);
    }
}

