/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.properties;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.egit.gitflow.Activator;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.jgit.lib.Repository;

public class RepositoryPropertyTester
extends PropertyTester {
    private static final String IS_MASTER = "isMaster";
    private static final String IS_DEVELOP = "isDevelop";
    private static final String IS_HOTFIX = "isHotfix";
    private static final String IS_RELEASE = "isRelease";
    private static final String IS_INITIALIZED = "isInitialized";
    private static final String IS_FEATURE = "isFeature";
    private static final String HAS_DEFAULT_REMOTE = "hasDefaultRemote";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver == null) {
            return false;
        }
        Repository repository = null;
        if (receiver instanceof String) {
            String gitDir = (String)receiver;
            repository = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache().getRepository(new File(gitDir));
        } else if (receiver instanceof Repository) {
            repository = (Repository)receiver;
        }
        if (repository == null || repository.isBare()) {
            return false;
        }
        GitFlowRepository gitFlowRepository = new GitFlowRepository(repository);
        try {
            if (IS_INITIALIZED.equals(property)) {
                return gitFlowRepository.getConfig().isInitialized();
            }
            if (IS_FEATURE.equals(property)) {
                return gitFlowRepository.isFeature();
            }
            if (IS_RELEASE.equals(property)) {
                return gitFlowRepository.isRelease();
            }
            if (IS_HOTFIX.equals(property)) {
                return gitFlowRepository.isHotfix();
            }
            if (IS_DEVELOP.equals(property)) {
                return gitFlowRepository.isDevelop();
            }
            if (IS_MASTER.equals(property)) {
                return gitFlowRepository.isMaster();
            }
            if (HAS_DEFAULT_REMOTE.equals(property)) {
                return gitFlowRepository.getConfig().hasDefaultRemote();
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log(org.eclipse.egit.gitflow.ui.Activator.error(e.getMessage(), e));
        }
        return false;
    }
}

