/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.ExtensionPoint;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.MacroDef;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Reference;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.dtd.IAttribute;
import org.eclipse.ant.internal.ui.dtd.IDfm;
import org.eclipse.ant.internal.ui.dtd.IElement;
import org.eclipse.ant.internal.ui.dtd.ISchema;
import org.eclipse.ant.internal.ui.dtd.ParseError;
import org.eclipse.ant.internal.ui.dtd.Parser;
import org.eclipse.ant.internal.ui.editor.AntCompletionProposal;
import org.eclipse.ant.internal.ui.editor.AntEditorMessages;
import org.eclipse.ant.internal.ui.editor.TaskDescriptionProvider;
import org.eclipse.ant.internal.ui.editor.templates.AntContext;
import org.eclipse.ant.internal.ui.editor.templates.AntTemplateAccess;
import org.eclipse.ant.internal.ui.editor.templates.AntTemplateInformationControlCreator;
import org.eclipse.ant.internal.ui.editor.templates.AntTemplateProposal;
import org.eclipse.ant.internal.ui.model.AntDefiningTaskNode;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.ant.internal.ui.model.IAntElement;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AntEditorCompletionProcessor
extends TemplateCompletionProcessor
implements ICompletionListener {
    private Comparator<ICompletionProposal> proposalComparator = new Comparator<ICompletionProposal>(){

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            int type2;
            int type1 = this.getProposalType(o1);
            if (type1 != (type2 = this.getProposalType(o2))) {
                if (type1 > type2) {
                    return 1;
                }
                return -1;
            }
            String string1 = o1.getDisplayString();
            String string2 = o2.getDisplayString();
            return string1.compareToIgnoreCase(string2);
        }

        private int getProposalType(Object o) {
            if (o instanceof AntCompletionProposal) {
                return ((AntCompletionProposal)o).getType();
            }
            return 1;
        }
    };
    protected static final int PROPOSAL_MODE_NONE = 0;
    protected static final int PROPOSAL_MODE_BUILDFILE = 1;
    protected static final int PROPOSAL_MODE_TASK_PROPOSAL = 2;
    protected static final int PROPOSAL_MODE_PROPERTY_PROPOSAL = 3;
    protected static final int PROPOSAL_MODE_ATTRIBUTE_PROPOSAL = 4;
    protected static final int PROPOSAL_MODE_TASK_PROPOSAL_CLOSING = 5;
    protected static final int PROPOSAL_MODE_ATTRIBUTE_VALUE_PROPOSAL = 6;
    protected static final int PROPOSAL_MODE_NESTED_ELEMENT_PROPOSAL = 7;
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private static final String MACROINSTANCE_NAME = "org.apache.tools.ant.taskdefs.MacroInstance";
    protected int lineNumber = -1;
    protected int columnNumber = -1;
    private int additionalProposalOffset = -1;
    private static final String ANT_DTD_FILENAME = "/org/eclipse/ant/internal/ui/editor/ant1.6.2.dtd";
    private static ISchema fgDtd;
    protected int cursorPosition = -1;
    private ITextViewer viewer;
    private char[] autoActivationChars = null;
    private String errorMessage;
    protected AntModel antModel;
    private int currentProposalMode = -1;
    protected String currentPrefix = null;
    protected String currentTaskString = null;
    private boolean fTemplatesOnly = false;
    protected IContentAssistantExtension2 fContentAssistant;

    public AntEditorCompletionProcessor(AntModel model) {
        this.antModel = model;
    }

    /*
     * Loose catch block
     */
    private ISchema parseDtd() throws ParseError, IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            ISchema iSchema;
            InputStreamReader reader;
            InputStream stream;
            block16: {
                block15: {
                    ISchema schema;
                    stream = ((Object)((Object)this)).getClass().getResourceAsStream(ANT_DTD_FILENAME);
                    reader = new InputStreamReader(stream, "UTF-8");
                    Parser parser = new Parser();
                    iSchema = schema = parser.parseDTD(reader, "project");
                    if (reader == null) break block15;
                    ((Reader)reader).close();
                }
                if (stream == null) break block16;
                stream.close();
            }
            return iSchema;
            {
                catch (Throwable throwable2) {
                    try {
                        if (reader != null) {
                            ((Reader)reader).close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (stream != null) {
                            stream.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer refViewer, int documentOffset) {
        block3: {
            ICompletionProposal[] iCompletionProposalArray;
            this.viewer = refViewer;
            try {
                if (!this.fTemplatesOnly) break block3;
                this.fContentAssistant.setStatusMessage(this.getIterationGestureMessage(AntEditorMessages.getString("AntEditorCompletionProcessor.0")));
                this.fContentAssistant.setEmptyMessage(AntEditorMessages.getString("AntEditorCompletionProcessor.60"));
                ICompletionProposal[] templates = this.determineTemplateProposals(refViewer, documentOffset);
                Arrays.sort(templates, this.proposalComparator);
                iCompletionProposalArray = templates;
                this.currentPrefix = null;
                this.currentProposalMode = -1;
                this.fTemplatesOnly = !this.fTemplatesOnly;
            }
            catch (Throwable throwable) {
                this.currentPrefix = null;
                this.currentProposalMode = -1;
                this.fTemplatesOnly = !this.fTemplatesOnly;
                throw throwable;
            }
            return iCompletionProposalArray;
        }
        this.fContentAssistant.setStatusMessage(this.getIterationGestureMessage(AntEditorMessages.getString("AntEditorCompletionProcessor.61")));
        this.fContentAssistant.setEmptyMessage(AntEditorMessages.getString("AntEditorCompletionProcessor.62"));
        ICompletionProposal[] matchingProposals = this.determineProposals();
        ICompletionProposal[] matchingTemplateProposals = this.determineTemplateProposals(refViewer, documentOffset);
        ICompletionProposal[] iCompletionProposalArray = this.mergeProposals(matchingProposals, matchingTemplateProposals);
        this.currentPrefix = null;
        this.currentProposalMode = -1;
        this.fTemplatesOnly = !this.fTemplatesOnly;
        return iCompletionProposalArray;
    }

    protected ICompletionProposal[] determineTemplateProposals(ITextViewer refViewer, int documentOffset) {
        ICompletionProposal[] matchingTemplateProposals;
        this.viewer = refViewer;
        String prefix = this.getCurrentPrefix();
        if (prefix.length() == 0) {
            matchingTemplateProposals = this.determineTemplateProposalsForContext(documentOffset);
        } else {
            ICompletionProposal[] templateProposals = this.determineTemplateProposalsForContext(documentOffset);
            ArrayList<ICompletionProposal> templateProposalList = new ArrayList<ICompletionProposal>(templateProposals.length);
            int i = 0;
            while (i < templateProposals.length) {
                if (templateProposals[i].getDisplayString().toLowerCase().startsWith(prefix)) {
                    templateProposalList.add(templateProposals[i]);
                }
                ++i;
            }
            matchingTemplateProposals = templateProposalList.toArray(new ICompletionProposal[templateProposalList.size()]);
        }
        return matchingTemplateProposals;
    }

    private ICompletionProposal[] determineTemplateProposalsForContext(int offset) {
        Template[] templates;
        String prefix;
        Region region;
        TemplateContext context;
        ITextSelection selection = (ITextSelection)this.viewer.getSelectionProvider().getSelection();
        int newoffset = offset;
        if (selection.getOffset() == newoffset) {
            newoffset = selection.getOffset() + selection.getLength();
        }
        if ((context = this.createContext(this.viewer, (IRegion)(region = new Region(newoffset - (prefix = this.extractPrefix(this.viewer, newoffset)).length(), prefix.length())))) == null) {
            return new ICompletionProposal[0];
        }
        context.setVariable("selection", selection.getText());
        String contextTypeId = context.getContextType().getId();
        boolean isTargetContextType = contextTypeId.equals("org.eclipse.ant.ui.templateContextType.target");
        if (isTargetContextType) {
            Template[] tasks = AntTemplateAccess.getDefault().getTemplateStore().getTemplates("org.eclipse.ant.ui.templateContextType.task");
            Template[] targets = this.getTemplates(contextTypeId);
            templates = new Template[tasks.length + targets.length];
            System.arraycopy(tasks, 0, templates, 0, tasks.length);
            System.arraycopy(targets, 0, templates, tasks.length, targets.length);
        } else {
            templates = this.getTemplates(contextTypeId);
        }
        ArrayList<ICompletionProposal> matches = new ArrayList<ICompletionProposal>();
        int i = 0;
        while (i < templates.length) {
            block8: {
                Template template = templates[i];
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    break block8;
                }
                if (template.matches(prefix, contextTypeId) || isTargetContextType && template.matches(prefix, "org.eclipse.ant.ui.templateContextType.task")) {
                    matches.add(this.createProposal(template, context, (IRegion)region, this.getRelevance(template, prefix)));
                }
            }
            ++i;
        }
        Collections.sort(matches, this.proposalComparator);
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    private ICompletionProposal[] mergeProposals(ICompletionProposal[] proposals1, ICompletionProposal[] proposals2) {
        ICompletionProposal[] combinedProposals = new ICompletionProposal[proposals1.length + proposals2.length];
        System.arraycopy(proposals1, 0, combinedProposals, 0, proposals1.length);
        System.arraycopy(proposals2, 0, combinedProposals, proposals1.length, proposals2.length);
        Arrays.sort(combinedProposals, this.proposalComparator);
        return combinedProposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer refViewer, int documentOffset) {
        return new IContextInformation[0];
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.autoActivationChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private ICompletionProposal[] determineProposals() {
        ITextSelection selection = (ITextSelection)this.viewer.getSelectionProvider().getSelection();
        this.cursorPosition = selection.getOffset() + selection.getLength();
        IDocument doc = this.viewer.getDocument();
        try {
            this.lineNumber = doc.getLineOfOffset(this.cursorPosition);
            this.columnNumber = this.cursorPosition - doc.getLineOffset(this.lineNumber);
        }
        catch (BadLocationException e) {
            AntUIPlugin.log(e);
        }
        String prefix = this.getCurrentPrefix();
        if (prefix == null || this.cursorPosition == -1) {
            return NO_PROPOSALS;
        }
        ICompletionProposal[] proposals = this.getProposalsFromDocument(doc, prefix);
        this.currentTaskString = null;
        return proposals;
    }

    protected ICompletionProposal[] getProposalsFromDocument(IDocument document, String prefix) {
        ICompletionProposal[] proposals = null;
        this.currentProposalMode = this.determineProposalMode(document, this.cursorPosition, prefix);
        switch (this.currentProposalMode) {
            case 4: {
                proposals = this.getAttributeProposals(this.currentTaskString, prefix);
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.28");
                break;
            }
            case 2: {
                String parentName = this.getParentName(document, this.lineNumber, this.columnNumber);
                if (parentName == null || parentName.length() == 0) {
                    proposals = NO_PROPOSALS;
                    this.currentProposalMode = 0;
                } else {
                    proposals = this.getTaskProposals(document, parentName, prefix);
                }
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.29");
                break;
            }
            case 1: {
                proposals = this.getBuildFileProposals(document, prefix);
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.29");
                break;
            }
            case 5: {
                ICompletionProposal proposal = this.getClosingTaskProposal(this.getOpenElementName(), prefix, true);
                if (proposal == null) {
                    this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.30");
                    proposals = NO_PROPOSALS;
                    break;
                }
                proposals = new ICompletionProposal[]{proposal};
                break;
            }
            case 6: {
                String textToSearch = document.get().substring(0, this.cursorPosition - prefix.length());
                String attributeString = AntEditorCompletionProcessor.getAttributeStringFromDocumentStringToPrefix(textToSearch);
                proposals = "target".equalsIgnoreCase(this.currentTaskString) || "extension-point".equalsIgnoreCase(this.currentTaskString) ? this.getTargetAttributeValueProposals(document, textToSearch, prefix, attributeString) : ("antcall".equalsIgnoreCase(this.currentTaskString) ? this.getAntCallAttributeValueProposals(document, prefix, attributeString) : ("project".equalsIgnoreCase(this.currentTaskString) ? this.getProjectAttributeValueProposals(prefix, attributeString) : ("refid".equalsIgnoreCase(attributeString) || "classpathref".equalsIgnoreCase(attributeString) || "sourcepathref".equalsIgnoreCase(attributeString) || "bootpathref".equalsIgnoreCase(attributeString) ? this.getReferencesValueProposals(prefix) : this.getAttributeValueProposals(this.currentTaskString, attributeString, prefix))));
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.31");
                break;
            }
            case 3: {
                proposals = this.getPropertyProposals(document, prefix, this.cursorPosition);
                if (proposals.length != 0) break;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.32");
                break;
            }
            default: {
                proposals = NO_PROPOSALS;
                this.errorMessage = AntEditorMessages.getString("AntEditorCompletionProcessor.33");
            }
        }
        if (proposals.length > 0) {
            this.errorMessage = "";
        }
        return proposals;
    }

    private ICompletionProposal[] getProjectAttributeValueProposals(String prefix, String attributeName) {
        if (attributeName.equalsIgnoreCase("default")) {
            return this.getDefaultValueProposals(prefix);
        }
        return NO_PROPOSALS;
    }

    private ICompletionProposal[] getDefaultValueProposals(String prefix) {
        Map<String, Target> targets = this.getTargets();
        ArrayList<AntCompletionProposal> defaultProposals = new ArrayList<AntCompletionProposal>(targets.size());
        for (Target target : targets.values()) {
            String targetName = target.getName();
            if (!targetName.toLowerCase().startsWith(prefix) || targetName.length() <= 0) continue;
            defaultProposals.add(new AntCompletionProposal(targetName, this.cursorPosition - prefix.length(), prefix.length(), targetName.length(), this.getTargetImage(targetName), targetName, target.getDescription(), 1));
        }
        ICompletionProposal[] proposals = new ICompletionProposal[defaultProposals.size()];
        return defaultProposals.toArray(proposals);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private ICompletionProposal[] getReferencesValueProposals(String prefix) {
        project = this.antModel.getProjectNode().getProject();
        references = project.getReferences();
        if (references.isEmpty()) {
            return AntEditorCompletionProcessor.NO_PROPOSALS;
        }
        node /* !! */  = this.antModel.getNode(this.cursorPosition, false);
        if (node /* !! */  != null) ** GOTO lbl9
        return AntEditorCompletionProcessor.NO_PROPOSALS;
lbl-1000:
        // 1 sources

        {
            node /* !! */  = node /* !! */ .getParentNode();
lbl9:
            // 2 sources

            ** while (node /* !! */ .getParentNode() instanceof AntTaskNode)
        }
lbl10:
        // 1 sources

        id = null;
        if (node /* !! */  instanceof AntTaskNode) {
            id = ((AntTaskNode)node /* !! */ ).getId();
        }
        refIds = references.keySet();
        proposals = new ArrayList<AntCompletionProposal>(refIds.size());
        prefixLength = prefix.length();
        replacementOffset = this.cursorPosition - prefixLength;
        for (String refId : refIds) {
            if (refId.equals(id) || prefixLength != 0 && !refId.toLowerCase().startsWith(prefix)) continue;
            proposal = new AntCompletionProposal(refId, replacementOffset, prefixLength, refId.length(), null, refId, null, 1);
            proposals.add(proposal);
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    protected ICompletionProposal[] getTargetAttributeValueProposals(IDocument document, String textToSearch, String prefix, String attributeName) {
        if (attributeName.equalsIgnoreCase("depends")) {
            return this.getDependsValueProposals(document, prefix);
        }
        if (attributeName.equalsIgnoreCase("if") || attributeName.equalsIgnoreCase("unless")) {
            if (!textToSearch.trim().endsWith(",")) {
                return this.getPropertyProposals(document, prefix, this.cursorPosition);
            }
        } else if (attributeName.equalsIgnoreCase("extensionOf")) {
            return this.getExtensionOfValueProposals(prefix);
        }
        return NO_PROPOSALS;
    }

    private ICompletionProposal[] getExtensionOfValueProposals(String prefix) {
        ArrayList<AntCompletionProposal> extensions = new ArrayList<AntCompletionProposal>();
        Map<String, Target> targets = this.getTargets();
        Set<String> targetNames = targets.keySet();
        for (String targetName : targetNames) {
            Target currentTarget = targets.get(targetName);
            if (!(currentTarget instanceof ExtensionPoint)) continue;
            extensions.add(new AntCompletionProposal(targetName, this.cursorPosition - prefix.length(), prefix.length(), targetName.length(), this.getTargetImage(targetName), targetName, targets.get(targetName).getDescription(), 1));
        }
        return extensions.toArray(new ICompletionProposal[extensions.size()]);
    }

    protected ICompletionProposal[] getAntCallAttributeValueProposals(IDocument document, String prefix, String attributeName) {
        if (attributeName.equalsIgnoreCase("target")) {
            return this.getTargetProposals(document, prefix);
        }
        return NO_PROPOSALS;
    }

    private ICompletionProposal[] getTargetProposals(IDocument document, String prefix) {
        String currentTargetName = this.getEnclosingTargetName(document, this.lineNumber, this.columnNumber);
        if (currentTargetName == null) {
            return NO_PROPOSALS;
        }
        Map<String, Target> targets = this.getTargets();
        Set<String> targetNames = targets.keySet();
        ArrayList<AntCompletionProposal> proposals = new ArrayList<AntCompletionProposal>(targets.size() - 2);
        for (String targetName : targetNames) {
            if (targetName.equals(currentTargetName) || !targetName.toLowerCase().startsWith(prefix) || targetName.length() <= 0) continue;
            proposals.add(new AntCompletionProposal(targetName, this.cursorPosition - prefix.length(), prefix.length(), targetName.length(), this.getTargetImage(targetName), targetName, targets.get(targetName).getDescription(), 1));
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private Image getTargetImage(String targetName) {
        AntTargetNode targetNode = this.antModel.getTargetNode(targetName);
        if (targetNode == null) {
            return null;
        }
        if (targetNode.isInternal()) {
            return AntUIImages.getImage("org.eclipse.ant.ui.antPrivateTarget");
        }
        if (targetNode.isDefaultTarget()) {
            return AntUIImages.getImage("org.eclipse.ant.ui.antDefaultTarget");
        }
        return AntUIImages.getImage("org.eclipse.ant.ui.antTarget");
    }

    private ICompletionProposal[] getDependsValueProposals(IDocument document, String prefix) {
        ArrayList<String> possibleDependencies = new ArrayList<String>();
        String currentTargetName = this.getEnclosingTargetName(document, this.lineNumber, this.columnNumber);
        if (currentTargetName == null) {
            return NO_PROPOSALS;
        }
        Map<String, Target> targets = this.getTargets();
        Set<String> targetNames = targets.keySet();
        Enumeration dependencies = null;
        for (String targetName : targetNames) {
            if (targetName.equals(currentTargetName)) {
                Target currentTarget = targets.get(targetName);
                dependencies = currentTarget.getDependencies();
                continue;
            }
            if (!targetName.toLowerCase().startsWith(prefix) || targetName.length() <= 0) continue;
            possibleDependencies.add(targetName);
        }
        if (dependencies != null) {
            while (dependencies.hasMoreElements()) {
                possibleDependencies.remove(dependencies.nextElement());
            }
        }
        ArrayList<AntCompletionProposal> proposals = new ArrayList<AntCompletionProposal>(possibleDependencies.size());
        for (String targetName : possibleDependencies) {
            AntCompletionProposal proposal = new AntCompletionProposal(targetName, this.cursorPosition - prefix.length(), prefix.length(), targetName.length(), this.getTargetImage(targetName), targetName, targets.get(targetName).getDescription(), 1);
            proposals.add(proposal);
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    protected ICompletionProposal[] getAttributeProposals(String taskName, String prefix) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        IElement element = this.getDtd().getElement(taskName);
        if (element != null) {
            for (String attrName : element.getAttributes().keySet()) {
                if (prefix.length() != 0 && !attrName.toLowerCase().startsWith(prefix)) continue;
                IAttribute dtdAttributes = element.getAttributes().get(attrName);
                String replacementString = String.valueOf(attrName) + "=\"\"";
                String displayString = attrName;
                String[] items = dtdAttributes.getEnum();
                if (items != null) {
                    if (items.length > 1) {
                        displayString = String.valueOf(displayString) + " - (";
                    }
                    int i = 0;
                    while (i < items.length) {
                        displayString = String.valueOf(displayString) + items[i];
                        displayString = i + 1 < items.length ? String.valueOf(displayString) + " | " : String.valueOf(displayString) + ")";
                        ++i;
                    }
                }
                this.addAttributeProposal(taskName, prefix, proposals, attrName, replacementString, displayString, true);
            }
        } else {
            AntTypeDefinition taskClass = this.getTaskClass(taskName);
            if (taskClass != null) {
                if (MACROINSTANCE_NAME.equals(taskClass.getClassName())) {
                    this.addMacroDefAttributeProposals(taskName, prefix, proposals);
                } else {
                    IntrospectionHelper helper = this.getIntrospectionHelper(taskClass);
                    if (helper != null) {
                        this.addAttributeProposals(helper, taskName, prefix, proposals);
                    }
                }
            } else {
                IntrospectionHelper helper;
                AntTypeDefinition nestedType = this.getNestedType();
                if (nestedType != null && (helper = this.getIntrospectionHelper(nestedType)) != null) {
                    this.addAttributeProposals(helper, taskName, prefix, proposals);
                }
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private void addAttributeProposals(IntrospectionHelper helper, String taskName, String prefix, List<ICompletionProposal> proposals) {
        Enumeration attributes = helper.getAttributes();
        while (attributes.hasMoreElements()) {
            String attribute = (String)attributes.nextElement();
            if (prefix.length() != 0 && !attribute.toLowerCase().startsWith(prefix)) continue;
            String replacementString = String.valueOf(attribute) + "=\"\"";
            this.addAttributeProposal(taskName, prefix, proposals, attribute, replacementString, attribute, false);
        }
    }

    private AntTypeDefinition getNestedType() {
        IntrospectionHelper helper;
        AntTypeDefinition taskClass;
        String parentName;
        AntElementNode currentNode = this.antModel.getNode(this.cursorPosition, false);
        if (currentNode == null) {
            return null;
        }
        IAntElement parent = currentNode.getParentNode();
        if (parent instanceof AntTaskNode && this.hasNestedElements(parentName = parent.getName()) && (taskClass = this.getTaskClass(parentName)) != null && (helper = this.getIntrospectionHelper(taskClass)) != null) {
            try {
                Class nestedType = helper.getElementType(currentNode.getName());
                AntTypeDefinition def = new AntTypeDefinition();
                def.setClass(nestedType);
                def.setClassName(nestedType.getName());
                return def;
            }
            catch (BuildException buildException) {}
        }
        return null;
    }

    private IntrospectionHelper getIntrospectionHelper(AntTypeDefinition taskClass) {
        Project p = this.antModel.getProjectNode().getProject();
        Class clazz = taskClass.getExposedClass(p);
        if (clazz != null) {
            IntrospectionHelper helper = null;
            try {
                helper = IntrospectionHelper.getHelper((Project)this.antModel.getProjectNode().getProject(), (Class)clazz);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
            return helper;
        }
        return null;
    }

    private void addMacroDefAttributeProposals(String taskName, String prefix, List<ICompletionProposal> proposals) {
        this.currentProposalMode = 4;
        AntDefiningTaskNode node = this.antModel.getDefininingTaskNode(taskName);
        Object task = node.getRealTask();
        if (!(task instanceof MacroDef)) {
            return;
        }
        List attributes = ((MacroDef)task).getAttributes();
        for (MacroDef.Attribute attribute : attributes) {
            String deflt;
            String attributeName = attribute.getName();
            if (prefix.length() != 0 && !attributeName.toLowerCase().startsWith(prefix)) continue;
            String replacementString = String.valueOf(attributeName) + "=\"\"";
            String proposalInfo = null;
            String description = attribute.getDescription();
            if (description != null) {
                proposalInfo = description;
            }
            if ((deflt = attribute.getDefault()) != null && deflt.length() > 0) {
                proposalInfo = proposalInfo == null ? "<BR><BR>" : (proposalInfo = String.valueOf(proposalInfo) + "<BR><BR>");
                proposalInfo = String.valueOf(proposalInfo) + MessageFormat.format((String)AntEditorMessages.getString("AntEditorCompletionProcessor.59"), (Object[])new Object[]{deflt});
            }
            AntCompletionProposal proposal = new AntCompletionProposal(replacementString, this.cursorPosition - prefix.length(), prefix.length(), attributeName.length() + 2, null, attributeName, proposalInfo, 1);
            proposals.add(proposal);
        }
    }

    private void addMacroDefElementProposals(String taskName, String prefix, List<ICompletionProposal> proposals) {
        AntDefiningTaskNode node = this.antModel.getDefininingTaskNode(taskName);
        Object task = node.getRealTask();
        if (!(task instanceof MacroDef)) {
            return;
        }
        Map elements = ((MacroDef)task).getElements();
        Iterator itr = elements.keySet().iterator();
        int prefixLength = prefix.length();
        int replacementOffset = this.cursorPosition - prefixLength;
        while (itr.hasNext()) {
            String elementName = (String)itr.next();
            if (prefixLength != 0 && !elementName.toLowerCase().startsWith(prefix)) continue;
            MacroDef.TemplateElement element = (MacroDef.TemplateElement)elements.get(elementName);
            String replacementString = MessageFormat.format((String)"<{0}>\n</{1}>", (Object[])new Object[]{elementName, elementName});
            String proposalInfo = null;
            String description = element.getDescription();
            if (description != null) {
                proposalInfo = description;
            }
            proposalInfo = proposalInfo == null ? "<BR><BR>" : (proposalInfo = String.valueOf(proposalInfo) + "<BR><BR>");
            proposalInfo = element.isOptional() ? String.valueOf(proposalInfo) + AntEditorMessages.getString("AntEditorCompletionProcessor.1") : String.valueOf(proposalInfo) + AntEditorMessages.getString("AntEditorCompletionProcessor.2");
            AntCompletionProposal proposal = new AntCompletionProposal(replacementString, replacementOffset, prefixLength, elementName.length() + 2, null, elementName, proposalInfo, 1);
            proposals.add(proposal);
        }
    }

    private void addAttributeProposal(String taskName, String prefix, List<ICompletionProposal> proposals, String attrName, String replacementString, String displayString, boolean lookupDescription) {
        String proposalInfo = null;
        if (lookupDescription) {
            String description;
            String required = this.getDescriptionProvider().getRequiredAttributeForTaskAttribute(taskName, attrName);
            if (required != null && required.length() > 0) {
                proposalInfo = String.valueOf(AntEditorMessages.getString("AntEditorCompletionProcessor.Required___4")) + required;
                proposalInfo = String.valueOf(proposalInfo) + "<BR><BR>";
            }
            if ((description = this.getDescriptionProvider().getDescriptionForTaskAttribute(taskName, attrName)) != null) {
                proposalInfo = proposalInfo == null ? "" : proposalInfo;
                proposalInfo = String.valueOf(proposalInfo) + description;
            }
        }
        AntCompletionProposal proposal = new AntCompletionProposal(replacementString, this.cursorPosition - prefix.length(), prefix.length(), attrName.length() + 2, null, displayString, proposalInfo, 1);
        proposals.add(proposal);
    }

    private ICompletionProposal[] getAttributeValueProposals(String taskName, String attributeName, String prefix) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        IElement taskElement = this.getDtd().getElement(taskName);
        if (taskElement != null) {
            String[] items;
            IAttribute attribute = taskElement.getAttributes().get(attributeName);
            if (attribute != null && (items = attribute.getEnum()) != null) {
                int i = 0;
                while (i < items.length) {
                    String item = items[i];
                    if (prefix.length() == 0 || item.toLowerCase().startsWith(prefix)) {
                        proposals.add(new AntCompletionProposal(item, this.cursorPosition - prefix.length(), prefix.length(), item.length(), null, item, null, 1));
                    }
                    ++i;
                }
            }
        } else {
            AntTypeDefinition taskClass = this.getTaskClass(taskName);
            if (taskClass != null) {
                IntrospectionHelper helper = this.getIntrospectionHelper(taskClass);
                if (helper != null) {
                    this.addAttributeValueProposals(helper, attributeName, prefix, proposals);
                }
            } else {
                IntrospectionHelper helper;
                AntTypeDefinition nestedType = this.getNestedType();
                if (nestedType != null && (helper = this.getIntrospectionHelper(nestedType)) != null) {
                    this.addAttributeValueProposals(helper, attributeName, prefix, proposals);
                }
            }
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private void addAttributeValueProposals(IntrospectionHelper helper, String attributeName, String prefix, List<ICompletionProposal> proposals) {
        Enumeration attributes = helper.getAttributes();
        while (attributes.hasMoreElements()) {
            String attribute = (String)attributes.nextElement();
            if (!attribute.equals(attributeName)) continue;
            Class attributeType = helper.getAttributeType(attribute);
            this.addAttributeValueProposalsForAttributeType(attributeType, prefix, proposals);
            break;
        }
    }

    private void addAttributeValueProposalsForAttributeType(Class<?> attributeType, String prefix, List<ICompletionProposal> proposals) {
        if ((attributeType == Boolean.TYPE || attributeType == Boolean.class) && prefix.length() <= 5) {
            this.addBooleanAttributeValueProposals(prefix, proposals);
        } else if (EnumeratedAttribute.class.isAssignableFrom(attributeType)) {
            try {
                this.addEnumeratedAttributeValueProposals(attributeType, prefix, proposals);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        } else if (Reference.class == attributeType) {
            proposals.addAll(Arrays.asList(this.getReferencesValueProposals(prefix)));
        }
    }

    private void addEnumeratedAttributeValueProposals(Class<?> type, String prefix, List<ICompletionProposal> proposals) throws InstantiationException, IllegalAccessException {
        EnumeratedAttribute ea = (EnumeratedAttribute)type.newInstance();
        String[] values = ea.getValues();
        int i = 0;
        while (i < values.length) {
            String enumerated = values[i].toLowerCase();
            if (prefix.length() == 0 || enumerated.startsWith(prefix)) {
                proposals.add(new AntCompletionProposal(enumerated, this.cursorPosition - prefix.length(), prefix.length(), enumerated.length(), null, enumerated, null, 1));
            }
            ++i;
        }
    }

    private void addBooleanAttributeValueProposals(String prefix, List<ICompletionProposal> proposals) {
        String[] booleanValues = new String[]{"true", "false", "on", "off", "yes", "no"};
        int i = 0;
        while (i < booleanValues.length) {
            String booleanAssist = booleanValues[i].toLowerCase();
            if (prefix.length() == 0 || booleanAssist.startsWith(prefix)) {
                proposals.add(new AntCompletionProposal(booleanAssist, this.cursorPosition - prefix.length(), prefix.length(), booleanAssist.length(), null, booleanAssist, null, 1));
            }
            ++i;
        }
    }

    protected ICompletionProposal[] getPropertyProposals(IDocument document, String prefix, int aCursorPosition) {
        ArrayList<AntCompletionProposal> proposals = new ArrayList<AntCompletionProposal>();
        HashMap<String, AntCompletionProposal> displayStringToProposals = new HashMap<String, AntCompletionProposal>();
        Map<String, Object> properties = this.findPropertiesFromDocument();
        Image image = AntUIImages.getImage("org.eclipse.ant.ui.IMG_PROPERTY");
        int replacementLength = prefix.length();
        int replacementOffset = 0;
        String text = document.get();
        String stringToPrefix = text.substring(0, aCursorPosition - prefix.length());
        String lastTwoCharacters = stringToPrefix.substring(stringToPrefix.length() - 2, stringToPrefix.length());
        boolean appendBraces = true;
        if (lastTwoCharacters.equals("${")) {
            replacementLength += 2;
            replacementOffset = aCursorPosition - prefix.length() - 2;
        } else if (lastTwoCharacters.endsWith("$")) {
            ++replacementLength;
            replacementOffset = aCursorPosition - prefix.length() - 1;
        } else {
            replacementOffset = aCursorPosition - prefix.length();
            appendBraces = false;
        }
        if (text.length() > aCursorPosition && text.charAt(aCursorPosition) == '}') {
            ++replacementLength;
        }
        for (String propertyName : properties.keySet()) {
            if (prefix.length() != 0 && !propertyName.toLowerCase().startsWith(prefix)) continue;
            String additionalPropertyInfo = (String)properties.get(propertyName);
            StringBuilder replacementString = new StringBuilder();
            if (appendBraces) {
                replacementString.append("${");
            }
            replacementString.append(propertyName);
            if (appendBraces) {
                replacementString.append('}');
            }
            if (displayStringToProposals.get(propertyName) != null) continue;
            AntCompletionProposal proposal = new AntCompletionProposal(replacementString.toString(), replacementOffset, replacementLength, replacementString.length(), image, propertyName, additionalPropertyInfo, 2);
            proposals.add(proposal);
            displayStringToProposals.put(propertyName, proposal);
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    protected ICompletionProposal[] getTaskProposals(IDocument document, String parentName, String prefix) {
        ICompletionProposal proposal;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(250);
        if (this.areTasksOrTypesValidChildren(parentName)) {
            Project project = this.antModel.getProjectNode().getProject();
            Hashtable tasksAndTypes = ComponentHelper.getComponentHelper((Project)project).getAntTypeTable();
            this.createProposals(document, prefix, proposals, tasksAndTypes);
            if (parentName.equals("project")) {
                if ("target".startsWith(prefix)) {
                    proposals.add(this.newCompletionProposal(document, prefix, "target"));
                }
                if ("extension-point".startsWith(prefix)) {
                    proposals.add(this.newCompletionProposal(document, prefix, "extension-point"));
                }
            }
        } else {
            IElement parent = this.getDtd().getElement(parentName);
            if (parent != null) {
                IDfm dfm = parent.getDfm();
                String[] accepts = dfm.getAccepts();
                if (accepts.length == 0) {
                    this.currentProposalMode = 0;
                }
                int i = 0;
                while (i < accepts.length) {
                    String elementName = accepts[i];
                    if (prefix.length() == 0 || elementName.toLowerCase().startsWith(prefix)) {
                        proposal = this.newCompletionProposal(document, prefix, elementName);
                        proposals.add(proposal);
                    }
                    ++i;
                }
            } else {
                AntTypeDefinition taskClass = this.getTaskClass(parentName);
                if (taskClass != null) {
                    if (MACROINSTANCE_NAME.equals(taskClass.getClassName())) {
                        this.currentProposalMode = 4;
                        this.addMacroDefElementProposals(parentName, prefix, proposals);
                    } else {
                        this.currentProposalMode = 7;
                        IntrospectionHelper helper = this.getIntrospectionHelper(taskClass);
                        if (helper != null) {
                            Enumeration nested = helper.getNestedElements();
                            while (nested.hasMoreElements()) {
                                String nestedElement = (String)nested.nextElement();
                                if (prefix.length() != 0 && !nestedElement.toLowerCase().startsWith(prefix)) continue;
                                proposal = this.newCompletionProposal(document, prefix, nestedElement);
                                proposals.add(proposal);
                            }
                        }
                    }
                }
            }
        }
        if ((proposal = this.getClosingTaskProposal(this.getOpenElementName(), prefix, false)) != null) {
            proposals.add(proposal);
        }
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private boolean areTasksOrTypesValidChildren(String parentName) {
        return parentName == "project" || parentName == "target" || parentName == "sequential" || parentName == "presetdef" || parentName == "parallel" || parentName == "daemons" || parentName == "extension-point";
    }

    protected ICompletionProposal[] getBuildFileProposals(IDocument document, String prefix) {
        String rootElementName = "project";
        IElement rootElement = this.getDtd().getElement(rootElementName);
        if (rootElement != null && rootElementName.toLowerCase().startsWith(prefix)) {
            ICompletionProposal proposal = this.newCompletionProposal(document, prefix, rootElementName);
            return new ICompletionProposal[]{proposal};
        }
        return NO_PROPOSALS;
    }

    private void createProposals(IDocument document, String prefix, List<ICompletionProposal> proposals, Map<String, AntTypeDefinition> tasks) {
        Iterator<String> keys = tasks.keySet().iterator();
        while (keys.hasNext()) {
            String key = this.antModel.getUserNamespaceCorrectName(keys.next());
            if (prefix.length() != 0 && !key.toLowerCase().startsWith(prefix)) continue;
            ICompletionProposal proposal = this.newCompletionProposal(document, prefix, key);
            proposals.add(proposal);
        }
    }

    private ICompletionProposal newCompletionProposal(IDocument document, String aPrefix, String elementName) {
        int proposalCursorPosition;
        this.additionalProposalOffset = 0;
        Image proposalImage = AntUIImages.getImage("org.eclipse.ant.ui.html_tab_obj");
        String proposalInfo = this.getDescriptionProvider().getDescriptionForTask(elementName);
        boolean hasNestedElements = this.hasNestedElements(elementName);
        String replacementString = this.getTaskProposalReplacementString(elementName, hasNestedElements);
        int replacementOffset = this.cursorPosition - aPrefix.length();
        int replacementLength = aPrefix.length();
        if (replacementOffset > 0 && document.get().charAt(replacementOffset - 1) == '<') {
            --replacementOffset;
            ++replacementLength;
        }
        if (hasNestedElements) {
            proposalCursorPosition = elementName.length() + 2 + this.additionalProposalOffset;
        } else {
            this.additionalProposalOffset = this.additionalProposalOffset > 0 ? (this.additionalProposalOffset += 2) : ++this.additionalProposalOffset;
            proposalCursorPosition = elementName.length() + this.additionalProposalOffset;
        }
        return new AntCompletionProposal(replacementString, replacementOffset, replacementLength, proposalCursorPosition, proposalImage, elementName, proposalInfo, 1);
    }

    private ICompletionProposal getClosingTaskProposal(String openElementName, String prefix, boolean closingMode) {
        char previousChar = this.getPreviousChar();
        AntCompletionProposal proposal = null;
        if (openElementName != null && (prefix.length() == 0 || openElementName.toLowerCase().startsWith(prefix))) {
            StringBuilder replaceString = new StringBuilder();
            if (!closingMode && previousChar != '/') {
                if (previousChar != '<') {
                    replaceString.append('<');
                }
                replaceString.append('/');
            }
            replaceString.append(openElementName);
            replaceString.append('>');
            StringBuilder displayString = new StringBuilder("</");
            displayString.append(openElementName);
            displayString.append('>');
            proposal = new AntCompletionProposal(replaceString.toString(), this.cursorPosition - prefix.length(), prefix.length(), replaceString.length(), null, displayString.toString(), AntEditorMessages.getString("AntEditorCompletionProcessor.39"), 0);
        }
        return proposal;
    }

    protected char getPreviousChar() {
        ITextSelection selection = (ITextSelection)this.viewer.getSelectionProvider().getSelection();
        int offset = selection.getOffset();
        char previousChar = '?';
        try {
            previousChar = this.viewer.getDocument().getChar(offset - 1);
        }
        catch (BadLocationException badLocationException) {}
        return previousChar;
    }

    private String getTaskProposalReplacementString(String aTaskName, boolean hasNested) {
        StringBuffer replacement = new StringBuffer("<");
        replacement.append(aTaskName);
        TaskDescriptionProvider.ProposalNode task = this.getDescriptionProvider().getTaskNode(aTaskName);
        if (task != null) {
            this.appendRequiredAttributes(replacement, task);
        }
        if (hasNested) {
            replacement.append("></");
            replacement.append(aTaskName);
            replacement.append('>');
        } else {
            replacement.append("/>");
        }
        return replacement.toString();
    }

    private void appendRequiredAttributes(StringBuffer replacement, TaskDescriptionProvider.ProposalNode task) {
        if (task.nodes != null) {
            boolean requiredAdded = false;
            Map.Entry<String, TaskDescriptionProvider.ProposalNode> entry2 = null;
            for (Map.Entry<String, TaskDescriptionProvider.ProposalNode> entry2 : task.nodes.entrySet()) {
                String name = entry2.getKey();
                TaskDescriptionProvider.ProposalNode att = entry2.getValue();
                if (!"yes".equalsIgnoreCase(att.required)) continue;
                replacement.append(' ');
                replacement.append(name);
                replacement.append("=\"\"");
                if (requiredAdded) continue;
                this.additionalProposalOffset = name.length() + 2;
                requiredAdded = true;
            }
        }
    }

    private boolean hasNestedElements(String elementName) {
        IntrospectionHelper helper;
        IElement element = this.getDtd().getElement(elementName);
        if (element != null) {
            return !element.isEmpty();
        }
        AntTypeDefinition taskClass = this.getTaskClass(elementName);
        if (taskClass != null && (helper = this.getIntrospectionHelper(taskClass)) != null) {
            Enumeration nested = helper.getNestedElements();
            return nested.hasMoreElements();
        }
        return false;
    }

    protected Element findChildElementNamedOf(Element anElement, String aChildElementName) {
        NodeList nodeList = anElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() == 1 && childNode.getNodeName().equals(aChildElementName)) {
                return (Element)childNode;
            }
            ++i;
        }
        return null;
    }

    private String getCurrentPrefix() {
        if (this.currentPrefix != null) {
            return this.currentPrefix;
        }
        ITextSelection selection = (ITextSelection)this.viewer.getSelectionProvider().getSelection();
        IDocument doc = this.viewer.getDocument();
        return this.getPrefixFromDocument(doc.get(), selection.getOffset() + selection.getLength()).toLowerCase();
    }

    protected String getPrefixFromDocument(String aDocumentText, int anOffset) {
        if (this.currentPrefix != null) {
            return this.currentPrefix;
        }
        int startOfWordToken = anOffset;
        char token = 'a';
        if (startOfWordToken > 0) {
            token = aDocumentText.charAt(startOfWordToken - 1);
        }
        while (startOfWordToken > 0 && (Character.isJavaIdentifierPart(token) || '.' == token || '-' == token || ';' == token) && '$' != token) {
            if (--startOfWordToken == 0) break;
            token = aDocumentText.charAt(startOfWordToken - 1);
        }
        this.currentPrefix = startOfWordToken != anOffset ? aDocumentText.substring(startOfWordToken, anOffset).toLowerCase() : "";
        return this.currentPrefix;
    }

    protected int determineProposalMode(IDocument document, int aCursorPosition, String aPrefix) {
        if (this.currentProposalMode != -1) {
            return this.currentProposalMode;
        }
        if (document.getLength() == 0 || document.getLength() == 1 && document.get().equals("<")) {
            return 1;
        }
        String text = document.get();
        String stringToPrefix = text.substring(0, aCursorPosition - aPrefix.length());
        if (stringToPrefix.length() == 0) {
            return 1;
        }
        String trimmedString = stringToPrefix.trim();
        if (this.antModel != null && this.antModel.getProjectNode() == null) {
            this.currentTaskString = this.getTaskStringFromDocumentStringToPrefix(trimmedString);
            if ("project".equals(this.currentTaskString)) {
                return 4;
            }
            return 1;
        }
        char lastChar = '\u0000';
        if (trimmedString.length() <= 0) {
            return 2;
        }
        lastChar = trimmedString.charAt(trimmedString.length() - 1);
        if (stringToPrefix.charAt(stringToPrefix.length() - 1) != lastChar && lastChar != '>' && lastChar != ',') {
            if (lastChar != '>' && lastChar != '<') {
                this.currentTaskString = this.getTaskStringFromDocumentStringToPrefix(trimmedString);
                if (this.currentTaskString != null && this.isKnownElement(this.currentTaskString)) {
                    return 4;
                }
            }
        } else if (stringToPrefix.charAt(stringToPrefix.length() - 1) == '\"' || trimmedString.charAt(trimmedString.length() - 1) == ',') {
            this.currentTaskString = this.getTaskStringFromDocumentStringToPrefix(trimmedString);
            if (this.currentTaskString != null && this.isKnownElement(this.currentTaskString)) {
                return 6;
            }
        } else {
            int spaceIndex = stringToPrefix.lastIndexOf(32);
            int lessThanIndex = stringToPrefix.lastIndexOf(60);
            int greaterThanIndex = stringToPrefix.lastIndexOf(62);
            if (greaterThanIndex < lessThanIndex) {
                if (lastChar == '$') {
                    return 3;
                }
                if (lessThanIndex > spaceIndex) {
                    int slashIndex = stringToPrefix.lastIndexOf(47);
                    if (slashIndex == lessThanIndex + 1) {
                        return 5;
                    }
                    return 2;
                }
            }
            if (lessThanIndex < greaterThanIndex) {
                if (this.isPropertyProposalMode(stringToPrefix)) {
                    return 3;
                }
                return 2;
            }
        }
        if (this.isPropertyProposalMode(stringToPrefix)) {
            return 3;
        }
        return 0;
    }

    private boolean isPropertyProposalMode(String stringToPrefix) {
        String lastTwoChars;
        return stringToPrefix.length() >= 2 && ((lastTwoChars = stringToPrefix.substring(stringToPrefix.length() - 2, stringToPrefix.length())).equals("${") || stringToPrefix.charAt(stringToPrefix.length() - 1) == '$');
    }

    private String getTaskStringFromDocumentStringToPrefix(String aDocumentStringToPrefix) {
        int lessThanIndex = aDocumentStringToPrefix.lastIndexOf(60);
        if (lessThanIndex > -1) {
            String taskString = aDocumentStringToPrefix.trim();
            int index = (taskString = taskString.substring(lessThanIndex + 1, taskString.length())).indexOf(32);
            if (index > 0) {
                taskString = taskString.substring(0, index);
            }
            if ((index = taskString.indexOf(10)) > 0) {
                taskString = taskString.substring(0, index);
            }
            if ((index = taskString.indexOf(13)) > 0) {
                taskString = taskString.substring(0, index);
            }
            return taskString;
        }
        return null;
    }

    public static String getAttributeStringFromDocumentStringToPrefix(String docStringToPrefix) {
        int index = docStringToPrefix.lastIndexOf(61);
        if (index == -1) {
            return null;
        }
        String subString = docStringToPrefix.substring(0, index);
        index = (subString = subString.trim()).lastIndexOf(32);
        if (index > 0) {
            subString = subString.substring(index + 1, subString.length());
        }
        if ((index = subString.lastIndexOf(10)) > 0) {
            subString = subString.substring(index + 1, subString.length());
        }
        if ((index = subString.lastIndexOf(13)) > 0) {
            subString = subString.substring(index + 1, subString.length());
        }
        return AntEditorCompletionProcessor.trimBeginning(subString);
    }

    private static String trimBeginning(String toBeTrimmed) {
        int i = 0;
        while (i != toBeTrimmed.length() && Character.isWhitespace(toBeTrimmed.charAt(i))) {
            ++i;
        }
        return toBeTrimmed.substring(i);
    }

    protected boolean isKnownElement(String elementName) {
        if (elementName.equals("target") || elementName.equals("project") || elementName.equals("extension-point")) {
            return true;
        }
        AntProjectNode node = this.antModel.getProjectNode();
        if (node != null) {
            Project antProject = node.getProject();
            ComponentHelper helper = ComponentHelper.getComponentHelper((Project)antProject);
            if (helper.getDefinition(elementName) != null) {
                return true;
            }
            if (helper.getDefinition(this.antModel.getNamespaceCorrectName(elementName)) != null) {
                return true;
            }
            if (this.getDtd().getElement(elementName) != null) {
                return true;
            }
            if (this.getNestedType() != null) {
                return true;
            }
        }
        return false;
    }

    private AntTypeDefinition getTaskClass(String taskName) {
        Project antProject;
        Hashtable tasksAndTypes;
        AntTypeDefinition clss = null;
        AntProjectNode node = this.antModel.getProjectNode();
        if (node != null && (clss = (AntTypeDefinition)(tasksAndTypes = ComponentHelper.getComponentHelper((Project)(antProject = node.getProject())).getAntTypeTable()).get(taskName)) == null) {
            clss = (AntTypeDefinition)tasksAndTypes.get(this.antModel.getNamespaceCorrectName(taskName));
        }
        return clss;
    }

    protected String getParentName(IDocument document, int aLineNumber, int aColumnNumber) {
        if (document.getLength() == 0) {
            return null;
        }
        AntProjectNode project = this.antModel.getProjectNode();
        if (project == null) {
            return null;
        }
        int offset = this.getOffset(document, aLineNumber, aColumnNumber);
        if (offset == -1) {
            return null;
        }
        IAntElement node = project.getNode(offset);
        if (node == null) {
            node = this.antModel.getOpenElement();
        }
        if (node == null) {
            return "";
        }
        if (node instanceof AntTaskNode) {
            String name = node.getName();
            if (offset <= node.getOffset() + name.length() - 1) {
                node = node.getParentNode();
            } else {
                return name;
            }
        }
        if (node instanceof AntTaskNode) {
            return node.getName();
        }
        if (node instanceof AntTargetNode) {
            return "target";
        }
        return "project";
    }

    private Map<String, Object> findPropertiesFromDocument() {
        Project project = this.antModel.getProjectNode().getProject();
        return project.getProperties();
    }

    private Map<String, Target> getTargets() {
        Project project = this.antModel.getProjectNode().getProject();
        return project.getTargets();
    }

    protected File getEditedFile() {
        IWorkbenchPage page = AntUIPlugin.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        FileEditorInput input = (FileEditorInput)editor.getEditorInput();
        String projectPath = input.getFile().getProject().getLocation().toFile().getAbsolutePath();
        String projectRelativeFilePath = input.getFile().getFullPath().removeFirstSegments(1).makeRelative().toString();
        return new File(String.valueOf(projectPath) + File.separator + projectRelativeFilePath);
    }

    private String getOpenElementName() {
        AntElementNode node = this.antModel.getOpenElement();
        if (node == null) {
            return null;
        }
        return node.getName();
    }

    private String getEnclosingTargetName(IDocument document, int aLineNumber, int aColumnNumber) {
        AntProjectNode project = this.antModel.getProjectNode();
        int offset = this.getOffset(document, aLineNumber, aColumnNumber);
        if (offset == -1) {
            return null;
        }
        IAntElement node = project.getNode(offset);
        if (node instanceof AntTaskNode) {
            if (!((node = node.getParentNode()) instanceof AntTargetNode)) {
                node = null;
            }
        } else if (node instanceof AntProjectNode) {
            node = null;
        }
        String targetName = null;
        if (node == null || (targetName = ((AntTargetNode)node).getTarget().getName()) == null || targetName.length() == 0) {
            return null;
        }
        return targetName;
    }

    private int getOffset(IDocument document, int line, int column) {
        try {
            return document.getLineOffset(line) + column - 1;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.autoActivationChars = activationSet;
    }

    protected String extractPrefix(ITextViewer textViewer, int offset) {
        return this.getPrefixFromDocument(textViewer.getDocument().get(), offset);
    }

    protected int getRelevance(Template template, String prefix) {
        String newprefix = prefix;
        if (newprefix.startsWith("<")) {
            newprefix = prefix.substring(1);
        }
        if (template.getName().startsWith(newprefix)) {
            return 90;
        }
        return 0;
    }

    protected Template[] getTemplates(String contextTypeId) {
        return AntTemplateAccess.getDefault().getTemplateStore().getTemplates(contextTypeId);
    }

    protected TemplateContextType getContextType(ITextViewer textViewer, IRegion region) {
        switch (this.determineProposalMode(textViewer.getDocument(), this.cursorPosition, this.getCurrentPrefix())) {
            case 2: {
                if (this.getEnclosingTargetName(textViewer.getDocument(), this.lineNumber, this.columnNumber) == null) {
                    return AntTemplateAccess.getDefault().getContextTypeRegistry().getContextType("org.eclipse.ant.ui.templateContextType.target");
                }
                return AntTemplateAccess.getDefault().getContextTypeRegistry().getContextType("org.eclipse.ant.ui.templateContextType.task");
            }
            case 1: {
                return AntTemplateAccess.getDefault().getContextTypeRegistry().getContextType("org.eclipse.ant.ui.templateContextType.buildFile");
            }
        }
        return null;
    }

    protected Image getImage(Template template) {
        return AntUIImages.getImage("org.eclipse.ant.ui.template_obj");
    }

    protected TemplateContext createContext(ITextViewer contextViewer, IRegion region) {
        TemplateContextType contextType = this.getContextType(contextViewer, region);
        if (contextType != null) {
            Point selection = contextViewer.getSelectedRange();
            Position position = selection.y > 0 ? new Position(selection.x, selection.y) : new Position(region.getOffset(), region.getLength());
            IDocument document = contextViewer.getDocument();
            return new AntContext(contextType, document, this.antModel, position);
        }
        return null;
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        AntTemplateProposal proposal = new AntTemplateProposal(template, context, region, this.getImage(template), relevance);
        proposal.setInformationControlCreator(new AntTemplateInformationControlCreator());
        return proposal;
    }

    protected ISchema getDtd() {
        if (fgDtd == null) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        fgDtd = AntEditorCompletionProcessor.this.parseDtd();
                    }
                    catch (IOException e) {
                        AntUIPlugin.log(e);
                    }
                    catch (ParseError e) {
                        AntUIPlugin.log(e);
                    }
                }
            };
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            try {
                service.busyCursorWhile(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        return fgDtd;
    }

    private TaskDescriptionProvider getDescriptionProvider() {
        return TaskDescriptionProvider.getDefault();
    }

    protected static void resetCodeCompletionDataStructures() {
        fgDtd = null;
        TaskDescriptionProvider.reset();
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        IContentAssistant assistant = event.assistant;
        if (assistant instanceof IContentAssistantExtension2) {
            this.fContentAssistant = (IContentAssistantExtension2)assistant;
        }
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.fContentAssistant = null;
        this.fTemplatesOnly = false;
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    private String getIterationGestureMessage(String showMessage) {
        IBindingService bindingSvc = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        TriggerSequence[] triggers = bindingSvc.getActiveBindingsFor(this.getContentAssistCommand());
        String message = triggers.length > 0 ? MessageFormat.format((String)AntEditorMessages.getString("AntEditorCompletionProcessor.63"), (Object[])new Object[]{triggers[0].format(), showMessage}) : MessageFormat.format((String)AntEditorMessages.getString("AntEditorCompletionProcessor.64"), (Object[])new Object[]{showMessage});
        return message;
    }

    private ParameterizedCommand getContentAssistCommand() {
        ICommandService commandSvc = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        Command command = commandSvc.getCommand("org.eclipse.ui.edit.text.contentAssist.proposals");
        ParameterizedCommand pCmd = new ParameterizedCommand(command, null);
        return pCmd;
    }
}

