/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.m2eclipse;

import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.m2e.core.project.IMavenProjectFacade;

enum ProjectSourceType {
    MAIN,
    TEST,
    BOTH,
    NONE;


    static ProjectSourceType getSourceType(IMavenProjectFacade facade) {
        MavenProject mavenProject = facade.getMavenProject();
        if (ProjectSourceType.compilerPluginUsesGroovyEclipseAdapter(mavenProject, "org.apache.maven.plugins", "maven-compiler-plugin")) {
            return ProjectSourceType.getSourceTypeInGECProject(facade.getProject());
        }
        if (ProjectSourceType.compilerPluginUsesGroovyEclipseAdapter(mavenProject, "org.eclipse.tycho", "tycho-compiler-plugin")) {
            return NONE;
        }
        Plugin plugin = mavenProject.getPlugin("org.codehaus.gmaven:gmaven-plugin");
        if (plugin == null) {
            plugin = mavenProject.getPlugin("org.codehaus.gmavenplus:gmavenplus-plugin");
        }
        if (plugin != null) {
            return ProjectSourceType.getSourceTypeInGMavenProject(plugin);
        }
        return null;
    }

    private static ProjectSourceType getSourceTypeInGECProject(IProject project) {
        boolean srcMainGroovy = project.getFolder("src/main/groovy").exists();
        boolean srcTestGroovy = project.getFolder("src/test/groovy").exists();
        if (srcMainGroovy) {
            if (srcTestGroovy) {
                return BOTH;
            }
            return MAIN;
        }
        if (srcTestGroovy) {
            return TEST;
        }
        return NONE;
    }

    private static ProjectSourceType getSourceTypeInGMavenProject(Plugin plugin) {
        ProjectSourceType result = NONE;
        if (plugin != null && plugin.getExecutions() != null && !plugin.getExecutions().isEmpty()) {
            for (PluginExecution execution : plugin.getExecutions()) {
                List goals = execution.getGoals();
                if (goals.contains("compile")) {
                    switch (result) {
                        case NONE: {
                            result = MAIN;
                            break;
                        }
                        case TEST: {
                            result = BOTH;
                        }
                    }
                }
                if (!goals.contains("compileTests") && !goals.contains("testCompile")) continue;
                switch (result) {
                    case NONE: {
                        result = TEST;
                        break;
                    }
                    case MAIN: {
                        result = BOTH;
                    }
                }
            }
        }
        return result;
    }

    private static boolean compilerPluginUsesGroovyEclipseAdapter(MavenProject mavenProject, String pluginGroupId, String pluginArtifactId) {
        for (Plugin buildPlugin : mavenProject.getBuildPlugins()) {
            if (!pluginArtifactId.equals(buildPlugin.getArtifactId()) || !pluginGroupId.equals(buildPlugin.getGroupId())) continue;
            for (Dependency dependency : buildPlugin.getDependencies()) {
                if (!"groovy-eclipse-compiler".equals(dependency.getArtifactId()) || !"org.codehaus.groovy".equals(dependency.getGroupId())) continue;
                return true;
            }
        }
        return false;
    }
}

