/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.wizards;

import java.lang.reflect.InvocationTargetException;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.groovy.eclipse.ui.decorators.GroovyPluginImages;
import org.codehaus.groovy.eclipse.wizards.WizardMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageTwo;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewProjWizard
extends NewElementWizard
implements IExecutableExtension {
    private IConfigurationElement configElement;
    private NewJavaProjectWizardPageOne pageOne;
    private NewJavaProjectWizardPageTwo pageTwo;

    public NewProjWizard() {
        this.setDefaultPageImageDescriptor(GroovyPluginImages.DESC_NEW_GROOVY_PROJECT);
        this.setDialogSettings(GroovyPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(WizardMessages.NewProjWizard_title);
    }

    public void addPages() {
        this.pageOne = new NewJavaProjectWizardPageOne(){

            public IClasspathEntry[] getDefaultClasspathEntries() {
                Object[] entries = super.getDefaultClasspathEntries();
                entries = (IClasspathEntry[])ArrayUtils.add((Object[])entries, (Object)GroovyRuntime.newGroovyClasspathContainerEntry((boolean)false, (boolean)false, null));
                String namespace = "org.codehaus.groovy.eclipse.dsl";
                ScopedPreferenceStore prefs = new ScopedPreferenceStore(InstanceScope.INSTANCE, namespace);
                if (!prefs.getBoolean(String.valueOf(namespace) + ".disabled")) {
                    entries = (IClasspathEntry[])ArrayUtils.add((Object[])entries, (int)(entries.length - 1), (Object)JavaCore.newContainerEntry((IPath)new Path("GROOVY_DSL_SUPPORT")));
                }
                return entries;
            }
        };
        this.pageOne.setTitle(WizardMessages.NewProjWizard_page1_title);
        this.pageOne.setDescription(WizardMessages.NewProjWizard_page1_message);
        this.addPage((IWizardPage)this.pageOne);
        this.pageTwo = new NewJavaProjectWizardPageTwo(this.pageOne){

            public void createControl(Composite parent) {
                Object createModuleInfo;
                Object sourceFolderPage;
                super.createControl(parent);
                Object buildPathsBlock = ReflectionUtils.executePrivateMethod(JavaCapabilityConfigurationPage.class, (String)"getBuildPathsBlock", (Object)((Object)this));
                if (buildPathsBlock != null && (sourceFolderPage = ReflectionUtils.executePrivateMethod(buildPathsBlock.getClass(), (String)"getSourceContainerPage", (Object)buildPathsBlock)) != null && (createModuleInfo = ReflectionUtils.getPrivateField(sourceFolderPage.getClass(), (String)"fCreateModuleInfoFileButton", (Object)sourceFolderPage)) != null) {
                    ReflectionUtils.executePrivateMethod(createModuleInfo.getClass(), (String)"setSelection", (Class[])new Class[]{Boolean.TYPE}, (Object)createModuleInfo, (Object[])new Object[]{Boolean.FALSE});
                }
            }
        };
        this.pageTwo.setTitle(WizardMessages.NewProjWizard_page2_title);
        this.pageTwo.setDescription(WizardMessages.NewProjWizard_page2_message);
        this.addPage((IWizardPage)this.pageTwo);
    }

    public boolean performCancel() {
        this.pageTwo.performCancel();
        return super.performCancel();
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result) {
            IProject project = this.getCreatedElement().getProject();
            try {
                GroovyRuntime.addGroovyNature((IProject)project);
            }
            catch (CoreException e) {
                GroovyPlugin.getDefault().logError("Error adding Groovy nature to project " + project.getName(), e);
            }
            IWorkingSet[] workingSets = this.pageOne.getWorkingSets();
            if (workingSets.length > 0) {
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)project, workingSets);
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configElement);
            this.selectAndReveal((IResource)project);
        }
        return result;
    }

    public IJavaProject getCreatedElement() {
        return this.pageTwo.getJavaProject();
    }

    protected void finishPage(IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.pageTwo.performFinish(monitor);
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)WizardMessages.NewProjWizard_error_title, (String)WizardMessages.NewProjWizard_error_message);
    }

    public void setInitializationData(IConfigurationElement configElement, String propertyName, Object data) {
        this.configElement = configElement;
    }
}

