/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.ui.console;

import java.util.Calendar;
import java.util.Date;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.IGroovyLogger;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.ui.console.GroovyConsole;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsolePage;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.console.actions.CloseConsoleAction;
import org.eclipse.ui.internal.console.ScrollLockAction;
import org.eclipse.ui.part.IPageSite;

public class GroovyConsolePage
extends TextConsolePage
implements IGroovyLogger {
    private ScrollLockAction fScrollLockAction;
    private CloseConsoleAction fCloseConsoleAction;

    public GroovyConsolePage(TextConsole console, IConsoleView view) {
        super(console, view);
    }

    private String twodigit(int i) {
        String number = Integer.toString(i);
        if (number.length() < 2) {
            return new StringBuffer("0").append(number).toString();
        }
        return number.toString();
    }

    public void log(TraceCategory category, String message) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        StringBuilder time = new StringBuilder();
        time.append(this.twodigit(calendar.get(11))).append(":");
        time.append(this.twodigit(calendar.get(12))).append(":");
        time.append(this.twodigit(calendar.get(13)));
        time.append(" ").append(message).append("\n");
        String txt = time.toString();
        this.getControl().getDisplay().asyncExec(() -> {
            TextConsoleViewer viewer = this.getViewer();
            if (viewer != null) {
                StyledText text = viewer.getTextWidget();
                text.append(String.valueOf(category.getPaddedLabel()) + " : " + txt);
                if (!this.fScrollLockAction.isChecked()) {
                    text.setTopIndex(text.getLineCount() - 1);
                }
            }
        });
    }

    public boolean isCategoryEnabled(TraceCategory category) {
        return true;
    }

    public void init(IPageSite pageSite) throws PartInitException {
        super.init(pageSite);
        GroovyLogManager.manager.addLogger((IGroovyLogger)this);
    }

    public void dispose() {
        super.dispose();
        if (this.fScrollLockAction != null) {
            this.fScrollLockAction.dispose();
            this.fScrollLockAction = null;
        }
        this.fCloseConsoleAction = null;
        GroovyLogManager.manager.removeLogger((IGroovyLogger)this);
    }

    protected TextConsoleViewer createViewer(Composite parent) {
        TextConsoleViewer viewer = new TextConsoleViewer(parent, (TextConsole)((GroovyConsole)this.getConsole()));
        viewer.setEditable(false);
        return viewer;
    }

    protected void createActions() {
        super.createActions();
        this.fScrollLockAction = new ScrollLockAction(this.getConsoleView());
        this.fCloseConsoleAction = new CloseConsoleAction(this.getConsole());
        this.setAutoScroll(!this.fScrollLockAction.isChecked());
    }

    public void setAutoScroll(boolean scroll) {
        TextConsoleViewer viewer = this.getViewer();
        if (viewer != null) {
            this.fScrollLockAction.setChecked(!scroll);
        }
    }

    protected void configureToolBar(IToolBarManager mgr) {
        super.configureToolBar(mgr);
        mgr.appendToGroup("outputGroup", (IAction)this.fScrollLockAction);
        mgr.appendToGroup("launchGroup", (IAction)this.fCloseConsoleAction);
    }
}

