/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.actions;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.corext.util.TypeFilter;

public class TypeSearch {
    public void searchForTypes(GroovyCompilationUnit unit, Map<String, UnresolvedTypeData> missingTypes, IProgressMonitor monitor) throws JavaModelException, OperationCanceledException {
        char[][] allTypes = new char[missingTypes.size()][];
        int i = 0;
        for (String simpleName : missingTypes.keySet()) {
            allTypes[i++] = simpleName.toCharArray();
        }
        final ArrayList typesFound = new ArrayList();
        TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

            public void acceptTypeNameMatch(TypeNameMatch match) {
                if (!TypeFilter.isFiltered((TypeNameMatch)match)) {
                    typesFound.add(match);
                }
            }
        };
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{unit.getJavaProject()});
        int policy = monitor == null ? 2 : 3;
        new SearchEngine().searchAllTypeNames(null, (char[][])allTypes, scope, requestor, policy, monitor);
        for (TypeNameMatch match : typesFound) {
            UnresolvedTypeData data = missingTypes.get(match.getSimpleTypeName());
            if (data == null) {
                GroovyCore.logException((String)("GRECLIPSE-735: Match not found in missing types: " + match.getFullyQualifiedName()), (Throwable)new Exception());
                continue;
            }
            if (!this.isOfKind(match, data.isAnnotation)) continue;
            data.addInfo(match);
        }
    }

    protected boolean isOfKind(TypeNameMatch match, boolean isAnnotation) throws JavaModelException {
        if (!isAnnotation || Flags.isAnnotation((int)match.getModifiers())) {
            return true;
        }
        if (match.getType() instanceof BinaryType && match.getType().getAnnotations() != null) {
            IAnnotation[] iAnnotationArray = match.getType().getAnnotations();
            int n = iAnnotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation anno = iAnnotationArray[n2];
                if ("groovy.transform.AnnotationCollector".equals(anno.getElementName())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static class UnresolvedTypeData {
        final String ref;
        final boolean isAnnotation;
        final ISourceRange range;
        final List<TypeNameMatch> foundInfos = new LinkedList<TypeNameMatch>();

        public UnresolvedTypeData(String ref, boolean annotation, ISourceRange range) {
            this.ref = ref;
            this.isAnnotation = annotation;
            this.range = range;
        }

        public void addInfo(TypeNameMatch info) {
            int i = this.foundInfos.size() - 1;
            while (i >= 0) {
                TypeNameMatch curr = this.foundInfos.get(i);
                if (curr.getTypeContainerName().equals(info.getTypeContainerName())) {
                    return;
                }
                --i;
            }
            this.foundInfos.add(info);
        }

        public List<TypeNameMatch> getFoundInfos() {
            return this.foundInfos;
        }
    }
}

