/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.preferences;

import java.io.IOException;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCoreActivator;
import org.codehaus.groovy.eclipse.core.builder.GroovyClasspathContainer;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.groovy.eclipse.preferences.CompilerSwitchUIHelper;
import org.codehaus.groovy.eclipse.preferences.Messages;
import org.codehaus.groovy.eclipse.preferences.ScriptFolderSelectorPreferences;
import org.codehaus.groovy.frameworkadapter.util.SpecifiedVersion;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class CompilerPreferencesPage
extends PropertyAndPreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PREFERENCES_ID = "org.codehaus.groovy.eclipse.preferences.compiler";
    public static final String PROPERTY_ID = "org.codehaus.groovy.eclipse.preferences.compiler.project";
    private IEclipsePreferences preferences;
    private SpecifiedVersion compilerSelection;
    private ComboViewer compilerSelector;
    private Button compilerMismatchCheck;
    private FileFieldEditor configScriptSelector;
    private ScriptFolderSelectorPreferences scriptFolderSelector;
    private Button groovyLibCheck;

    protected Label createDescriptionLabel(Composite parent) {
        if (this.isProjectPreferencePage()) {
            this.createProjectCompilerSection(parent);
        }
        return super.createDescriptionLabel(parent);
    }

    protected Control createPreferenceContent(Composite parent) {
        this.getPreferenceStore();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        Composite panel = new Composite(parent, 0);
        panel.setFont(parent.getFont());
        panel.setLayout((Layout)layout);
        if (!this.isProjectPreferencePage()) {
            this.createWorkspaceCompilerSection(panel);
        }
        this.scriptFolderSelector = new ScriptFolderSelectorPreferences(panel, this.preferences, this.getPreferenceStore(), this.getProject());
        this.scriptFolderSelector.createListContents();
        if (!this.isProjectPreferencePage()) {
            this.createClasspathContainerSection(panel);
        }
        return panel;
    }

    private void createProjectCompilerSection(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 8;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        Composite panel = new Composite(parent, 0);
        panel.setFont(parent.getFont());
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        Label compilerLabel = new Label(panel, 64);
        compilerLabel.setFont(parent.getFont());
        compilerLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        compilerLabel.setText(Messages.getString("GroovyCompilerPreferencesPage.ProjectCompilerLevel"));
        this.compilerSelector = new ComboViewer(new Combo(panel, 12));
        this.compilerSelector.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof SpecifiedVersion) {
                    return ((SpecifiedVersion)element).toReadableVersionString();
                }
                return "";
            }
        });
        this.compilerSelector.add((Object)SpecifiedVersion.DONT_CARE);
        for (SpecifiedVersion version : CompilerUtils.getAllGroovyVersions()) {
            this.compilerSelector.add((Object)version);
        }
        this.compilerSelection = CompilerUtils.getCompilerLevel((IProject)this.getProject());
        this.compilerSelector.setSelection((ISelection)new StructuredSelection((Object)this.compilerSelection), true);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 15;
        gridData.grabExcessHorizontalSpace = false;
        Label explainLabel = new Label(panel, 64);
        explainLabel.setLayoutData((Object)gridData);
        explainLabel.setText(Messages.getString("GroovyCompilerPreferencesPage.ProjectCompilerError"));
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 15;
        Composite subpanel = new Composite(panel, 0);
        subpanel.setFont(parent.getFont());
        subpanel.setLayoutData((Object)gridData);
        this.configScriptSelector = new FileFieldEditor("org.eclipse.jdt.core.compiler.groovy.groovyCompilerConfigScript", Messages.getString("GroovyCompilerPreferencesPage.CompilerConfigScript"), subpanel){

            protected String changePressed() {
                String value = super.changePressed();
                if (value != null) {
                    Path path = new Path(value);
                    if (CompilerPreferencesPage.this.getProject().getLocation().isPrefixOf((IPath)path)) {
                        value = path.makeRelativeTo(CompilerPreferencesPage.this.getProject().getLocation()).toOSString();
                    }
                }
                return value;
            }

            public void store() {
                super.store();
                IPreferenceStore store = this.getPreferenceStore();
                if (store.needsSaving() && store instanceof IPersistentPreferenceStore) {
                    try {
                        ((IPersistentPreferenceStore)store).save();
                    }
                    catch (IOException e) {
                        String message = JFaceResources.format((String)"PreferenceDialog.saveErrorMessage", (Object[])new Object[]{Messages.getString("GroovyCompilerPreferencesPage.GroovyCompilerLabel"), e.getMessage()});
                        Policy.getStatusHandler().show((IStatus)new Status(4, "org.eclipse.jface", message, (Throwable)e), JFaceResources.getString((String)"PreferenceDialog.saveErrorTitle"));
                    }
                }
            }
        };
        this.configScriptSelector.setFilterPath(this.getProject().getLocation().toFile());
        this.configScriptSelector.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.getProject()), "org.eclipse.jdt.core"));
        this.configScriptSelector.load();
    }

    private void createWorkspaceCompilerSection(Composite parent) {
        Group group = new Group(parent, 32);
        group.setFont(parent.getFont());
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.getString("GroovyCompilerPreferencesPage.GroovyCompilerLabel"));
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).applyTo((Control)group);
        CompilerSwitchUIHelper.createCompilerSwitchBlock((Composite)group);
        this.compilerMismatchCheck = new Button((Composite)group, 32);
        this.compilerMismatchCheck.setSelection(this.getCompilerCheckPref());
        this.compilerMismatchCheck.setText(Messages.getString("GroovyCompilerPreferencesPage.ProjectCompilerCheck"));
    }

    private void createClasspathContainerSection(Composite parent) {
        Group group = new Group(parent, 32);
        group.setFont(parent.getFont());
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.getString("GroovyCompilerPreferencesPage.ClasspathContainerLabel"));
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).indent(0, 7).applyTo((Control)group);
        this.groovyLibCheck = new Button((Composite)group, 32);
        this.groovyLibCheck.setSelection(this.getGroovyLibsPref());
        this.groovyLibCheck.setText(Messages.getString("GroovyCompilerPreferencesPage.IncludeGroovyLibs"));
        Label groovyLibLabel = new Label((Composite)group, 64);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).hint(400, -1).applyTo((Control)groovyLibLabel);
        groovyLibLabel.setText(Messages.getString("GroovyCompilerPreferencesPage.IncludeGroovyLibsDesc"));
        Button updateButton = new Button((Composite)group, 8);
        updateButton.setText(Messages.getString("GroovyCompilerPreferencesPage.UpdateGroovyLibs"));
        updateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CompilerPreferencesPage.this.updateClasspathContainers();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CompilerPreferencesPage.this.updateClasspathContainers();
            }
        });
        GridDataFactory.swtDefaults().indent(0, 10).applyTo((Control)updateButton);
        Label updateLabel = new Label((Composite)group, 64);
        GridDataFactory.swtDefaults().align(4, 128).grab(true, false).hint(400, -1).applyTo((Control)updateLabel);
        updateLabel.setText(Messages.getString("GroovyCompilerPreferencesPage.UpdateGroovyLibsDesc"));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        IScopeContext scope = this.isProjectPreferencePage() ? new ProjectScope(this.getProject()) : InstanceScope.INSTANCE;
        this.preferences = scope.getNode("org.eclipse.jdt.groovy.core");
        ScopedPreferenceStore store = new ScopedPreferenceStore(scope, "org.eclipse.jdt.groovy.core");
        store.setDefault("groovy.script.filters.enabled", true);
        return store;
    }

    protected void enablePreferenceContent(boolean enable) {
        super.enablePreferenceContent(enable);
        if (enable) {
            this.scriptFolderSelector.enableControls();
        }
    }

    protected void performDefaults() {
        if (this.compilerSelector != null) {
            this.compilerSelector.setSelection((ISelection)new StructuredSelection((Object)SpecifiedVersion.DONT_CARE), true);
        }
        if (this.compilerMismatchCheck != null) {
            this.compilerMismatchCheck.setSelection(true);
        }
        if (this.configScriptSelector != null) {
            this.configScriptSelector.setStringValue(null);
        }
        if (this.groovyLibCheck != null) {
            this.groovyLibCheck.setSelection(true);
        }
        this.scriptFolderSelector.restoreDefaults();
        super.performDefaults();
        if (!this.isProjectPreferencePage()) {
            this.enablePreferenceContent(true);
        }
    }

    public boolean performOk() {
        if (this.compilerSelector != null) {
            StructuredSelection selection = (StructuredSelection)this.compilerSelector.getSelection();
            SpecifiedVersion selected = (SpecifiedVersion)selection.getFirstElement();
            if (selected == null) {
                selected = SpecifiedVersion.UNSPECIFIED;
            }
            if (selected != this.compilerSelection && selected != SpecifiedVersion.UNSPECIFIED) {
                CompilerUtils.setCompilerLevel((IProject)this.getProject(), (SpecifiedVersion)selected, (boolean)true);
            }
        }
        if (this.compilerMismatchCheck != null) {
            boolean isSelected = this.compilerMismatchCheck.getSelection();
            boolean currentPref = this.getCompilerCheckPref();
            if (!isSelected && currentPref) {
                try {
                    ResourcesPlugin.getWorkspace().getRoot().deleteMarkers("org.codehaus.groovy.eclipse.core.compilerMismatch", true, 1);
                }
                catch (CoreException e) {
                    GroovyPlugin.getDefault().logError("Error deleting markers", e);
                }
            }
            if (isSelected != currentPref) {
                this.setCompilerCheckPref(isSelected);
            }
        }
        if (!this.isProjectPreferencePage()) {
            this.setGroovyLibsPref(this.groovyLibCheck.getSelection());
        } else {
            this.configScriptSelector.store();
            this.getPreferenceStore().setValue(PROPERTY_ID, this.useProjectSettings());
        }
        this.scriptFolderSelector.applyPreferences();
        return super.performOk();
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        if (project != null && project.equals((Object)this.getProject())) {
            return this.getPreferenceStore().getBoolean(PROPERTY_ID);
        }
        return false;
    }

    protected String getPreferencePageID() {
        return PREFERENCES_ID;
    }

    protected String getPropertyPageID() {
        return PROPERTY_ID;
    }

    private boolean getCompilerCheckPref() {
        return this.preferences.getBoolean("groovy.check.for.compiler.mismatch", true);
    }

    private void setCompilerCheckPref(boolean value) {
        this.preferences.putBoolean("groovy.check.for.compiler.mismatch", value);
        try {
            this.preferences.flush();
        }
        catch (BackingStoreException e) {
            GroovyPlugin.getDefault().logError("Error saving compiler preferences", e);
        }
    }

    private boolean getGroovyLibsPref() {
        IEclipsePreferences corePrefs = GroovyCoreActivator.getDefault().getPreferences();
        return corePrefs.getBoolean("groovy.classpath.use.groovy.lib.global", true);
    }

    private void setGroovyLibsPref(boolean value) {
        IEclipsePreferences corePrefs = GroovyCoreActivator.getDefault().getPreferences();
        corePrefs.putBoolean("groovy.classpath.use.groovy.lib.global", value);
        try {
            corePrefs.flush();
        }
        catch (BackingStoreException e) {
            GroovyPlugin.getDefault().logError("Error saving groovy libs preference", e);
        }
    }

    private void updateClasspathContainers() {
        try {
            IJavaProject[] iJavaProjectArray = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
            int n = iJavaProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathContainer container;
                IJavaProject javaProject = iJavaProjectArray[n2];
                IPath containerPath = GroovyRuntime.findClasspathEntry((IJavaProject)javaProject, cpe -> "GROOVY_SUPPORT".equals(cpe.getPath().segment(0))).map(IClasspathEntry::getPath).orElse(null);
                if (containerPath != null && !containerPath.lastSegment().equals("minimal") && !containerPath.lastSegment().equals("user-libs=false") && (container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)javaProject)) instanceof GroovyClasspathContainer) {
                    ((GroovyClasspathContainer)container).reset();
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            GroovyPlugin.getDefault().logError("Problem updating Groovy classpath contianers", e);
        }
    }
}

