/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.actions;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.eclipse.ui.utils.GroovyResourceUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class RenameToGroovyOrJavaAction
implements IWorkbenchWindowActionDelegate {
    private ISelection selection;
    private String javaOrGroovy;

    public RenameToGroovyOrJavaAction(String javaOrGroovy) {
        this.javaOrGroovy = javaOrGroovy;
    }

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            GroovyResourceUtil.renameFile(this.javaOrGroovy, this.getResources((IStructuredSelection)this.selection));
        }
    }

    protected List<IResource> getResources(IStructuredSelection selection) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        if (selection != null) {
            for (Object object : selection) {
                IResource file;
                if (!(object instanceof IAdaptable) || (file = (IResource)Adapters.adapt(object, IResource.class)) == null || file.getType() != 1) continue;
                resources.add(file);
            }
        }
        return resources;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void dispose() {
        this.selection = null;
    }

    public void init(IWorkbenchWindow window) {
    }
}

