/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor.actions;

import org.codehaus.groovy.eclipse.editor.GroovyEditor;
import org.codehaus.groovy.eclipse.search.GroovyOccurrencesFinder;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class FindOccurrencesAction
implements IEditorActionDelegate {
    private GroovyEditor editor;
    private TextSelection sel;

    public void run(IAction action) {
        if (this.editor == null || this.sel == null) {
            return;
        }
        ISelection editorSel = this.editor.getSelectionProvider().getSelection();
        if (editorSel instanceof TextSelection) {
            this.sel = (TextSelection)editorSel;
        }
        try {
            String result = GroovyOccurrencesFinder.newFinderEngine().run((ITypeRoot)this.editor.getGroovyCompilationUnit(), this.sel.getOffset(), this.sel.getLength());
            if (result != null) {
                this.showMessage(this.getShell(), result);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log((Throwable)e);
        }
    }

    private Shell getShell() {
        if (this.editor == null) {
            return null;
        }
        return this.editor.getSite().getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.sel = selection instanceof TextSelection ? (TextSelection)selection : null;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = targetEditor instanceof GroovyEditor ? (GroovyEditor)targetEditor : null;
    }

    private void showMessage(Shell shell, String msg) {
        IEditorStatusLine statusLine = (IEditorStatusLine)Adapters.adapt((Object)((Object)this.editor), IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, msg, null);
        }
        if (shell != null) {
            shell.getDisplay().beep();
        }
    }
}

