/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.rewriter;

import java.util.List;
import org.codehaus.groovy.antlr.LineColumn;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.core.utils.FilePartReader;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class ASTWriterHelper {
    public static final int MOD_FIELD = 1;
    public static final int MOD_CLASS = 2;
    public static final int MOD_METHOD = 3;

    public static String getAccModifier(int modifiers, int appearance) {
        StringBuilder accMod = new StringBuilder();
        if (Flags.isPrivate((int)modifiers)) {
            accMod.append("private ");
        } else if (Flags.isPublic((int)modifiers)) {
            if (appearance == 3) {
                accMod.append("def ");
            } else if (appearance == 1) {
                accMod.append("public ");
            }
        } else if (Flags.isProtected((int)modifiers)) {
            accMod.append("protected ");
        }
        if (Flags.isStatic((int)modifiers)) {
            accMod.append("static ");
        }
        if (Flags.isTransient((int)modifiers)) {
            accMod.append("transient ");
        }
        if (Flags.isFinal((int)modifiers)) {
            accMod.append("final ");
        }
        if (Flags.isSynchronized((int)modifiers)) {
            accMod.append("synchronized ");
        }
        if (Flags.isVolatile((int)modifiers)) {
            accMod.append("volatile ");
        }
        if (Flags.isNative((int)modifiers)) {
            accMod.append("native ");
        }
        if (Flags.isStrictfp((int)modifiers)) {
            accMod.append("strictfp ");
        }
        return accMod.toString();
    }

    public static boolean isProperty(FieldNode node) {
        List properties = node.getOwner().getProperties();
        for (PropertyNode property : properties) {
            if (!property.getField().equals(node)) continue;
            return true;
        }
        return false;
    }

    public static String getStringMarker(IDocument currentDocument, LineColumn coords) {
        String expressionInFile;
        if (currentDocument == null) {
            return "\"";
        }
        try {
            expressionInFile = FilePartReader.readForwardFromCoordinate(currentDocument, coords);
        }
        catch (BadLocationException e) {
            GroovyCore.logException((String)"Error during refactoring...trying to recover", (Throwable)e);
            expressionInFile = "";
        }
        char charBefore = expressionInFile.charAt(0);
        String firstThreeChars = "";
        boolean firstThreeCharsAreSame = false;
        if (expressionInFile.length() >= 3) {
            firstThreeChars = expressionInFile.substring(0, 3);
            boolean bl = firstThreeCharsAreSame = firstThreeChars.charAt(0) == firstThreeChars.charAt(1) && firstThreeChars.charAt(1) == firstThreeChars.charAt(2);
        }
        if (charBefore == '\'' || charBefore == '\"' || charBefore == '/') {
            if (firstThreeCharsAreSame) {
                return firstThreeChars;
            }
            return String.valueOf(charBefore);
        }
        return "\"";
    }
}

