/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.rename;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.search.SyntheticAccessorSearchRequestor;
import org.codehaus.groovy.eclipse.refactoring.core.utils.StatusHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.ReferencesInBinaryContext;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class PropertyAccessRenameParticipant
extends RenameParticipant {
    private IMember renameTarget;
    private List<SearchMatch> matches;

    public String getName() {
        return "Rename Groovy property getters and setters.";
    }

    protected boolean initialize(Object element) {
        if (element instanceof IMethod || element instanceof IField) {
            this.renameTarget = (IMember)element;
            if (!this.renameTarget.isReadOnly()) {
                return true;
            }
        }
        return false;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) {
        RefactoringStatus status = new RefactoringStatus();
        this.matches = new ArrayList<SearchMatch>();
        try {
            if (this.getArguments().getUpdateReferences()) {
                this.findExtraReferences((IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (String)"Finding Groovy property references", (int)20));
            }
            this.checkForBinaryRefs(status);
            this.checkForPotentialMatches(status);
            SearchResultGroup[] groups = this.convertMatches();
            Checks.excludeCompilationUnits((SearchResultGroup[])groups, (RefactoringStatus)status);
            status.merge(Checks.checkCompileErrorsInAffectedFiles((SearchResultGroup[])groups));
        }
        catch (CoreException e) {
            GroovyCore.logException((String)e.getLocalizedMessage(), (Throwable)e);
            return RefactoringStatus.createFatalErrorStatus((String)e.getLocalizedMessage());
        }
        return status;
    }

    private void findExtraReferences(IProgressMonitor pm) throws CoreException {
        SyntheticAccessorSearchRequestor requestor = new SyntheticAccessorSearchRequestor();
        requestor.findSyntheticMatches((IJavaElement)this.renameTarget, this.matches::add, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (String)"Find synthetic property accessors", (int)10));
        if (this.renameTarget.getElementType() == 9 && this.renameTarget.getElementName().matches("(?:[gs]et|is)\\p{javaJavaIdentifierPart}+") && ((IMethod)this.renameTarget).getParameters().length == (this.renameTarget.getElementName().startsWith("set") ? 1 : 0)) {
            String name = PropertyAccessRenameParticipant.propertyName(this.renameTarget.getElementName());
            IMethod method = ((IType)this.renameTarget.getParent()).getMethod(name, ((IMethod)this.renameTarget).getParameterTypes());
            if (!method.exists()) {
                method = (IMethod)SyntheticAccessorSearchRequestor.syntheticMemberProxy(IMethod.class, (IMember)method, (String)((IMethod)this.renameTarget).getReturnType());
                SearchPattern pattern = SearchPattern.createPattern((IJavaElement)method, (int)2);
                SearchParticipant[] searchParticipants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
                new SearchEngine().search(pattern, searchParticipants, SearchEngine.createWorkspaceScope(), new SearchRequestor(){

                    public void acceptSearchMatch(SearchMatch match) throws CoreException {
                        PropertyAccessRenameParticipant.this.matches.add(match);
                    }
                }, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)pm, (String)"Find property-style uses of non-synthetic methods", (int)10));
                return;
            }
        }
        pm.worked(10);
    }

    private void checkForBinaryRefs(RefactoringStatus status) throws JavaModelException {
        ReferencesInBinaryContext binaryRefs = new ReferencesInBinaryContext("Elements containing binary references to refactored element ''" + this.renameTarget.getElementName() + "''");
        Iterator<SearchMatch> it = this.matches.iterator();
        while (it.hasNext()) {
            SearchMatch match = it.next();
            if (!PropertyAccessRenameParticipant.isBinaryElement(match.getElement())) continue;
            if (match.getAccuracy() == 0) {
                binaryRefs.add(match);
            }
            it.remove();
        }
        binaryRefs.addErrorIfNecessary(status);
    }

    private static boolean isBinaryElement(Object element) throws JavaModelException {
        if (element instanceof IMember) {
            return ((IMember)element).isBinary();
        }
        if (element instanceof IClassFile) {
            return false;
        }
        if (element instanceof ICompilationUnit) {
            return true;
        }
        if (element instanceof IPackageFragment) {
            return PropertyAccessRenameParticipant.isBinaryElement(((IPackageFragment)element).getParent());
        }
        if (element instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)element).getKind() == 2;
        }
        return false;
    }

    private void checkForPotentialMatches(RefactoringStatus status) {
        for (SearchMatch match : this.matches) {
            if (match.getAccuracy() != 1) continue;
            RefactoringStatusEntry entry = new RefactoringStatusEntry(2, RefactoringCoreMessages.RefactoringSearchEngine_potential_matches, StatusHelper.createContext((ITypeRoot)JavaCore.createCompilationUnitFrom((IFile)((IFile)match.getResource())), (ISourceRange)new SourceRange(match.getOffset(), match.getLength())));
            status.addEntry(entry);
        }
    }

    private SearchResultGroup[] convertMatches() {
        HashMap<IResource, SearchResultGroup> groups = new HashMap<IResource, SearchResultGroup>(this.matches.size());
        for (SearchMatch match : this.matches) {
            if (match.getResource() == null) continue;
            groups.computeIfAbsent(match.getResource(), mr -> new SearchResultGroup(mr, new SearchMatch[0])).add(match);
        }
        return groups.values().toArray(new SearchResultGroup[groups.size()]);
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(this.getName());
        this.createMatchedChanges(this.matches, change, this.getNameMap());
        if (change.getChildren().length > 0) {
            return change;
        }
        return null;
    }

    private void addChange(CompositeChange finalChange, IMember enclosingElement, int offset, int length, String newName) {
        CompilationUnitChange existingChange = this.findOrCreateChange(enclosingElement, finalChange);
        TextEditChangeGroup[] groups = existingChange.getTextEditChangeGroups();
        ReplaceEdit occurrenceEdit = new ReplaceEdit(offset, length, newName);
        boolean isOverlapping = false;
        TextEditChangeGroup[] textEditChangeGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditChangeGroup group = textEditChangeGroupArray[n2];
            if (group.getTextEdits()[0].covers((TextEdit)occurrenceEdit)) {
                isOverlapping = true;
                break;
            }
            ++n2;
        }
        if (isOverlapping) {
            return;
        }
        existingChange.addEdit((TextEdit)occurrenceEdit);
        existingChange.addChangeGroup((TextEditBasedChangeGroup)new TextEditChangeGroup((TextChange)existingChange, new TextEditGroup("Update synthetic Groovy accessor", (TextEdit)occurrenceEdit)));
    }

    private void createMatchedChanges(List<SearchMatch> references, CompositeChange finalChange, Map<String, String> nameMap) throws JavaModelException {
        for (SearchMatch searchMatch : references) {
            String oldName;
            Object elt = searchMatch.getElement();
            if (!(elt instanceof IMember) || (oldName = this.findMatchName(searchMatch, nameMap.keySet())) == null) continue;
            String newName = nameMap.get(oldName);
            this.addChange(finalChange, (IMember)elt, searchMatch.getOffset(), oldName.length(), newName);
        }
    }

    private String findMatchName(SearchMatch searchMatch, Set<String> keySet) throws JavaModelException {
        IJavaElement element = JavaCore.create((IResource)searchMatch.getResource());
        if (element.getElementType() == 5) {
            ICompilationUnit unit = (ICompilationUnit)element;
            String matchedText = unit.getBuffer().getText(searchMatch.getOffset(), searchMatch.getLength());
            for (String oldName : keySet) {
                if (!matchedText.startsWith(oldName)) continue;
                return oldName;
            }
        }
        return null;
    }

    private CompilationUnitChange findOrCreateChange(IMember accessor, CompositeChange finalChange) {
        TextChange textChange = this.getTextChange(accessor.getCompilationUnit());
        CompilationUnitChange existingChange = null;
        if (textChange instanceof CompilationUnitChange) {
            existingChange = (CompilationUnitChange)textChange;
        } else {
            Change[] children;
            Change[] changeArray = children = finalChange.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Change change = changeArray[n2];
                if (change instanceof CompilationUnitChange && ((CompilationUnitChange)change).getCompilationUnit().equals(accessor.getCompilationUnit())) {
                    existingChange = (CompilationUnitChange)change;
                    break;
                }
                ++n2;
            }
        }
        if (existingChange == null) {
            existingChange = new CompilationUnitChange("Synthetic Groovy Accessor changes for " + accessor.getCompilationUnit().getElementName(), accessor.getCompilationUnit());
            existingChange.setEdit((TextEdit)new MultiTextEdit());
            finalChange.add((Change)existingChange);
        }
        return existingChange;
    }

    private Map<String, String> getNameMap() {
        HashMap<String, String> nameMap = new HashMap<String, String>(4);
        String newBaseName = PropertyAccessRenameParticipant.propertyName(this.getArguments().getNewName());
        String oldBaseName = PropertyAccessRenameParticipant.propertyName(this.renameTarget.getElementName());
        nameMap.put(oldBaseName, newBaseName);
        nameMap.put(PropertyAccessRenameParticipant.accessorName("is", oldBaseName), PropertyAccessRenameParticipant.accessorName("is", newBaseName));
        nameMap.put(PropertyAccessRenameParticipant.accessorName("get", oldBaseName), PropertyAccessRenameParticipant.accessorName("get", newBaseName));
        nameMap.put(PropertyAccessRenameParticipant.accessorName("set", oldBaseName), PropertyAccessRenameParticipant.accessorName("set", newBaseName));
        return nameMap;
    }

    private static String accessorName(String prefix, String name) {
        return String.valueOf(prefix) + MetaClassHelper.capitalize((String)name);
    }

    private static String propertyName(String fullName) {
        int prefixLength = 0;
        if (fullName.startsWith("is")) {
            prefixLength = 2;
        } else if (fullName.startsWith("get") || fullName.startsWith("set")) {
            prefixLength = 3;
        }
        if (fullName.length() == prefixLength) {
            return fullName;
        }
        return Introspector.decapitalize(fullName.substring(prefixLength));
    }
}

