/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.extract;

import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.core.util.VisitCompleteException;

public class StaticExpressionChecker
extends CodeVisitorSupport {
    boolean maybeStatic = true;

    public boolean doVisit(Expression e) {
        try {
            e.visit((GroovyCodeVisitor)this);
        }
        catch (VisitCompleteException visitCompleteException) {
            // empty catch block
        }
        return this.maybeStatic;
    }

    public void visitFieldExpression(FieldExpression expression) {
        if (!expression.getField().isStatic()) {
            this.maybeStatic = false;
            throw new VisitCompleteException();
        }
        super.visitFieldExpression(expression);
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        if (!(call.getObjectExpression() instanceof ClassExpression)) {
            this.maybeStatic = false;
            throw new VisitCompleteException();
        }
        super.visitMethodCallExpression(call);
    }

    public void visitVariableExpression(VariableExpression expression) {
        Variable accessedVar = expression.getAccessedVariable();
        boolean notStatic = false;
        if (accessedVar instanceof Parameter || accessedVar instanceof VariableExpression) {
            notStatic = true;
        } else if (accessedVar instanceof FieldNode) {
            notStatic = !((FieldNode)accessedVar).isStatic();
        } else if (accessedVar instanceof PropertyNode) {
            boolean bl = notStatic = !((PropertyNode)accessedVar).isStatic();
        }
        if (notStatic) {
            this.maybeStatic = false;
            throw new VisitCompleteException();
        }
        super.visitVariableExpression(expression);
    }
}

