/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui;

import java.util.List;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovyMethodSuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.GroovySuggestionDeclaringType;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IGroovySuggestion;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.IValueCheckingRule;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.JavaValidTypeRule;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.MethodParameter;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.SuggestionDescriptor;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ValueStatus;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.AbstractDialogue;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ButtonDialogueControl;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ControlSelectionEvent;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ControlSelectionListener;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ControlTypes;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.DialogueDescriptor;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.DocumentDialogueControl;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IDialogueControlDescriptor;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.JavaTextControl;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.JavaTypeBrowsingControl;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.MethodParameterTable;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.RadioSelectionDialogueControl;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class AddInferencingSuggestionDialogue
extends AbstractDialogue {
    public static final DialogueDescriptor DIALOGUE_DESCRIPTOR = new DialogueDescriptor("Add a Groovy inferencing suggestion", "Inferencing Suggestion", "platform:/plugin/org.codehaus.groovy.eclipse/$nl$/groovy.png");
    private Point labelControlOffset;
    private boolean isStatic;
    private boolean isMethod = false;
    private String suggestionName;
    private String javaDoc;
    private String declaringTypeName;
    private String suggestionType;
    private boolean isActive;
    private List<MethodParameter> initialParameters;
    private IGroovySuggestion currentSuggestion;
    private boolean useNamedArguments;
    private MethodParameterTable table;
    private IProject project;

    public AddInferencingSuggestionDialogue(Shell parentShell, SuggestionDescriptor descriptor, IProject project) {
        super(parentShell);
        this.project = project;
        this.setSuggestion(descriptor);
    }

    public AddInferencingSuggestionDialogue(Shell parentShell, GroovySuggestionDeclaringType declaringType, IProject project) {
        this(parentShell, project, null, declaringType, true);
    }

    public AddInferencingSuggestionDialogue(Shell parentShell, IProject project) {
        this(parentShell, project, null, null, true);
    }

    protected AddInferencingSuggestionDialogue(Shell parentShell, IProject project, IGroovySuggestion currentSuggestion, GroovySuggestionDeclaringType declaringType, boolean isActive) {
        super(parentShell);
        this.project = project;
        this.currentSuggestion = currentSuggestion;
        this.declaringTypeName = declaringType != null ? declaringType.getName() : null;
        this.isActive = isActive;
    }

    @Override
    protected DialogueDescriptor getDialogueDescriptor() {
        return DIALOGUE_DESCRIPTOR;
    }

    public IGroovySuggestion getCurrentSuggestion() {
        return this.currentSuggestion;
    }

    public SuggestionDescriptor getSuggestionChange() {
        return this.isMethod ? new SuggestionDescriptor(this.declaringTypeName, this.isStatic, this.suggestionName, this.javaDoc, this.suggestionType, this.useNamedArguments, this.table.getMethodParameter(), this.isActive) : new SuggestionDescriptor(this.declaringTypeName, this.isStatic, this.suggestionName, this.javaDoc, this.suggestionType, this.isActive);
    }

    protected void setSuggestion(IGroovySuggestion suggestion) {
        this.currentSuggestion = suggestion;
        if (this.currentSuggestion != null) {
            this.isStatic = this.currentSuggestion.isStatic();
            this.suggestionName = this.currentSuggestion.getName();
            this.declaringTypeName = this.currentSuggestion.getDeclaringType().getName();
            this.javaDoc = this.currentSuggestion.getJavaDoc();
            this.suggestionType = this.currentSuggestion.getType();
            this.isActive = this.currentSuggestion.isActive();
            if (this.currentSuggestion instanceof GroovyMethodSuggestion) {
                GroovyMethodSuggestion method = (GroovyMethodSuggestion)this.currentSuggestion;
                this.initialParameters = method.getParameters();
                this.useNamedArguments = method.useNamedArguments();
                this.isMethod = true;
            }
        }
    }

    protected void setSuggestion(SuggestionDescriptor descriptor) {
        this.isStatic = descriptor.isStatic();
        this.suggestionName = descriptor.getName();
        this.declaringTypeName = descriptor.getDeclaringTypeName();
        this.javaDoc = descriptor.getJavaDoc();
        this.suggestionType = descriptor.getSuggestionType();
        this.isActive = descriptor.isActive();
        if (descriptor.isMethod()) {
            this.initialParameters = descriptor.getParameters();
            this.useNamedArguments = descriptor.isUseArgumentNames();
            this.isMethod = true;
        }
    }

    @Override
    protected void createCommandArea(Composite parent) {
        this.createFieldAreas(parent);
        this.createDocumentationArea(parent);
    }

    protected IJavaProject getJavaProject() {
        return this.project != null ? JavaCore.create((IProject)this.project) : null;
    }

    protected void createFieldAreas(Composite parent) {
        JavaTextControl nameControl = new JavaTextControl(ControlTypes.NAME, this.getOffsetLabelLocation(), this.suggestionName);
        nameControl.createControlArea(parent);
        nameControl.addSelectionListener(new AbstractDialogue.ValidatedValueSelectionListener(this, ControlTypes.NAME, this.suggestionName){

            @Override
            protected void handleValidatedValue(ControlSelectionEvent event) {
                Object selection = event.getSelectionData();
                if (selection instanceof String) {
                    AddInferencingSuggestionDialogue.this.suggestionName = (String)selection;
                }
            }
        });
        JavaTypeBrowsingControl declaringTypeControl = new JavaTypeBrowsingControl(ControlTypes.DECLARING_TYPE, this.getOffsetLabelLocation(), this.declaringTypeName, this.getJavaProject()){

            @Override
            protected IValueCheckingRule getCachedValidationRule() {
                return new JavaValidTypeRule(AddInferencingSuggestionDialogue.this.getJavaProject());
            }
        };
        declaringTypeControl.createControlArea(parent);
        declaringTypeControl.setEnabled(true);
        declaringTypeControl.addSelectionListener(new AbstractDialogue.ValidatedValueSelectionListener(this, ControlTypes.DECLARING_TYPE, this.declaringTypeName){

            @Override
            protected void handleValidatedValue(ControlSelectionEvent event) {
                Object selection = event.getSelectionData();
                if (selection instanceof String) {
                    AddInferencingSuggestionDialogue.this.declaringTypeName = (String)selection;
                }
            }
        });
        JavaTypeBrowsingControl suggestionTypeControl = new JavaTypeBrowsingControl(ControlTypes.TYPE, this.getOffsetLabelLocation(), this.suggestionType, this.getJavaProject()){

            @Override
            protected ValueStatus isControlValueValid(String value) {
                if (value == null || value.length() == 0) {
                    return ValueStatus.getValidStatus(value);
                }
                return super.isControlValueValid(value);
            }
        };
        suggestionTypeControl.createControlArea(parent);
        suggestionTypeControl.addSelectionListener(new AbstractDialogue.ValidatedValueSelectionListener(this){

            @Override
            protected void handleValidatedValue(ControlSelectionEvent event) {
                Object selection = event.getSelectionData();
                if (selection instanceof String) {
                    AddInferencingSuggestionDialogue.this.suggestionType = (String)selection;
                }
            }
        });
        ButtonDialogueControl isStaticButton = new ButtonDialogueControl(ControlTypes.IS_STATIC, 32, this.isStatic);
        isStaticButton.createControlArea(parent);
        isStaticButton.addSelectionListener(new ControlSelectionListener(){

            @Override
            public void handleSelection(ControlSelectionEvent event) {
                Object selection = event.getSelectionData();
                if (selection instanceof Boolean) {
                    AddInferencingSuggestionDialogue.this.isStatic = (Boolean)selection;
                }
            }
        });
        ControlTypes defaultSuggestionTypeButton = this.isMethod ? ControlTypes.METHOD : ControlTypes.PROPERTY;
        RadioSelectionDialogueControl radioSelection = new RadioSelectionDialogueControl(new IDialogueControlDescriptor[]{ControlTypes.PROPERTY, ControlTypes.METHOD}, defaultSuggestionTypeButton);
        radioSelection.createControlArea(parent);
        this.table = new MethodParameterTable(this.getJavaProject(), this.initialParameters, this.useNamedArguments);
        this.table.createControlArea(parent);
        if (!this.isMethod) {
            this.table.setEnabled(false);
        }
        this.table.addSelectionListener(new ControlSelectionListener(){

            @Override
            public void handleSelection(ControlSelectionEvent event) {
                Object selection = event.getSelectionData();
                if (event.getControlDescriptor() == ControlTypes.USE_NAMED_ARGUMENTS && selection instanceof Boolean) {
                    AddInferencingSuggestionDialogue.this.useNamedArguments = (Boolean)selection;
                }
            }
        });
        radioSelection.addSelectionListener(new ControlSelectionListener(){

            @Override
            public void handleSelection(ControlSelectionEvent event) {
                IDialogueControlDescriptor descriptor = event.getControlDescriptor();
                if (descriptor == ControlTypes.PROPERTY) {
                    AddInferencingSuggestionDialogue.this.table.setEnabled(false);
                    AddInferencingSuggestionDialogue.this.isMethod = false;
                } else if (descriptor == ControlTypes.METHOD) {
                    AddInferencingSuggestionDialogue.this.table.setEnabled(true);
                    AddInferencingSuggestionDialogue.this.isMethod = true;
                }
            }
        });
    }

    protected Point getOffsetLabelLocation() {
        if (this.labelControlOffset == null) {
            IDialogueControlDescriptor[] descriptors = new IDialogueControlDescriptor[]{ControlTypes.DECLARING_TYPE, ControlTypes.IS_STATIC, ControlTypes.TYPE, ControlTypes.NAME};
            String[] labelNames = new String[descriptors.length];
            int i = 0;
            while (i < descriptors.length) {
                labelNames[i] = descriptors[i].getLabel();
                ++i;
            }
            this.labelControlOffset = this.getOffsetLabelLocation(labelNames);
        }
        return this.labelControlOffset;
    }

    protected void createDocumentationArea(Composite parent) {
        DocumentDialogueControl docControl = new DocumentDialogueControl(ControlTypes.DOC, null, this.javaDoc);
        docControl.createControlArea(parent);
        docControl.addSelectionListener(new ControlSelectionListener(){

            @Override
            public void handleSelection(ControlSelectionEvent event) {
                if (event.getSelectionData() instanceof String) {
                    AddInferencingSuggestionDialogue.this.javaDoc = (String)event.getSelectionData();
                }
            }
        });
    }
}

