/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ControlSelectionEvent;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.DialogueDescriptor;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IControlSelectionListener;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IDialogueControlDescriptor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractDialogue
extends TitleAreaDialog {
    private Map<IDialogueControlDescriptor, SetValue> invalidValues;
    protected static final String EMPTY_ERROR_MESSAGE = "  ";

    public AbstractDialogue(Shell parentShell) {
        super(parentShell);
    }

    protected abstract @NonNull DialogueDescriptor getDialogueDescriptor();

    protected boolean isResizable() {
        return true;
    }

    protected String iconLocation() {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.invalidValues = new HashMap<IDialogueControlDescriptor, SetValue>();
        DialogueDescriptor descriptor = this.getDialogueDescriptor();
        this.setTitle(descriptor.getTitle());
        this.setMessage(descriptor.getMessage());
        String iconLocation = descriptor.getIconLocation();
        if (iconLocation != null && iconLocation.length() > 0) {
            this.setTitleImage(GroovyDSLCoreActivator.getImageDescriptor(iconLocation).createImage());
        }
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(this.getDefaultCompositeHMargin(), this.getDefaultCompositeVMargin()).spacing(this.convertHorizontalDLUsToPixels(4), this.convertVerticalDLUsToPixels(4)).applyTo(composite);
        Dialog.applyDialogFont((Control)composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        this.createCommandArea(composite);
        return composite;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (this.invalidValues != null) {
            for (SetValue setValue : this.invalidValues.values()) {
                if (setValue.getValue() != null) continue;
                this.enableOKButton(false);
            }
        }
        return control;
    }

    protected Point getOffsetLabelLocation(String[] labels) {
        int length = -1;
        int charLength = 0;
        String[] stringArray = labels;
        int n = labels.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            int nameLength = label.length();
            if (nameLength > charLength) {
                charLength = nameLength;
            }
            ++n2;
        }
        if (charLength > 0) {
            Shell control = this.getShell();
            GC gc = new GC((Drawable)control);
            Font requiredLabelFont = this.getRequiredParameterFont();
            gc.setFont(requiredLabelFont != null ? requiredLabelFont : control.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            length = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)charLength);
            gc.dispose();
        }
        Point longestLabelWidth = new Point(length, -1);
        longestLabelWidth.x += this.getLabelNameSeparatorOffset();
        return longestLabelWidth;
    }

    protected int getLabelNameSeparatorOffset() {
        return 5;
    }

    protected Font getRequiredParameterFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
    }

    protected int getDefaultCompositeVMargin() {
        return this.convertVerticalDLUsToPixels(7);
    }

    protected int getDefaultCompositeHMargin() {
        return this.convertHorizontalDLUsToPixels(7);
    }

    protected abstract void createCommandArea(Composite var1);

    protected void notifyValidValueSet(IDialogueControlDescriptor descriptor, Object value) {
        this.invalidValues.remove(descriptor);
        if (this.invalidValues != null) {
            for (Map.Entry<IDialogueControlDescriptor, SetValue> entry : this.invalidValues.entrySet()) {
                if (entry.getValue().getValue() != null) continue;
                this.displayInvalidValueError(entry.getKey(), entry.getValue().getErrorMessage(), true);
                return;
            }
        }
        this.setErrorMessage(null);
        this.enableOKButton(true);
    }

    protected void displayInvalidValueError(IDialogueControlDescriptor descriptor, String errorMessage, boolean displayErrorMessage) {
        StringBuffer missingFields = new StringBuffer();
        missingFields.append("Value (");
        missingFields.append(descriptor.getLabel());
        missingFields.append(')');
        if (errorMessage != null && errorMessage.length() > 0) {
            missingFields.append(':');
            missingFields.append(' ');
            missingFields.append(errorMessage);
        } else {
            missingFields.append(" is missing");
        }
        if (displayErrorMessage) {
            this.setErrorMessage(missingFields.toString());
        }
        this.enableOKButton(false);
    }

    protected void enableOKButton(boolean enable) {
        Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(enable);
        }
    }

    protected class SetValue {
        private Object value;
        private String errorMessage;

        public SetValue(Object value, String errorMessage) {
            this.value = value;
            this.errorMessage = errorMessage;
        }

        public Object getValue() {
            return this.value;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    protected abstract class ValidatedValueSelectionListener
    implements IControlSelectionListener {
        public ValidatedValueSelectionListener() {
        }

        public ValidatedValueSelectionListener(IDialogueControlDescriptor descriptor, Object initialValue) {
            if (descriptor != null) {
                AbstractDialogue.this.invalidValues.put(descriptor, new SetValue(initialValue, null));
            }
        }

        @Override
        public void handleSelection(ControlSelectionEvent event) {
            this.handleValidatedValue(event);
            AbstractDialogue.this.notifyValidValueSet(event.getControlDescriptor(), event.getSelectionData());
        }

        @Override
        public void handleInvalidSelection(ControlSelectionEvent event) {
            IDialogueControlDescriptor descriptor = event.getControlDescriptor();
            AbstractDialogue.this.invalidValues.put(descriptor, new SetValue(event.getSelectionData(), event.getErrorMessage()));
            AbstractDialogue.this.displayInvalidValueError(descriptor, event.getErrorMessage(), true);
        }

        protected abstract void handleValidatedValue(ControlSelectionEvent var1);
    }
}

