/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ValueStatus;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.ControlSelectionEvent;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IControlSelectionListener;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IDialogueControlDescriptor;
import org.codehaus.groovy.eclipse.dsl.inferencing.suggestions.ui.IDialogueControlManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractControlManager
implements IDialogueControlManager {
    private IControlSelectionListener listener;
    private Map<Control, IDialogueControlDescriptor> controls;
    private Shell shell;

    protected ValueStatus isControlValueValid(Control control) {
        return null;
    }

    protected void notifyControlChange(Object value, Control control) {
        if (this.listener != null && this.handleInvalidCheck(control)) {
            IDialogueControlDescriptor descriptor = this.controls.get(control);
            ControlSelectionEvent event = new ControlSelectionEvent(value, descriptor);
            this.listener.handleSelection(event);
        }
    }

    protected boolean handleInvalidCheck(Control control) {
        ValueStatus status;
        if (control != null && (status = this.isControlValueValid(control)) != null && status.isError()) {
            IDialogueControlDescriptor descriptor = this.controls.get(control);
            ControlSelectionEvent event = new ControlSelectionEvent(descriptor, status.getMessage());
            this.listener.handleInvalidSelection(event);
            return false;
        }
        return true;
    }

    @Override
    public Composite createControlArea(Composite parent) {
        this.controls = new HashMap<Control, IDialogueControlDescriptor>();
        Map<Control, IDialogueControlDescriptor> createdControls = this.createManagedControls(parent);
        if (createdControls != null) {
            this.controls.putAll(createdControls);
        }
        this.shell = parent.getShell();
        return parent;
    }

    protected Shell getShell() {
        return this.shell;
    }

    @Override
    public void setEnabled(boolean enable) {
        if (this.controls != null) {
            for (Control control : this.controls.keySet()) {
                if (control.isDisposed()) continue;
                control.setEnabled(enable);
            }
        }
    }

    @Override
    public void addSelectionListener(IControlSelectionListener listener) {
        this.listener = listener;
    }

    protected abstract Map<Control, IDialogueControlDescriptor> createManagedControls(Composite var1);
}

