/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.contributions;

import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.codehaus.groovy.eclipse.dsl.contributions.DSLContributionGroup;
import org.codehaus.groovy.eclipse.dsl.lookup.ResolverCache;

public class ParameterContribution {
    final String name;
    final String type;
    private Parameter value;

    public ParameterContribution(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public ParameterContribution(Parameter value) {
        this.value = value;
        this.name = value.getName();
        this.type = DSLContributionGroup.getTypeName(value.getType());
    }

    public Parameter toParameter(ResolverCache resolver) {
        if (this.value == null) {
            if (this.type.indexOf(64) >= 0) {
                try {
                    List nodes = new AstBuilder().buildFromString(CompilePhase.CANONICALIZATION, false, "import groovy.transform.stc.*\nvoid meth(" + this.type + " " + this.name + ") {}");
                    MethodNode meth = (MethodNode)((ClassNode)nodes.get(1)).getMethods("meth").get(0);
                    return meth.getParameters()[0];
                }
                catch (Exception e) {
                    GroovyDSLCoreActivator.logException(e);
                }
            }
            this.value = new Parameter(resolver != null ? resolver.resolve(this.type) : ClassHelper.DYNAMIC_TYPE, this.name);
        }
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.type) + " " + this.name;
    }
}

