/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.fragments;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentFactory;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.EmptyASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.FragmentVisitor;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.selection.IsSameExpression;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;

public class SimpleExpressionASTFragment
implements IASTFragment {
    private final Expression expression;
    private int actualStartPosition;

    SimpleExpressionASTFragment(Expression expression) {
        this.expression = expression;
        this.actualStartPosition = expression.getStart();
    }

    @Override
    public Expression getAssociatedExpression() {
        return this.expression;
    }

    @Override
    public ASTNode getAssociatedNode() {
        return this.expression;
    }

    void setActualStartPosition(int actualStartPosition) {
        this.actualStartPosition = actualStartPosition;
    }

    @Override
    public int getEnd() {
        return this.expression.getEnd();
    }

    @Override
    public int getStart() {
        return this.actualStartPosition;
    }

    @Override
    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    @Override
    public int getTrimmedEnd(GroovyCompilationUnit unit) {
        char[] contents = unit.getContents();
        int end = Math.min(this.getEnd(), contents.length - 1);
        while (end > this.actualStartPosition && Character.isWhitespace(contents[end])) {
            --end;
        }
        return end;
    }

    @Override
    public int getTrimmedLength(GroovyCompilationUnit unit) {
        return this.getTrimmedEnd(unit) - this.getStart();
    }

    @Override
    public boolean matches(IASTFragment other) {
        if (!(other instanceof SimpleExpressionASTFragment)) {
            return false;
        }
        return new IsSameExpression().isSame(this.expression, other.getAssociatedExpression());
    }

    public String toString() {
        return this.print(0);
    }

    @Override
    public String print(int indentLvl) {
        return String.valueOf(ASTFragmentFactory.spaces(indentLvl)) + "(S) " + this.expression.toString();
    }

    @Override
    public int fragmentLength() {
        return 1;
    }

    @Override
    public void accept(FragmentVisitor visitor) {
        visitor.previsit(this);
        visitor.visit(this);
    }

    @Override
    public ASTFragmentKind kind() {
        return ASTFragmentKind.SIMPLE_EXPRESSION;
    }

    @Override
    public IASTFragment findMatchingSubFragment(IASTFragment other) {
        if (other.kind() == ASTFragmentKind.SIMPLE_EXPRESSION && new IsSameExpression().isSame(this.getAssociatedExpression(), other.getAssociatedExpression())) {
            return new SimpleExpressionASTFragment(this.expression);
        }
        return new EmptyASTFragment();
    }
}

