/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.fragments;

import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentFactory;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.EmptyASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.FragmentVisitor;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.selection.IsSameExpression;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;

public class MethodCallFragment
implements IASTFragment {
    protected MethodCallExpression callExpression;
    private final Expression methodExpression;
    private final Expression arguments;
    private final IASTFragment next;
    private final int actualEndPosition;

    MethodCallFragment(Expression methodExpression, Expression arguments, IASTFragment next, int actualEndPosition) {
        this.methodExpression = methodExpression;
        this.arguments = arguments;
        this.next = next;
        this.actualEndPosition = actualEndPosition;
    }

    public MethodCallFragment(Expression methodExpression, Expression arguments, int actualEndPosition) {
        this(methodExpression, arguments, null, actualEndPosition);
    }

    @Override
    public ASTFragmentKind kind() {
        return ASTFragmentKind.METHOD_CALL;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public IASTFragment getNext() {
        return this.next;
    }

    @Override
    public int getStart() {
        return this.getAssociatedExpression().getStart();
    }

    @Override
    public int getEnd() {
        return this.hasNext() ? this.getNext().getEnd() : this.actualEndPosition;
    }

    @Override
    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    @Override
    public int getTrimmedEnd(GroovyCompilationUnit unit) {
        if (this.hasNext()) {
            return this.getNext().getTrimmedEnd(unit);
        }
        char[] contents = unit.getContents();
        int end = Math.min(this.actualEndPosition, contents.length - 1);
        while (end > this.getStart() && Character.isWhitespace(contents[end])) {
            --end;
        }
        return end;
    }

    @Override
    public int getTrimmedLength(GroovyCompilationUnit unit) {
        return this.getTrimmedEnd(unit) - this.getStart();
    }

    public MethodCallExpression getAssociatedNode() {
        return this.callExpression;
    }

    @Override
    public Expression getAssociatedExpression() {
        return this.methodExpression;
    }

    public Expression getArguments() {
        return this.arguments;
    }

    @Override
    public int fragmentLength() {
        return this.hasNext() ? 1 + this.getNext().fragmentLength() : 1;
    }

    @Override
    public void accept(FragmentVisitor visitor) {
        if (visitor.previsit(this) && visitor.visit(this) && this.hasNext()) {
            this.getNext().accept(visitor);
        }
    }

    @Override
    public String print(int indentLvl) {
        return String.valueOf(ASTFragmentFactory.spaces(indentLvl)) + "(M) " + this.getAssociatedExpression() + '.' + this.getArguments() + (this.hasNext() ? String.valueOf('\n') + this.getNext().print(indentLvl + 1) : "");
    }

    @Override
    public IASTFragment findMatchingSubFragment(IASTFragment that) {
        if (that.kind() == this.kind() && that.fragmentLength() <= this.fragmentLength() && this.similar((MethodCallFragment)that)) {
            IASTFragment frag = ((MethodCallFragment)that).next;
            if (frag == null) {
                return new MethodCallFragment(this.getAssociatedExpression(), this.getArguments(), this.actualEndPosition);
            }
            if ((frag = this.next.findMatchingSubFragment(frag)).kind() != ASTFragmentKind.EMPTY) {
                return new MethodCallFragment(this.getAssociatedExpression(), this.getArguments(), frag, this.actualEndPosition);
            }
        }
        return new EmptyASTFragment();
    }

    @Override
    public boolean matches(IASTFragment that) {
        if (that instanceof MethodCallFragment && ((MethodCallFragment)that).hasNext() == this.hasNext()) {
            return this.similar((MethodCallFragment)that);
        }
        return false;
    }

    protected boolean similar(MethodCallFragment that) {
        return new IsSameExpression().isSame(this.getAssociatedExpression(), that.getAssociatedExpression()) && new IsSameExpression().isSame(this.getArguments(), that.getArguments());
    }
}

