/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.proposals;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.completions.GroovyJavaFieldCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.AbstractGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.viewers.StyledString;

public class GroovyPropertyProposal
extends AbstractGroovyProposal {
    private final PropertyNode property;
    private final String contributor;

    public GroovyPropertyProposal(PropertyNode property) {
        this.property = property;
        this.contributor = "Groovy";
    }

    public GroovyPropertyProposal(PropertyNode property, String contributor) {
        this.property = property;
        this.contributor = contributor;
    }

    @Override
    public IJavaCompletionProposal createJavaProposal(ContentAssistContext context, JavaContentAssistInvocationContext javaContext) {
        if (context.location == ContentAssistLocation.METHOD_CONTEXT) {
            return null;
        }
        CompletionProposal proposal = this.createProposal(context);
        return new GroovyJavaFieldCompletionProposal(proposal, this.createDisplayString(this.property), javaContext);
    }

    protected StyledString createDisplayString(PropertyNode property) {
        StyledString ss = new StyledString();
        ss.append(property.getName()).append(" : ").append(ProposalUtils.createSimpleTypeName(property.getType())).append(" - ").append(ProposalUtils.createSimpleTypeName(property.getDeclaringClass()), StyledString.QUALIFIER_STYLER).append(" (" + this.contributor + ")", StyledString.DECORATIONS_STYLER);
        return ss;
    }

    private CompletionProposal createProposal(ContentAssistContext context) {
        InternalCompletionProposal proposal = (InternalCompletionProposal)CompletionProposal.create((int)2, (int)context.completionLocation);
        proposal.setFlags(this.property.getModifiers() | (GroovyUtils.isDeprecated((ASTNode)this.property) ? 0x100000 : 0));
        proposal.setName(this.property.getName().toCharArray());
        proposal.setCompletion(proposal.getName());
        proposal.setSignature(ProposalUtils.createTypeSignature(this.property.getType()));
        proposal.setDeclarationSignature(ProposalUtils.createTypeSignature(this.property.getDeclaringClass()));
        proposal.setRelevance(this.computeRelevance(context));
        int startIndex = context.completionLocation - context.completionExpression.length();
        proposal.setReplaceRange(startIndex, context.completionEnd);
        return proposal;
    }
}

