/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;

public class ModifiersCompletionProcessor
extends AbstractGroovyCompletionProcessor {
    private static final String[] CLASS_MEMBER_KEYWORDS = new String[]{"abstract", "def", "final", "native", "private", "protected", "public", "static", "synchronized", "transient", "void", "volatile"};

    public ModifiersCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        String completionExpression = this.getContext().completionExpression;
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String[] stringArray = CLASS_MEMBER_KEYWORDS;
        int n = CLASS_MEMBER_KEYWORDS.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (keyword.startsWith(completionExpression)) {
                proposals.add(this.createProposal(keyword, completionExpression, this.getContext().completionLocation));
            }
            ++n2;
        }
        return proposals;
    }

    protected ICompletionProposal createProposal(String keyword, String completionExpression, int completionLocation) {
        int length = completionExpression.length();
        int offset = completionLocation - length;
        int relevance = Relevance.LOWEST.getRelevance(5.0f);
        StyledString displayString = Strings.markJavaElementLabelLTR((StyledString)new StyledString(keyword));
        return new JavaCompletionProposal(keyword, offset, length, null, displayString, relevance);
    }
}

