/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.beans.Introspector;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.completions.GroovyJavaMethodCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyImportRewriteFactory;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyNamedArgumentProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.ProposalFormattingOptions;
import org.codehaus.groovy.eclipse.codeassist.relevance.IRelevanceRule;
import org.codehaus.groovy.eclipse.codeassist.relevance.Relevance;
import org.codehaus.groovy.eclipse.codeassist.relevance.internal.CompositeRule;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.codeassist.requestor.MethodInfoContentAssistContext;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.groovy.core.util.CharArraySequence;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.AccessorSupport;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.codeassist.impl.AssistOptions;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.nd.util.CharArrayMap;
import org.eclipse.jdt.internal.corext.util.TypeFilter;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class GroovyProposalTypeSearchRequestor
implements ISearchRequestor {
    private static final char[] NO_TYPE_NAME = new char[]{'.'};
    private static final char[] EMPTY_PARENS = new char[]{'(', ')'};
    private static final char[] _AS_ = new char[]{' ', 'a', 's', ' '};
    private static final int CHECK_CANCEL_FREQUENCY = 50;
    private static final Pattern CLOSURE_INNER_TYPE = Pattern.compile("_closure\\d+$");
    private int foundTypesCount;
    private int foundConstructorsCount;
    private ObjectVector acceptedTypes;
    private CharArrayMap<?> acceptedPackages;
    private ObjectVector acceptedConstructors;
    private char[][][] imports;
    private char[][] onDemandImports;
    private final int offset;
    private final boolean isImport;
    private final NameLookup nameLookup;
    private final IProgressMonitor monitor;
    private final String completionExpression;
    private final ModuleNode module;
    private final GroovyCompilationUnit unit;
    private GroovyImportRewriteFactory groovyRewriter;
    private ProposalFormattingOptions groovyProposalPrefs;
    private final JavaContentAssistInvocationContext javaContext;
    private IRelevanceRule relevanceRule;
    private CompletionEngine mockEngine;
    private IType[] allTypesInUnit;
    private boolean contextOnly;
    final ContentAssistContext context;
    final AssistOptions options;

    public GroovyProposalTypeSearchRequestor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, int exprStart, int replaceLength, NameLookup nameLookup, IProgressMonitor monitor) {
        this.context = context;
        this.javaContext = javaContext;
        Assert.isNotNull((Object)javaContext.getCoreContext());
        this.offset = exprStart;
        this.nameLookup = nameLookup;
        this.monitor = monitor;
        this.unit = context.unit;
        this.module = context.unit.getModuleNode();
        this.isImport = context.location == ContentAssistLocation.IMPORT;
        this.contextOnly = context.location == ContentAssistLocation.METHOD_CONTEXT;
        this.completionExpression = this.contextOnly ? context.getPerceivedCompletionExpression().replace('$', '.') : context.getQualifiedCompletionExpression();
        this.groovyRewriter = new GroovyImportRewriteFactory(this.unit, this.module);
        this.options = new AssistOptions(javaContext.getProject().getOptions(true));
        try {
            this.allTypesInUnit = this.unit.getAllTypes();
        }
        catch (JavaModelException e) {
            GroovyContentAssist.logError(e);
            this.allTypesInUnit = new IType[0];
        }
    }

    public void acceptModule(char[] moduleName) {
    }

    public void acceptPackage(char[] packageName) {
        this.checkCancel();
        if (TypeFilter.isFiltered((char[])packageName, (char[])NO_TYPE_NAME)) {
            return;
        }
        if (this.acceptedPackages == null) {
            this.acceptedPackages = new CharArrayMap();
        }
        this.acceptedPackages.put(packageName, null);
    }

    public void acceptType(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, int modifiers, AccessRestriction accessRestriction) {
        if (this.foundTypesCount % 50 == 0) {
            this.checkCancel();
        }
        ++this.foundTypesCount;
        if (CharOperation.contains((char)'$', (char[])simpleTypeName) || DefaultGroovyMethods.asBoolean((Object[])enclosingTypeNames) && CLOSURE_INNER_TYPE.matcher((CharSequence)new CharArraySequence(simpleTypeName)).find()) {
            return;
        }
        if (this.context.location == ContentAssistLocation.EXTENDS && Flags.isFinal((int)modifiers)) {
            return;
        }
        if (this.options.checkDeprecation && Flags.isDeprecated((int)modifiers)) {
            return;
        }
        if (this.options.checkVisibility && !Flags.isPublic((int)modifiers)) {
            if (Flags.isPrivate((int)modifiers)) {
                return;
            }
            if (!CharOperation.equals((char[])packageName, (char[])CharOperation.concatWith((char[][])this.unit.getPackageName(), (char)'.'))) {
                return;
            }
        }
        if (TypeFilter.isFiltered((char[])packageName, (char[])CharOperation.concatWith((char[][])enclosingTypeNames, (char[])simpleTypeName, (char)'.'))) {
            return;
        }
        int accessibility = 0;
        if (accessRestriction != null) {
            switch (accessRestriction.getProblemId()) {
                case 0x1000118: {
                    if (this.options.checkDiscouragedReference) {
                        return;
                    }
                    accessibility = 2;
                    break;
                }
                case 0x1000133: {
                    if (this.options.checkForbiddenReference) {
                        return;
                    }
                    accessibility = 1;
                }
            }
        }
        if (this.acceptedTypes == null) {
            this.acceptedTypes = new ObjectVector();
        }
        this.acceptedTypes.add((Object)new AcceptedType(packageName, simpleTypeName, enclosingTypeNames, modifiers, accessibility));
    }

    public void acceptConstructor(int modifiers, char[] simpleTypeName, int parameterCount, char[] signature, char[][] parameterTypes, char[][] parameterNames, int typeModifiers, char[] packageName, int extraFlags, String path, AccessRestriction accessRestriction) {
        boolean isThisCall;
        int accessibility;
        block22: {
            String typeName;
            if (this.foundConstructorsCount % 50 == 0) {
                this.checkCancel();
            }
            ++this.foundConstructorsCount;
            if (Flags.isEnum((int)typeModifiers) || Flags.isInterface((int)typeModifiers) || Flags.isAnnotation((int)typeModifiers)) {
                return;
            }
            if (this.options.checkDeprecation && (Flags.isDeprecated((int)modifiers) || Flags.isDeprecated((int)typeModifiers))) {
                return;
            }
            if (this.options.checkVisibility && !Flags.isPublic((int)typeModifiers)) {
                if (Flags.isPrivate((int)typeModifiers)) {
                    return;
                }
                if (!CharOperation.equals((char[])packageName, (char[])CharOperation.concatWith((char[][])this.unit.getPackageName(), (char)'.'))) {
                    return;
                }
            }
            if (TypeFilter.isFiltered((char[])packageName, (char[])simpleTypeName)) {
                return;
            }
            accessibility = 0;
            if (accessRestriction != null) {
                switch (accessRestriction.getProblemId()) {
                    case 0x1000118: {
                        if (this.options.checkDiscouragedReference) {
                            return;
                        }
                        accessibility = 2;
                        break;
                    }
                    case 0x1000133: {
                        if (this.options.checkForbiddenReference) {
                            return;
                        }
                        accessibility = 1;
                    }
                }
            }
            if (!(CharOperation.contains((char)'$', (char[])simpleTypeName) || path.lastIndexOf(typeName = String.valueOf(simpleTypeName)) >= 0 && path.matches(".+\\b" + Pattern.quote(typeName) + "(?:\\.\\w+)?"))) {
                try {
                    IJavaElement el;
                    IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
                    if (r == null || (el = (IJavaElement)r.getAdapter(IJavaElement.class)) == null || el.getElementType() != 5) break block22;
                    ICompilationUnit cu = (ICompilationUnit)el;
                    IType[] iTypeArray = cu.getAllTypes();
                    int n = iTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType type = iTypeArray[n2];
                        if (type.getElementName().equals(typeName)) {
                            if (type.isMember()) {
                                simpleTypeName = type.getTypeQualifiedName().toCharArray();
                            }
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    GroovyContentAssist.logError(e);
                }
            }
        }
        boolean bl = isThisCall = this.context.completionNode instanceof ConstructorCallExpression && ((ConstructorCallExpression)this.context.completionNode).isThisCall() || this.context.location == ContentAssistLocation.STATEMENT && this.context.completionNode instanceof VariableExpression && "this".startsWith(this.context.completionExpression);
        if (isThisCall && this.context.containingDeclaration.getDeclaringClass().getDeclaredConstructors().stream().filter(ctor -> ctor.getOriginal() == this.context.containingDeclaration).anyMatch(ctor -> {
            Parameter[] parameters = ctor.getParameters();
            if (parameters.length == parameterCount) {
                if (parameterCount == 0) {
                    return true;
                }
                if (parameterTypes != null) {
                    int i = 0;
                    while (i < parameterCount) {
                        char[] parameterType = this.resolveImportAlias(parameterTypes[i]);
                        if (!(CharOperation.equals((char[])parameterType, (char[])GroovyProposalTypeSearchRequestor.toChars(parameters[i].getType(), ClassNode::getName)) || CharOperation.equals((char[])parameterNames[i], (char[])parameters[i].getName().toCharArray()) && (CharOperation.indexOf((char)'.', (char[])parameterType) < 0 || parameters[i].getType().getOuterClass() != null) && CharOperation.equals((char[])parameterType, (char[])GroovyProposalTypeSearchRequestor.toChars(parameters[i].getType(), ClassNode::getNameWithoutPackage)))) {
                            return false;
                        }
                        ++i;
                    }
                    return true;
                }
            }
            return false;
        })) {
            return;
        }
        if (this.acceptedConstructors == null) {
            this.acceptedConstructors = new ObjectVector();
        }
        this.acceptedConstructors.add((Object)new AcceptedCtor(modifiers, simpleTypeName, parameterCount, signature, parameterTypes, parameterNames, typeModifiers, packageName, extraFlags, accessibility));
    }

    private void checkCancel() {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    List<ICompletionProposal> processAcceptedPackages() {
        this.checkCancel();
        if (this.acceptedPackages == null) {
            return Collections.emptyList();
        }
        return this.acceptedPackages.keys().stream().map(packageName -> {
            GroovyCompletionProposal proposal = this.createProposal(8, this.context.completionLocation);
            proposal.setDeclarationSignature((char[])packageName);
            proposal.setPackageName((char[])packageName);
            proposal.setCompletion((char[])packageName);
            proposal.setReplaceRange(this.offset, this.context.completionLocation);
            proposal.setTokenRange(this.offset, this.context.completionLocation);
            proposal.setRelevance(Relevance.LOWEST.getRelevance());
            return proposal;
        }).map(proposal -> {
            LazyJavaCompletionProposal javaProposal = new LazyJavaCompletionProposal((CompletionProposal)proposal, this.javaContext);
            javaProposal.setTriggerCharacters(ProposalUtils.TYPE_TRIGGERS);
            javaProposal.setRelevance(proposal.getRelevance());
            return javaProposal;
        }).collect(Collectors.toCollection(() -> new LinkedList()));
    }

    List<ICompletionProposal> processAcceptedTypes(JDTResolver resolver) {
        int n;
        this.checkCancel();
        if (this.acceptedTypes == null || (n = this.acceptedTypes.size()) == 0) {
            return Collections.emptyList();
        }
        this.initializeRelevanceRule(resolver);
        LinkedList<ICompletionProposal> proposals = new LinkedList<ICompletionProposal>();
        boolean qualified = this.completionExpression.indexOf(46) > 0;
        try {
            int i = 0;
            while (i < n) {
                block17: {
                    if (i % 50 == 0) {
                        this.checkCancel();
                    }
                    AcceptedType type = (AcceptedType)this.acceptedTypes.elementAt(i);
                    char[] packageName = type.packageName;
                    char[] simpleTypeName = type.simpleTypeName;
                    char[][] enclosingTypeNames = type.enclosingTypeNames;
                    type.qualifiedTypeName = enclosingTypeNames == null || enclosingTypeNames.length == 0 ? simpleTypeName : CharOperation.concatWith((char[][])type.enclosingTypeNames, (char[])simpleTypeName, (char)'$');
                    type.fullyQualifiedName = CharOperation.concat((char[])packageName, (char[])type.qualifiedTypeName, (char)'.');
                    if (this.isImport) {
                        proposals.add(this.proposeType(type));
                    } else {
                        if (this.imports == null && resolver.getScope() != null) {
                            this.initializeImportArrays(resolver.getScope());
                        }
                        if (!qualified) {
                            int n2;
                            int n3;
                            Object object;
                            if (this.imports != null) {
                                char[] fullName = CharOperation.replaceOnCopy((char[])type.fullyQualifiedName, (char)'$', (char)'.');
                                object = this.imports;
                                n3 = this.imports.length;
                                n2 = 0;
                                while (n2 < n3) {
                                    char[][] importSpec = object[n2];
                                    if (CharOperation.equals((char[])simpleTypeName, (char[])importSpec[0])) {
                                        int end = CharOperation.indexOf((char[])_AS_, (char[])importSpec[1], (boolean)true);
                                        type.mustBeQualified = !CharOperation.equals((char[])fullName, (char[])importSpec[1], (int)0, (int)(end > 0 ? end : importSpec[1].length));
                                        proposals.add(this.proposeType(type));
                                        break block17;
                                    }
                                    ++n2;
                                }
                            }
                            if (this.onDemandImports != null) {
                                char[] qualifier = enclosingTypeNames != null && enclosingTypeNames.length > 0 ? CharOperation.concatWith((char[])packageName, (char[][])type.enclosingTypeNames, (char)'.') : packageName;
                                type.mustBeQualified = Stream.of(this.onDemandImports).noneMatch(importName -> CharOperation.equals((char[])qualifier, (char[])importName));
                                if (!type.mustBeQualified) {
                                    object = this.onDemandImports;
                                    n3 = this.onDemandImports.length;
                                    n2 = 0;
                                    while (n2 < n3) {
                                        char[] candidate;
                                        ClassNode result;
                                        char[][] importName2 = object[n2];
                                        if (!CharOperation.equals((char[])qualifier, (char[])importName2) && !VariableScope.OBJECT_CLASS_NODE.equals((Object)(result = resolver.resolve(String.valueOf(candidate = CharOperation.concat((char[])importName2, (char[])simpleTypeName, (char)'.')))))) {
                                            type.mustBeQualified = true;
                                            break;
                                        }
                                        ++n2;
                                    }
                                }
                            }
                        }
                        proposals.add(this.proposeType(type));
                    }
                }
                ++i;
            }
        }
        finally {
            this.acceptedTypes = null;
            this.relevanceRule = null;
        }
        return proposals;
    }

    private ICompletionProposal proposeType(AcceptedType type) {
        LazyJavaTypeCompletionProposal javaProposal;
        int completionOffset = this.isImport || type.mustBeQualified ? this.offset : this.context.completionLocation - this.context.getPerceivedCompletionExpression().length();
        GroovyCompletionProposal proposal = this.createProposal(9, completionOffset);
        proposal.setAccessibility(type.accessibility);
        proposal.setCompletion(!type.mustBeQualified ? type.simpleTypeName : CharOperation.replaceOnCopy((char[])type.fullyQualifiedName, (char)'$', (char)'.'));
        proposal.setDeclarationSignature(type.packageName);
        proposal.setFlags(type.modifiers);
        proposal.setPackageName(type.packageName);
        proposal.setRelevance(this.computeRelevanceForTypeProposal(type.fullyQualifiedName, type.accessibility, type.modifiers));
        proposal.setReplaceRange(completionOffset, this.context.completionLocation);
        proposal.setSignature(Signature.createCharArrayTypeSignature((char[])type.fullyQualifiedName, (boolean)true));
        proposal.setTokenRange(completionOffset, this.context.completionEnd);
        proposal.setTypeName(type.qualifiedTypeName);
        if (type.qualifiedTypeName.length != type.simpleTypeName.length) {
            char[] outerTypeName = CharOperation.subarray((char[])type.qualifiedTypeName, (int)0, (int)(type.qualifiedTypeName.length - type.simpleTypeName.length - 1));
            proposal.setDeclarationSignature(Signature.createCharArrayTypeSignature((char[])CharOperation.concat((char[])type.packageName, (char[])outerTypeName, (char)'.'), (boolean)true));
            proposal.setDeclarationPackageName(type.packageName);
            proposal.setDeclarationTypeName(outerTypeName);
        }
        if (this.isImport) {
            String fullyQualifiedName = String.valueOf(type.fullyQualifiedName).replace('$', '.');
            javaProposal = new JavaTypeCompletionProposal(fullyQualifiedName, null, completionOffset, this.context.completionLocation - completionOffset, ProposalUtils.getImage((CompletionProposal)proposal), ProposalUtils.createDisplayString((CompletionProposal)proposal), proposal.getRelevance(), fullyQualifiedName, this.javaContext);
        } else {
            javaProposal = new LazyJavaTypeCompletionProposal((CompletionProposal)proposal, this.javaContext);
            if (type.qualifiedTypeName.length != type.simpleTypeName.length) {
                char[] typeName;
                char[][] parts;
                int lastDotIndex = this.context.fullCompletionExpression.lastIndexOf(46);
                if (lastDotIndex > 0 && !this.completionExpression.startsWith(String.valueOf(String.valueOf(GroovyProposalTypeSearchRequestor.firstSegment(type.packageName, '.'))) + '.') && !this.isImported((parts = GroovyProposalTypeSearchRequestor.qualifierAndSimpleTypeName(type.packageName, typeName = CharOperation.subarray((char[])type.qualifiedTypeName, (int)0, (int)CharOperation.lastIndexOf((char)'$', (char[])type.qualifiedTypeName))))[0], parts[1])) {
                    GroovyCompletionProposal typeProposal = this.createProposal(9, this.offset);
                    typeProposal.setCompletion(CharOperation.concat((char[])type.packageName, (char[])typeName, (char)'.'));
                    typeProposal.setSignature(Signature.createCharArrayTypeSignature((char[])typeProposal.getCompletion(), (boolean)true));
                    typeProposal.setReplaceRange(this.offset, this.context.completionLocation - (this.context.fullCompletionExpression.length() - lastDotIndex));
                    proposal.setRequiredProposals(new CompletionProposal[]{typeProposal});
                }
                if (lastDotIndex > 0) {
                    proposal.setRelevance(Relevance.MEDIUM.getRelevance());
                }
            }
            if (this.context.location == ContentAssistLocation.EXCEPTIONS && this.isThrowableType((IType)javaProposal.getJavaElement())) {
                proposal.setRelevance(proposal.getRelevance() + 50);
            }
        }
        javaProposal.setTriggerCharacters(ProposalUtils.TYPE_TRIGGERS);
        javaProposal.setRelevance(proposal.getRelevance());
        return javaProposal;
    }

    List<ICompletionProposal> processAcceptedConstructors(Set<String> usedParams, JDTResolver resolver) {
        int n;
        this.checkCancel();
        if (this.acceptedConstructors == null || (n = this.acceptedConstructors.size()) == 0) {
            return Collections.emptyList();
        }
        LinkedList<ICompletionProposal> proposals = new LinkedList<ICompletionProposal>();
        try {
            int i = 0;
            while (i < n) {
                ICompletionProposal constructorProposal;
                if (i % 50 == 0) {
                    this.checkCancel();
                }
                AcceptedCtor ctor = (AcceptedCtor)this.acceptedConstructors.elementAt(i);
                if (this.imports == null && resolver.getScope() != null) {
                    this.initializeImportArrays(resolver.getScope());
                }
                if ((constructorProposal = this.proposeConstructor(ctor)) != null) {
                    ConstructorNode constructor;
                    Parameter[] parameters;
                    List constructors;
                    ClassNode resolved;
                    proposals.add(constructorProposal);
                    if (this.contextOnly && !((ConstructorCallExpression)this.context.completionNode).isSpecialCall() && (resolved = resolver.resolve(String.valueOf(ctor.fullyQualifiedName))) != null && (constructors = resolved.getDeclaredConstructors()) != null && constructors.size() == 1 && ((parameters = (constructor = (ConstructorNode)constructors.get(0)).getParameters()) == null || parameters.length == 0)) {
                        GroovyNamedArgumentProposal namedArgument;
                        String name;
                        proposals.remove(constructorProposal);
                        for (PropertyNode prop : GeneralUtils.getAllProperties((ClassNode)resolved)) {
                            name = prop.getName();
                            if ("metaClass".equals(name) || usedParams.contains(name) || !ProposalUtils.matches(this.context.completionExpression, name, this.options.camelCaseMatch, this.options.substringMatch)) continue;
                            namedArgument = new GroovyNamedArgumentProposal(name, prop.getType(), null, String.valueOf(ctor.simpleTypeName));
                            proposals.add((ICompletionProposal)namedArgument.createJavaProposal(this.context, this.javaContext));
                        }
                        for (MethodNode meth : resolved.getMethods()) {
                            if (meth.isStatic() || !AccessorSupport.isSetter((MethodNode)meth) || "metaClass".equals(name = Introspector.decapitalize(meth.getName().substring(3))) || usedParams.contains(name) || !GeneralUtils.getAllProperties((ClassNode)resolved).stream().noneMatch(p -> p.getName().equals(name)) || !ProposalUtils.matches(this.context.completionExpression, name, this.options.camelCaseMatch, this.options.substringMatch)) continue;
                            namedArgument = new GroovyNamedArgumentProposal(name, meth.getParameters()[0].getType(), null, String.valueOf(ctor.simpleTypeName));
                            proposals.add((ICompletionProposal)namedArgument.createJavaProposal(this.context, this.javaContext));
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            this.acceptedTypes = null;
            this.relevanceRule = null;
        }
        return proposals;
    }

    private ICompletionProposal proposeConstructor(AcceptedCtor ctor) {
        char[] proposalName = ctor.simpleTypeName;
        char[] completionExpressionChars = this.completionExpression.toCharArray();
        int completionOffset = this.offset;
        int kind = 26;
        if (this.contextOnly) {
            if (!CharOperation.equals((char[])ctor.simpleTypeName, (char[])CharOperation.lastSegment((char[])completionExpressionChars, (char)'.'))) {
                return null;
            }
            kind = 6;
            completionOffset = ((MethodInfoContentAssistContext)this.context).methodNameEnd;
        } else if (this.context.location == ContentAssistLocation.STATEMENT) {
            if ("this".startsWith(this.completionExpression)) {
                proposalName = "this".toCharArray();
            } else if ("super".startsWith(this.completionExpression)) {
                proposalName = "super".toCharArray();
            }
        }
        GroovyCompletionProposal proposal = this.createProposal(kind, completionOffset);
        proposal.setIsContructor(true);
        proposal.setName(proposalName);
        proposal.setPackageName(ctor.packageName);
        proposal.setTypeName(ctor.qualifiedTypeName);
        proposal.setDeclarationPackageName(ctor.packageName);
        proposal.setDeclarationTypeName(ctor.qualifiedTypeName);
        proposal.setDeclarationSignature(CompletionEngine.createNonGenericTypeSignature((char[])ctor.packageName, (char[])ctor.qualifiedTypeName));
        proposal.setFlags(Flags.isDeprecated((int)ctor.typeModifiers) ? ctor.modifiers | 0x100000 : ctor.modifiers);
        proposal.setAccessibility(ctor.accessibility);
        if (this.contextOnly) {
            proposal.setCompletion(CharOperation.NO_CHAR);
            proposal.setReplaceRange(this.context.completionLocation, this.context.completionLocation);
        } else {
            if (this.context.isParenAfter(this.javaContext.getDocument())) {
                proposal.setCompletion(CharOperation.NO_CHAR);
            } else {
                proposal.setCompletion(EMPTY_PARENS);
            }
            proposal.setTokenRange(this.offset, this.context.completionEnd);
            proposal.setReplaceRange(this.context.completionEnd, this.context.completionEnd);
            GroovyCompletionProposal typeProposal = this.createProposal(9, -1);
            typeProposal.setName(proposal.getName());
            typeProposal.setPackageName(ctor.packageName);
            typeProposal.setTypeName(ctor.qualifiedTypeName);
            typeProposal.setSignature(proposal.getDeclarationSignature());
            typeProposal.setCompletion(typeProposal.getName());
            typeProposal.setReplaceRange(this.context.completionLocation - CharOperation.lastSegment((char[])completionExpressionChars, (char)'.').length, this.context.completionEnd);
            proposal.setRequiredProposals(new CompletionProposal[]{typeProposal});
            int lastDotIndex = this.context.fullCompletionExpression.lastIndexOf(46);
            if (lastDotIndex > 0 && ctor.qualifiedTypeName.length != ctor.simpleTypeName.length) {
                char[] outerTypeName = CharOperation.subarray((char[])ctor.qualifiedTypeName, (int)0, (int)CharOperation.lastIndexOf((char)'$', (char[])ctor.qualifiedTypeName));
                char[] plainTypeName = CharOperation.lastSegment((char[])outerTypeName, (char)'$');
                GroovyCompletionProposal outerTypeProposal = this.createProposal(9, -1);
                outerTypeProposal.setName(plainTypeName);
                outerTypeProposal.setTypeName(outerTypeName);
                outerTypeProposal.setPackageName(ctor.packageName);
                outerTypeProposal.setSignature(CompletionEngine.createNonGenericTypeSignature((char[])ctor.packageName, (char[])outerTypeName));
                int idx = this.context.fullCompletionExpression.lastIndexOf(String.valueOf(plainTypeName), lastDotIndex);
                int loc = this.context.completionLocation - (this.context.fullCompletionExpression.length() - idx);
                outerTypeProposal.setReplaceRange(loc, loc + outerTypeProposal.getName().length);
                outerTypeProposal.setCompletion(outerTypeProposal.getName());
                typeProposal.setRequiredProposals(new CompletionProposal[]{outerTypeProposal});
                if (CharOperation.equals((char[])plainTypeName, (char[])completionExpressionChars, (int)0, (int)plainTypeName.length) && !this.isImported(GroovyProposalTypeSearchRequestor.qualifierAndSimpleTypeName(ctor.packageName, outerTypeName)[0], plainTypeName)) {
                    outerTypeProposal.setCompletion(Signature.toCharArray((char[])outerTypeProposal.getSignature()));
                }
            } else if (lastDotIndex < 0 && this.context.location != ContentAssistLocation.STATEMENT && !this.isImported(GroovyProposalTypeSearchRequestor.qualifierAndSimpleTypeName(ctor.packageName, ctor.qualifiedTypeName)[0], ctor.simpleTypeName)) {
                typeProposal.setCompletion(Signature.toCharArray((char[])typeProposal.getSignature()));
            }
        }
        this.populateParameterInfo(proposal, ctor.parameterCount, ctor.parameterNames, ctor.parameterTypes, ctor.signature);
        float relevanceMultiplier = ctor.accessibility == 0 ? 3 : 0;
        proposal.setRelevance(Relevance.MEDIUM_HIGH.getRelevance(relevanceMultiplier += (float)this.computeRelevanceForCaseMatching(completionExpressionChars, ctor.simpleTypeName)));
        GroovyJavaMethodCompletionProposal lazyProposal = new GroovyJavaMethodCompletionProposal((CompletionProposal)proposal, this.getProposalOptions(), this.javaContext, null);
        lazyProposal.setImportRewite(this.groovyRewriter.getImportRewrite(this.monitor));
        return lazyProposal;
    }

    private void populateParameterInfo(GroovyCompletionProposal proposal, int parameterCount, char[][] parameterNames, char[][] parameterTypes, char[] signature) {
        if (parameterCount == -1) {
            parameterNames = CharOperation.NO_CHAR_CHAR;
            parameterTypes = CharOperation.NO_CHAR_CHAR;
        } else {
            int parameterNamesLength;
            int n = parameterNamesLength = parameterNames == null ? 0 : parameterNames.length;
            if (parameterCount != parameterNamesLength) {
                parameterNames = null;
            }
        }
        if (signature == null) {
            proposal.setSignature(this.createConstructorSignature((char[][])parameterTypes, true));
        } else {
            proposal.setSignature(CharOperation.replaceOnCopy((char[])signature, (char)'/', (char)'.'));
        }
        if (parameterNames != null) {
            proposal.setParameterNames(parameterNames);
        } else {
            proposal.setHasNoParameterNamesFromIndex(true);
            if (this.mockEngine == null) {
                this.mockEngine = new CompletionEngine(null, new CompletionRequestor(){

                    public void accept(CompletionProposal proposal) {
                    }
                }, null, this.javaContext.getProject(), null, null);
            }
            proposal.setCompletionEngine(this.mockEngine);
        }
        if (parameterTypes == null) {
            parameterTypes = new char[parameterCount][];
            int i = 0;
            while (i < parameterCount) {
                parameterTypes[i] = "def".toCharArray();
                ++i;
            }
        }
        proposal.setParameterTypeNames((char[][])parameterTypes);
    }

    private char[] createConstructorSignature(char[][] parameterTypes, boolean isQualified) {
        Object parameterTypeSigs;
        if (parameterTypes == null) {
            parameterTypeSigs = CharOperation.NO_CHAR_CHAR;
        } else {
            parameterTypeSigs = new char[parameterTypes.length][];
            int i = 0;
            while (i < parameterTypes.length) {
                char[] copy = new char[parameterTypes[i].length];
                System.arraycopy(parameterTypes[i], 0, copy, 0, copy.length);
                CharOperation.replace((char[])copy, (char)'/', (char)'.');
                parameterTypeSigs[i] = Signature.createCharArrayTypeSignature((char[])copy, (boolean)isQualified);
                ++i;
            }
        }
        return Signature.createMethodSignature((char[][])parameterTypeSigs, (char[])new char[]{'V'});
    }

    protected final GroovyCompletionProposal createProposal(int kind, int completionOffset) {
        GroovyCompletionProposal proposal = new GroovyCompletionProposal(kind, completionOffset);
        proposal.setNameLookup(this.nameLookup);
        return proposal;
    }

    private ProposalFormattingOptions getProposalOptions() {
        if (this.groovyProposalPrefs == null) {
            this.groovyProposalPrefs = ProposalFormattingOptions.newFromOptions();
        }
        return this.groovyProposalPrefs;
    }

    private boolean isThrowableType(IType type) {
        try {
            if (type != null && type.isClass() && type.newSupertypeHierarchy(null).contains(this.unit.getJavaProject().findType("java.lang.Throwable"))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private int computeRelevanceForCaseMatching(char[] token, char[] proposalName) {
        if (CharOperation.equals((char[])token, (char[])proposalName, (boolean)true)) {
            return 14;
        }
        if (CharOperation.equals((char[])token, (char[])proposalName, (boolean)false)) {
            return 4;
        }
        return 0;
    }

    private int computeRelevanceForTypeProposal(char[] fullyQualifiedName, int accessibility, int modifiers) {
        IRelevanceRule rule = Optional.ofNullable(this.relevanceRule).orElse(IRelevanceRule.DEFAULT);
        return rule.getRelevance(fullyQualifiedName, this.allTypesInUnit, accessibility, modifiers);
    }

    private void initializeRelevanceRule(JDTResolver resolver) {
        ClassNode lhsType;
        if (this.context.lhsNode instanceof Variable && VariableScope.CLASS_CLASS_NODE.equals((Object)(lhsType = ((Variable)this.context.lhsNode).getType())) && lhsType.isUsingGenerics()) {
            GenericsType target = lhsType.getGenericsTypes()[0];
            if (target.getLowerBound() == null && target.getUpperBounds() == null || target.getUpperBounds().length == 1 && VariableScope.OBJECT_CLASS_NODE.equals((Object)target.getUpperBounds()[0])) {
                return;
            }
            IRelevanceRule rule = (fullyQualifiedName, contextTypes, accessibility, modifiers) -> {
                try {
                    ClassNode sourceType = resolver.resolve(String.valueOf(fullyQualifiedName));
                    if (target.isCompatibleWith(sourceType)) {
                        return 10;
                    }
                }
                catch (RuntimeException e) {
                    if (GroovyLogManager.manager.hasLoggers()) {
                        GroovyLogManager.manager.log(TraceCategory.CONTENT_ASSIST, e.getMessage());
                    }
                    System.err.println(String.valueOf(this.getClass().getSimpleName()) + ": " + e.getMessage());
                }
                return 0;
            };
            this.relevanceRule = CompositeRule.of(1.0, IRelevanceRule.DEFAULT, 2.0, rule);
        }
    }

    private void initializeImportArrays(GroovyCompilationUnitScope scope) {
        int n = scope.imports != null ? scope.imports.length : 0;
        int i = 0;
        int s = 0;
        int t = 0;
        while (i < n) {
            if (!scope.imports[i].isStatic()) {
                if (scope.imports[i].onDemand) {
                    ++s;
                } else {
                    ++t;
                }
            }
            ++i;
        }
        Object starImports = new char[++s][];
        char[][][] typeImports = new char[t][][];
        i = 0;
        s = 0;
        t = 0;
        while (i < n) {
            if (!scope.imports[i].isStatic()) {
                if (scope.imports[i].onDemand) {
                    starImports[s++] = GroovyProposalTypeSearchRequestor.getImportName(scope.imports[i]);
                } else {
                    typeImports[t++] = new char[][]{GroovyProposalTypeSearchRequestor.getSimpleName(scope.imports[i]), GroovyProposalTypeSearchRequestor.getImportName(scope.imports[i])};
                }
            }
            ++i;
        }
        starImports[s++] = CharOperation.concatWith((char[][])scope.currentPackageName, (char)'.');
        ClassNode enclosingType = this.context.getEnclosingGroovyType();
        while (enclosingType != null) {
            if (!GroovyUtils.isAnonymous((ClassNode)enclosingType)) {
                char[] typeName = enclosingType.getName().replace('$', '.').toCharArray();
                starImports = (char[][])ArrayUtils.add((Object[])starImports, (int)s, (Object)typeName);
            }
            enclosingType = enclosingType.getOuterClass();
        }
        this.imports = typeImports;
        this.onDemandImports = starImports;
    }

    private boolean isImported(char[] packName, char[] typeName) {
        int n;
        int n2;
        Object object;
        boolean imported = false;
        boolean conflict = false;
        if (this.imports != null) {
            object = this.imports;
            n2 = this.imports.length;
            n = 0;
            while (n < n2) {
                char[][] importSpec = object[n];
                if (CharOperation.equals((char[])typeName, (char[])importSpec[0])) {
                    if (CharOperation.equals((char[])packName, (char[])importSpec[1], (int)0, (int)CharOperation.lastIndexOf((char)'.', (char[])importSpec[1]))) {
                        imported = true;
                        break;
                    }
                    conflict = true;
                    break;
                }
                ++n;
            }
        }
        if (!imported && !conflict && this.onDemandImports != null) {
            object = this.onDemandImports;
            n2 = this.onDemandImports.length;
            n = 0;
            while (n < n2) {
                char[][] importName = object[n];
                if (CharOperation.equals((char[])packName, (char[])importName)) {
                    imported = true;
                    break;
                }
                ++n;
            }
        }
        return imported;
    }

    private static char[] getImportName(ImportBinding binding) {
        if (binding.reference != null) {
            return CharOperation.concatWith((char[][])binding.reference.getImportName(), (char)'.');
        }
        return CharOperation.concatWith((char[][])binding.compoundName, (char)'.');
    }

    private static char[] getSimpleName(ImportBinding binding) {
        if (binding.reference != null) {
            return binding.reference.getSimpleName();
        }
        return binding.compoundName[binding.compoundName.length - 1];
    }

    private static char[] firstSegment(char[] arr, char sep) {
        int pos = CharOperation.indexOf((char)sep, (char[])arr);
        if (pos < 0) {
            return arr;
        }
        return CharOperation.subarray((char[])arr, (int)0, (int)pos);
    }

    private char[] resolveImportAlias(char[] typeName) {
        String maybeAlias = String.valueOf(GroovyProposalTypeSearchRequestor.firstSegment(typeName, '.'));
        Predicate<String> equalsMaybeAlias = maybeAlias::equals;
        return Optional.ofNullable(this.module.getImport(maybeAlias)).map(importNode -> importNode.getType().getNameWithoutPackage()).filter(equalsMaybeAlias.negate()).map(resolved -> {
            char[] chars = new char[resolved.length() + (typeName.length - maybeAlias.length())];
            resolved.getChars(0, resolved.length(), chars, 0);
            System.arraycopy(typeName, maybeAlias.length(), chars, resolved.length(), typeName.length - maybeAlias.length());
            return chars;
        }).orElse(typeName);
    }

    private static char[][] qualifierAndSimpleTypeName(char[] packName, char[] typeName) {
        int pos = CharOperation.lastIndexOf((char)'$', (char[])typeName);
        if (pos > 0) {
            char[] typeQual = CharOperation.subarray((char[])typeName, (int)0, (int)pos);
            typeName = CharOperation.subarray((char[])typeName, (int)(pos + 1), (int)typeName.length);
            packName = CharOperation.concat((char[])packName, (char[])CharOperation.replaceOnCopy((char[])typeQual, (char)'$', (char)'.'), (char)'.');
        }
        return new char[][]{packName, typeName};
    }

    private static char[] toChars(ClassNode type, Function<ClassNode, String> toString) {
        int dims = 0;
        while (type.isArray()) {
            ++dims;
            type = type.getComponentType();
        }
        String string = toString.apply(type);
        char[] chars = new char[string.length() + dims * 2];
        string.getChars(0, string.length(), chars, 0);
        CharOperation.replace((char[])chars, (char)'$', (char)'.');
        while (dims > 0) {
            int i = chars.length - dims * 2;
            chars[i + 1] = 93;
            chars[i] = 91;
            --dims;
        }
        return chars;
    }

    private static class AcceptedCtor {
        public int modifiers;
        public char[] simpleTypeName;
        public int parameterCount;
        public char[] signature;
        public char[][] parameterTypes;
        public char[][] parameterNames;
        public int typeModifiers;
        public char[] packageName;
        public int accessibility;
        public final char[] qualifiedTypeName;
        public final char[] fullyQualifiedName;

        AcceptedCtor(int modifiers, char[] simpleTypeName, int parameterCount, char[] signature, char[][] parameterTypes, char[][] parameterNames, int typeModifiers, char[] packageName, int extraFlags, int accessibility) {
            this.modifiers = modifiers;
            this.simpleTypeName = CharOperation.lastSegment((char[])simpleTypeName, (char)'$');
            this.parameterCount = parameterCount;
            this.signature = signature;
            this.parameterTypes = parameterTypes;
            this.parameterNames = parameterNames;
            this.typeModifiers = typeModifiers;
            this.packageName = packageName;
            this.accessibility = accessibility;
            this.qualifiedTypeName = simpleTypeName;
            this.fullyQualifiedName = CharOperation.concat((char[])packageName, (char[])this.qualifiedTypeName, (char)'.');
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('{');
            buffer.append(this.fullyQualifiedName);
            buffer.append('}');
            return buffer.toString();
        }
    }

    private static class AcceptedType {
        public char[] packageName;
        public char[] simpleTypeName;
        public char[][] enclosingTypeNames;
        public int modifiers;
        public int accessibility;
        public boolean mustBeQualified;
        public char[] fullyQualifiedName;
        public char[] qualifiedTypeName;

        AcceptedType(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, int modifiers, int accessibility) {
            this.packageName = packageName;
            this.simpleTypeName = simpleTypeName;
            this.enclosingTypeNames = enclosingTypeNames;
            this.modifiers = modifiers;
            this.accessibility = accessibility;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('{');
            if (this.fullyQualifiedName != null) {
                buffer.append(this.fullyQualifiedName);
            } else {
                buffer.append(this.packageName).append('.');
                buffer.append(CharOperation.concatWith((char[][])this.enclosingTypeNames, (char[])this.simpleTypeName, (char)'$'));
            }
            buffer.append('}');
            return buffer.toString();
        }
    }
}

