/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.groovy.core.util.CharArraySequence;
import org.eclipse.jdt.groovy.core.util.JavaConstants;
import org.eclipse.jdt.ui.CodeStyleConfiguration;

public class GroovyImportRewriteFactory {
    private static final Pattern IMPORTS_PATTERN = Pattern.compile("(\\A|[\\n\\r])import\\s");
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("(\\A|[\\n\\r])package\\s");
    private static final Pattern EOL_PATTERN = Pattern.compile("($|[\\n\\r])");
    private ImportRewrite rewrite;
    private boolean cantCreateRewrite = false;
    private GroovyCompilationUnit unit;
    private ModuleNode module;

    public GroovyImportRewriteFactory(GroovyCompilationUnit unit, ModuleNode module) {
        this.unit = unit;
        this.module = module;
    }

    public GroovyImportRewriteFactory(GroovyCompilationUnit unit) {
        this.unit = unit;
    }

    public ImportRewrite getImportRewrite(IProgressMonitor monitor) {
        if (this.module != null && !this.module.encounteredUnrecoverableError()) {
            return null;
        }
        if (this.rewrite == null && !this.cantCreateRewrite) {
            CharSequence imports = GroovyImportRewriteFactory.findImportsRegion((CharSequence)new CharArraySequence(this.unit.getContents()));
            ASTParser parser = ASTParser.newParser((int)JavaConstants.AST_LEVEL);
            parser.setSource((ICompilationUnit)this.unit.cloneCachingContents(new StringBuilder(imports).append("class X { }").toString().toCharArray()));
            parser.setKind(8);
            ASTNode result = null;
            try {
                result = parser.createAST(monitor);
            }
            catch (IllegalStateException e) {
                GroovyContentAssist.logError("Can't create ImportRewrite for:\n" + imports, e);
            }
            if (result instanceof CompilationUnit) {
                this.rewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)((CompilationUnit)result), (boolean)true);
            } else {
                this.cantCreateRewrite = true;
            }
        }
        return this.rewrite;
    }

    public static CharSequence findImportsRegion(CharSequence contents) {
        Matcher matcher = IMPORTS_PATTERN.matcher(contents);
        int importsEnd = 0;
        while (matcher.find(importsEnd)) {
            importsEnd = matcher.end();
        }
        if (importsEnd == 0 && (matcher = PACKAGE_PATTERN.matcher(contents)).find()) {
            importsEnd = matcher.end();
        }
        if (importsEnd > 0 && (matcher = EOL_PATTERN.matcher(contents)).find(importsEnd)) {
            importsEnd = matcher.end();
        }
        return contents.subSequence(0, importsEnd);
    }
}

