/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.processors;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.processors.AbstractGroovyCompletionProcessor;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyProposalTypeSearchRequestor;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistLocation;
import org.codehaus.groovy.eclipse.codeassist.requestor.MethodInfoContentAssistContext;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.search.ITypeResolver;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class ConstructorCompletionProcessor
extends AbstractGroovyCompletionProcessor
implements ITypeResolver {
    protected ModuleNode module;
    protected JDTResolver resolver;

    public ConstructorCompletionProcessor(ContentAssistContext context, JavaContentAssistInvocationContext javaContext, SearchableEnvironment nameEnvironment) {
        super(context, javaContext, nameEnvironment);
    }

    public void setResolverInformation(ModuleNode module, JDTResolver resolver) {
        this.module = module;
        this.resolver = resolver;
    }

    @Override
    public List<ICompletionProposal> generateProposals(IProgressMonitor monitor) {
        char[] completionChars;
        ContentAssistContext context = this.getContext();
        switch (context.location) {
            case CONSTRUCTOR: {
                context.extend(this.getJavaContext().getCoreContext(), null);
                completionChars = context.getQualifiedCompletionExpression().toCharArray();
                break;
            }
            case STATEMENT: {
                context = ConstructorCompletionProcessor.findCtorCallContext(context);
                if (context == null) {
                    return Collections.emptyList();
                }
                if (context == this.getContext()) {
                    String typeName;
                    if ("this".startsWith(context.completionExpression)) {
                        typeName = context.getEnclosingGroovyType().getName();
                    } else {
                        assert ("super".startsWith(context.completionExpression));
                        typeName = context.getEnclosingGroovyType().getSuperClass().getName();
                    }
                    completionChars = typeName.replace('$', '.').toCharArray();
                    break;
                }
            }
            case METHOD_CONTEXT: {
                completionChars = context.getPerceivedCompletionNode().getText().replace('$', '.').toCharArray();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid constructor completion location: " + context.location.name());
            }
        }
        int replacementStart = this.getReplacementStartOffset();
        SearchableEnvironment environment = this.getNameEnvironment();
        GroovyProposalTypeSearchRequestor requestor = new GroovyProposalTypeSearchRequestor(context, this.getJavaContext(), replacementStart, -1, environment.nameLookup, monitor);
        int lastDotIndex = CharOperation.lastIndexOf((char)'.', (char[])completionChars);
        if (lastDotIndex < 0 || environment.nameLookup.isPackage(CharOperation.toStrings((char[][])CharOperation.splitOn((char)'.', (char[])completionChars, (int)0, (int)lastDotIndex)))) {
            environment.findConstructorDeclarations(completionChars, requestor.options.camelCaseMatch, (ISearchRequestor)requestor, monitor);
        } else {
            String qualifier = String.valueOf(completionChars, 0, lastDotIndex);
            String pattern = String.valueOf(completionChars, lastDotIndex + 1, completionChars.length - lastDotIndex - 1);
            Consumer<IType> checker = outerType -> {
                if (outerType != null && outerType.exists() && qualifier.endsWith(outerType.getElementName())) {
                    try {
                        IType[] iTypeArray = outerType.getTypes();
                        int n = iTypeArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType innerType = iTypeArray[n2];
                            if (ProposalUtils.matches(pattern, innerType.getElementName(), groovyProposalTypeSearchRequestor.options.camelCaseMatch, groovyProposalTypeSearchRequestor.options.substringMatch)) {
                                int extraFlags = 0;
                                boolean hasConstructor = false;
                                IMethod[] iMethodArray = innerType.getMethods();
                                int n3 = iMethodArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IMethod m = iMethodArray[n4];
                                    boolean bl = hasConstructor = hasConstructor || m.isConstructor();
                                    if (m.isConstructor() && !Flags.isStatic((int)m.getFlags()) && !Flags.isSynthetic((int)m.getFlags())) {
                                        char[][] parameterNames = CharOperation.toCharArrays(Arrays.asList(m.getParameterNames()));
                                        char[][] parameterTypes = null;
                                        requestor.acceptConstructor(m.getFlags(), innerType.getTypeQualifiedName().toCharArray(), m.getNumberOfParameters(), m.getSignature().toCharArray(), parameterTypes, parameterNames, innerType.getFlags(), innerType.getPackageFragment().getElementName().toCharArray(), extraFlags, innerType.getPath().toString(), ProposalUtils.getTypeAccessibility(innerType));
                                    }
                                    ++n4;
                                }
                                if (!hasConstructor) {
                                    requestor.acceptConstructor(1, innerType.getTypeQualifiedName().toCharArray(), -1, null, CharOperation.NO_CHAR_CHAR, CharOperation.NO_CHAR_CHAR, innerType.getFlags(), innerType.getPackageFragment().getElementName().toCharArray(), extraFlags, innerType.getPath().toString(), ProposalUtils.getTypeAccessibility(innerType));
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (JavaModelException e) {
                        GroovyContentAssist.logError(e);
                    }
                }
            };
            ClassNode outerTypeNode = this.resolver.resolve(qualifier);
            if (!ClassHelper.DYNAMIC_TYPE.equals((Object)outerTypeNode)) {
                checker.accept(environment.nameLookup.findType(outerTypeNode.getName(), false, 0));
            } else if (qualifier.indexOf(46) < 0) {
                environment.findTypes(qualifier.toCharArray(), true, false, 0, (ISearchRequestor)requestor, monitor);
                List<ICompletionProposal> proposals = requestor.processAcceptedTypes(this.resolver);
                for (ICompletionProposal proposal : proposals) {
                    if (!(proposal instanceof AbstractJavaCompletionProposal)) continue;
                    checker.accept((IType)((AbstractJavaCompletionProposal)proposal).getJavaElement());
                }
            }
        }
        return requestor.processAcceptedConstructors(ConstructorCompletionProcessor.findUsedParameters(context), this.resolver);
    }

    protected static ContentAssistContext findCtorCallContext(final ContentAssistContext context) {
        Statement code;
        if (context.containingDeclaration instanceof ConstructorNode && context.completionNode instanceof VariableExpression && !context.completionExpression.isEmpty() && ("this".startsWith(context.completionExpression) || "super".startsWith(context.completionExpression)) && (code = ((ConstructorNode)context.containingDeclaration).getCode()) instanceof BlockStatement) {
            for (Statement stmt : ((BlockStatement)code).getStatements()) {
                if (stmt.getStart() <= 0) continue;
                if (!(stmt instanceof ExpressionStatement) || ((ExpressionStatement)stmt).getExpression() != context.completionNode) break;
                return context;
            }
        }
        if (context.completionNode instanceof VariableExpression || context.completionNode instanceof ConstantExpression) {
            ASTNode containingCode = context.containingCodeBlock;
            if (containingCode instanceof MethodNode) {
                containingCode = ((MethodNode)containingCode).getCode();
            } else if (containingCode instanceof Variable) {
                containingCode = ((Variable)containingCode).getInitialExpression();
            } else if (containingCode instanceof AnnotationNode) {
                containingCode = null;
            }
            final ConstructorCallExpression[] enclosingCall = new ConstructorCallExpression[1];
            if (containingCode != null) {
                containingCode.visit((GroovyCodeVisitor)new CodeVisitorSupport(){

                    public void visitConstructorCallExpression(ConstructorCallExpression call) {
                        if (context.completionLocation > call.getNameStart() && context.completionLocation < call.getEnd()) {
                            Expression args = call.getArguments();
                            if (args instanceof TupleExpression) {
                                for (Expression expr : ((TupleExpression)args).getExpressions()) {
                                    if (expr == context.completionNode) {
                                        enclosingCall[0] = call;
                                        return;
                                    }
                                    if (!(expr instanceof NamedArgumentListExpression)) continue;
                                    args = expr;
                                }
                            }
                            if (args instanceof NamedArgumentListExpression) {
                                for (MapEntryExpression entry : ((NamedArgumentListExpression)args).getMapEntryExpressions()) {
                                    if (entry.getKeyExpression() != context.completionNode) continue;
                                    enclosingCall[0] = call;
                                    return;
                                }
                            }
                        }
                        super.visitConstructorCallExpression(call);
                    }
                });
            }
            if (enclosingCall[0] != null) {
                ConstructorCallExpression call = enclosingCall[0];
                ClassNode type = call.getType();
                if (call.isUsingAnonymousInnerClass() && (type = call.getType().getUnresolvedSuperClass(false)) == ClassHelper.OBJECT_TYPE) {
                    type = call.getType().getUnresolvedInterfaces(false)[0];
                }
                return new MethodInfoContentAssistContext(context.completionLocation, context.completionExpression, context.fullCompletionExpression, (ASTNode)call, context.containingCodeBlock, context.lhsNode, context.unit, context.containingDeclaration, context.completionEnd, (AnnotatedNode)type, type.getNameWithoutPackage(), call.getNameEnd() + 1);
            }
        }
        return null;
    }

    protected static Set<String> findUsedParameters(ContentAssistContext context) {
        Set<String> usedParams = Collections.emptySet();
        if (context.location == ContentAssistLocation.METHOD_CONTEXT && context.completionNode instanceof ConstructorCallExpression) {
            ConstructorCallExpression call = (ConstructorCallExpression)context.completionNode;
            Expression args = call.getArguments();
            if (args instanceof TupleExpression) {
                for (Expression expr : ((TupleExpression)args).getExpressions()) {
                    if (!(expr instanceof NamedArgumentListExpression)) continue;
                    args = expr;
                    break;
                }
            }
            if (args instanceof NamedArgumentListExpression) {
                usedParams = new HashSet<String>();
                for (MapEntryExpression entry : ((NamedArgumentListExpression)args).getMapEntryExpressions()) {
                    usedParams.add(entry.getKeyExpression().getText());
                }
            }
        }
        return usedParams;
    }
}

