/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.creators;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.creators.AbstractProposalCreator;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyFieldProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.GroovyMethodProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.IGroovyProposal;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.transform.trait.Traits;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MemberProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;

public class MethodProposalCreator
extends AbstractProposalCreator {
    private Set<ClassNode> alreadySeen = new HashSet<ClassNode>();

    @Override
    public List<IGroovyProposal> findAllProposals(ClassNode type, Set<ClassNode> categories, String prefix, boolean isStatic, boolean isPrimary) {
        ClassNode enclosingTypeDeclaration;
        LinkedList<IGroovyProposal> proposals = new LinkedList<IGroovyProposal>();
        HashSet<String> alreadySeenFields = new HashSet<String>();
        if (isStatic) {
            alreadySeenFields.add("class");
        }
        boolean firstTime = this.alreadySeen.isEmpty();
        boolean isMapType = GeneralUtils.isOrImplements((ClassNode)type, (ClassNode)VariableScope.MAP_CLASS_NODE);
        for (MethodNode method : this.getAllMethods(type, this.alreadySeen)) {
            String methodName = method.getName();
            String[] traitAndMethodNames = Traits.decomposeSuperCallName((String)methodName);
            if (traitAndMethodNames != null) {
                methodName = traitAndMethodNames[1];
            }
            if (isStatic && !method.isStatic() && !method.getDeclaringClass().equals((Object)VariableScope.OBJECT_CLASS_NODE)) continue;
            if (this.matcher.test(prefix, methodName) && !"<clinit>".equals(methodName)) {
                GroovyMethodProposal proposal = traitAndMethodNames != null ? new TraitSuperMethodProposal(method, traitAndMethodNames) : new GroovyMethodProposal(method);
                MethodProposalCreator.setRelevanceMultiplier(proposal, isStatic);
                proposals.add(proposal);
            }
            if ("getClass".equals(methodName) || isMapType && !isStatic || !this.findLooselyMatchedAccessorKind(prefix, methodName, false).isAccessorKind(method, false)) continue;
            if (traitAndMethodNames != null) {
                proposals.add(new TraitSuperPropertyProposal(method, traitAndMethodNames));
                continue;
            }
            FieldNode mockField = MethodProposalCreator.createMockField(method);
            if (!alreadySeenFields.add(mockField.getName())) continue;
            ClassNode declaringClass = method.getDeclaringClass();
            FieldNode realField = declaringClass.getField(mockField.getName());
            if (realField == null) {
                realField = declaringClass.getField(ProposalUtils.createCapitalMockFieldName(methodName));
            }
            if (realField != null && !MethodProposalCreator.leftIsMoreAccessible(mockField, realField)) continue;
            proposals.add(new GroovyFieldProposal(mockField));
        }
        if (this.currentScope != null && (enclosingTypeDeclaration = this.currentScope.getEnclosingTypeDeclaration()) != null && firstTime && isPrimary && type.getModule() != null) {
            this.findStaticImportProposals(proposals, prefix, type.getModule());
            this.findStaticFavoriteProposals(proposals, prefix, type.getModule());
            MethodProposalCreator.demoteLowVisibilityProposals(proposals, type);
        }
        Iterator it = proposals.iterator();
        while (it.hasNext()) {
            IGroovyProposal proposal = (IGroovyProposal)it.next();
            if (proposal instanceof GroovyMethodProposal) {
                if (!GroovyUtils.isSynthetic((MethodNode)((GroovyMethodProposal)proposal).getMethod())) continue;
                it.remove();
                continue;
            }
            if (!(proposal instanceof GroovyFieldProposal) || !GroovyUtils.isSynthetic((FieldNode)((GroovyFieldProposal)proposal).getField())) continue;
            it.remove();
        }
        return proposals;
    }

    private void findStaticImportProposals(List<IGroovyProposal> proposals, String prefix, ModuleNode module) {
        for (Map.Entry entry : module.getStaticStarImports().entrySet()) {
            ClassNode typeNode = ((ImportNode)entry.getValue()).getType();
            if (typeNode == null) continue;
            for (MethodNode method : this.getAllMethods(typeNode, this.alreadySeen)) {
                if (!method.isStatic() || !this.matcher.test(prefix, method.getName())) continue;
                GroovyMethodProposal proposal = new GroovyMethodProposal(method);
                proposal.setRelevanceMultiplier(0.95f);
                proposals.add(proposal);
            }
        }
        for (Map.Entry entry : module.getStaticImports().entrySet()) {
            String fieldName = ((ImportNode)entry.getValue()).getFieldName();
            if (!this.matcher.test(prefix, fieldName)) continue;
            ClassNode typeNode = ((ImportNode)entry.getValue()).getType();
            for (MethodNode method : this.getAllMethods(typeNode, new HashSet<ClassNode>(this.alreadySeen))) {
                if (!method.isStatic() || !method.getName().equals(fieldName)) continue;
                GroovyMethodProposal proposal = new GroovyMethodProposal(method);
                proposal.setRelevanceMultiplier(0.95f);
                proposals.add(proposal);
            }
        }
    }

    private void findStaticFavoriteProposals(List<IGroovyProposal> proposals, String prefix, ModuleNode module) {
        for (String favoriteStaticMember : this.favoriteStaticMembers) {
            GroovyMethodProposal proposal;
            int pos = favoriteStaticMember.lastIndexOf(46);
            String typeName = favoriteStaticMember.substring(0, pos);
            String fieldName = favoriteStaticMember.substring(pos + 1);
            ClassNode typeNode = MethodProposalCreator.tryResolveClassNode(typeName, module);
            if (typeNode == null) {
                if (!GroovyLogManager.manager.hasLoggers()) continue;
                GroovyLogManager.manager.log(TraceCategory.CONTENT_ASSIST, "Cannot resolve favorite type " + typeName);
                continue;
            }
            if ("*".equals(fieldName)) {
                for (MethodNode method : this.getAllMethods(typeNode, this.alreadySeen)) {
                    if (!method.isStatic() || !this.matcher.test(prefix, method.getName())) continue;
                    proposal = new GroovyMethodProposal(method);
                    proposal.setRequiredStaticImport(String.valueOf(typeName) + '.' + method.getName());
                    proposal.setRelevanceMultiplier(0.95f);
                    proposals.add(proposal);
                }
                continue;
            }
            if (!this.matcher.test(prefix, fieldName)) continue;
            for (MethodNode method : this.getAllMethods(typeNode, new HashSet<ClassNode>(this.alreadySeen))) {
                if (!method.isStatic() || !method.getName().equals(fieldName)) continue;
                proposal = new GroovyMethodProposal(method);
                proposal.setRequiredStaticImport(favoriteStaticMember);
                proposal.setRelevanceMultiplier(0.95f);
                proposals.add(proposal);
            }
        }
    }

    private static void setRelevanceMultiplier(GroovyMethodProposal proposal, boolean isStatic) {
        MethodNode method = proposal.getMethod();
        float relevanceMultiplier = isStatic && method.isStatic() ? 1.05f : (!method.isStatic() ? 1.0f : 0.95f);
        proposal.setRelevanceMultiplier(relevanceMultiplier);
    }

    private static class TraitSuperMethodProposal
    extends GroovyMethodProposal {
        TraitSuperMethodProposal(MethodNode method, String[] traitAndMethodNames) {
            super(Traits.findTraits((ClassNode)method.getDeclaringClass()).stream().filter(t -> t.getName().equals(traitAndMethodNames[0])).findFirst().map(t -> t.getMethod(traitAndMethodNames[1], method.getParameters())).get());
            this.setRequiredQualifier("super");
        }

        @Override
        public IJavaCompletionProposal createJavaProposal(CompletionEngine engine, ContentAssistContext context, JavaContentAssistInvocationContext javaContext) {
            IJavaCompletionProposal javaProposal = super.createJavaProposal(engine, context, javaContext);
            if (javaProposal instanceof LazyJavaCompletionProposal) {
                CompletionProposal proposal = (CompletionProposal)ReflectionUtils.executePrivateMethod(LazyJavaCompletionProposal.class, (String)"getProposal", (Object)javaProposal);
                CompletionProposal typeProposal = CompletionProposal.create((int)23, (int)context.completionLocation);
                typeProposal.setSignature(proposal.getDeclarationSignature());
                proposal.setRequiredProposals(new CompletionProposal[]{typeProposal});
            }
            return javaProposal;
        }

        @Override
        protected int computeRelevance(ContentAssistContext context) {
            return super.computeRelevance(context) - 1;
        }

        @Override
        protected int getModifiers() {
            return super.getModifiers() & 0xFFFFFBFF;
        }
    }

    private static class TraitSuperPropertyProposal
    extends GroovyFieldProposal {
        TraitSuperPropertyProposal(MethodNode method, String[] traitAndMethodNames) {
            super(MethodProposalCreator.createMockField(Traits.findTraits((ClassNode)method.getDeclaringClass()).stream().filter(t -> t.getName().equals(traitAndMethodNames[0])).findFirst().map(t -> t.getMethod(traitAndMethodNames[1], method.getParameters())).get()));
            this.setRequiredQualifier("super");
        }

        @Override
        public IJavaCompletionProposal createJavaProposal(CompletionEngine engine, ContentAssistContext context, JavaContentAssistInvocationContext javaContext) {
            IJavaCompletionProposal javaProposal = super.createJavaProposal(engine, context, javaContext);
            if (javaProposal instanceof AbstractJavaCompletionProposal) {
                ProposalInfo proposalInfo = (ProposalInfo)ReflectionUtils.executePrivateMethod(AbstractJavaCompletionProposal.class, (String)"getProposalInfo", (Object)javaProposal);
                CompletionProposal proposal = (CompletionProposal)ReflectionUtils.getPrivateField(MemberProposalInfo.class, (String)"fProposal", (Object)proposalInfo);
                CompletionProposal typeProposal = CompletionProposal.create((int)23, (int)context.completionLocation);
                typeProposal.setSignature(proposal.getDeclarationSignature());
                proposal.setRequiredProposals(new CompletionProposal[]{typeProposal});
            }
            return javaProposal;
        }

        @Override
        protected int computeRelevance(ContentAssistContext context) {
            return super.computeRelevance(context) - 1;
        }
    }
}

