/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codeassist.completions;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.eclipse.codeassist.GroovyContentAssist;
import org.codehaus.groovy.eclipse.codeassist.ProposalUtils;
import org.codehaus.groovy.eclipse.codeassist.completions.GroovyExtendedCompletionContext;
import org.codehaus.groovy.eclipse.codeassist.completions.ParameterGuesserDelegate;
import org.codehaus.groovy.eclipse.codeassist.processors.GroovyCompletionProposal;
import org.codehaus.groovy.eclipse.codeassist.proposals.ProposalFormattingOptions;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyGenericTypeProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MethodProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.ProposalContextInformation;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class GroovyJavaMethodCompletionProposal
extends JavaMethodCompletionProposal {
    protected final String fContributor;
    protected final ReplacementPreferences fPreferences;
    protected ImportRewrite fImportRewite;
    protected String fPrefix;
    protected IRegion fSelectedRegion;
    protected String fPositionCategory;
    protected List<Position> fPositions;
    private IPositionUpdater fUpdater;
    protected List<ICompletionProposal[]> fProposals;
    protected static final char[] CLOSURE_TYPE_SIGNATURE = "groovy.lang.Closure;".toCharArray();

    public GroovyJavaMethodCompletionProposal(CompletionProposal proposal, ProposalFormattingOptions options, JavaContentAssistInvocationContext javaContext, String contributor) {
        super(proposal, javaContext);
        this.fContextInformationPosition = -1;
        this.fContributor = contributor == null ? "" : contributor.trim();
        this.fPrefix = this.getPrefix(javaContext.getDocument(), javaContext.getInvocationOffset());
        this.fPreferences = new ReplacementPreferences(options, this.getFormatterPrefs(), javaContext.getProject());
    }

    public final void setImportRewite(ImportRewrite importRewite) {
        this.fImportRewite = importRewite;
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            if (trigger == '{' && DefaultGroovyMethods.asBoolean((char[])this.fProposal.getCompletion())) {
                String replacement = this.getReplacementString();
                if (replacement.endsWith("}") || this.fProposal.getKind() == 12) {
                    trigger = '\u0000';
                } else if (this.fProposal.getKind() == 26 || !this.lastParamAcceptsClosure(Signature.getParameterTypes((char[])this.fProposal.getSignature()))) {
                    if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_block")) {
                        this.setReplacementString(String.valueOf(replacement) + " ");
                    }
                } else {
                    this.setReplacementString(this.recomputeReplacementString());
                    trigger = '\u0000';
                    if (!this.fPreferences.isEnabled("content_assist_fill_method_arguments")) {
                        this.setCursorPosition(this.fPositions.remove(this.fPositions.size() - 1).getOffset());
                    }
                }
            }
            super.apply(document, trigger, offset);
            if (this.fContextInformationPosition >= 0) {
                this.setContextInformationPosition(this.getReplacementOffset() + this.fContextInformationPosition);
                if (DefaultGroovyMethods.asBoolean((char[])this.fProposal.getCompletion())) {
                    this.fSelectedRegion = this.needsLinkedMode() ? new Region(this.fPositions.get(0).getOffset(), this.fPositions.get(0).getLength()) : (this.fPositions != null ? new Region(this.getReplacementOffset() + this.getCursorPosition(), 0) : new Region(this.fContextInformationPosition, 0));
                }
            }
        }
        catch (Exception e) {
            GroovyContentAssist.logError(e);
            this.ensurePositionCategoryRemoved(document);
        }
    }

    protected void appendMethodNameReplacement(StringBuffer buffer) {
        if (this.fProposal.getKind() != 26 && !CharOperation.prefixEquals((char[])this.fProposal.getName(), (char[])this.fProposal.getCompletion())) {
            buffer.append(this.fProposal.getCompletion(), 0, CharOperation.indexOf((char[])this.fProposal.getName(), (char[])this.fProposal.getCompletion(), (boolean)true));
        }
        super.appendMethodNameReplacement(buffer);
    }

    protected IContextInformation computeContextInformation() {
        if (this.hasParameters() && (this.fProposal.getKind() == 6 || this.fProposal.getKind() == 26)) {
            return new ProposalContextInformation(this.fProposal);
        }
        return super.computeContextInformation();
    }

    protected final StyledString computeDisplayString() {
        StyledString displayString = super.computeDisplayString();
        if (!this.fContributor.isEmpty()) {
            displayString.append(new StyledString(" (" + this.fContributor + ")", StyledString.DECORATIONS_STYLER));
        }
        return displayString;
    }

    protected ProposalInfo computeProposalInfo() {
        return new MethodProposalInfo(this.fInvocationContext.getProject(), this.fProposal);
    }

    protected int computeRelevance() {
        return this.fProposal.getRelevance();
    }

    protected String computeReplacementString() {
        if (!DefaultGroovyMethods.asBoolean((char[])this.fProposal.getCompletion())) {
            this.setContextInformationPosition(0);
            return "";
        }
        if (!this.hasArgumentList() || !this.hasParameters()) {
            String replacementString = super.computeReplacementString();
            while (replacementString.endsWith(";")) {
                replacementString = replacementString.substring(0, replacementString.length() - 1);
            }
            return replacementString;
        }
        StringBuffer buffer = new StringBuffer();
        this.appendMethodNameReplacement(buffer);
        if (!this.hasParameters()) {
            while (Character.isWhitespace(buffer.charAt(buffer.length() - 1))) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_invocation")) {
                buffer.append(" ");
            }
            buffer.append(")");
        } else if (!this.fPreferences.isEnabled("content_assist_fill_method_arguments")) {
            if (this.fPreferences.bCommandChaining) {
                int i = buffer.lastIndexOf("(");
                while (Character.isWhitespace(buffer.charAt(i - 1))) {
                    --i;
                }
                buffer.replace(i, buffer.length(), " ");
            } else if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_invocation")) {
                buffer.append(" ");
            }
            this.setContextInformationPosition(buffer.length());
            if (!this.fPreferences.bCommandChaining) {
                buffer.append(")");
            }
        } else {
            int indexOfLastClosure = -1;
            char[][] namedParameterTypes = ((GroovyCompletionProposal)this.fProposal).getNamedParameterTypeNames();
            char[][] regularParameterTypes = ((GroovyCompletionProposal)this.fProposal).getRegularParameterTypeNames();
            if (this.fPreferences.bCommandChaining) {
                int i = buffer.lastIndexOf("(");
                while (Character.isWhitespace(buffer.charAt(i - 1))) {
                    --i;
                }
                buffer.replace(i, buffer.length(), " ");
            } else if (this.fPreferences.isEnabled("org.codehaus.groovy.eclipse.codeassist.closures.noparens") && this.fProposal.getKind() != 26) {
                if (this.lastParamIsClosure(regularParameterTypes, CharOperation.NO_CHAR_CHAR)) {
                    indexOfLastClosure = namedParameterTypes.length + regularParameterTypes.length - 1;
                }
                if (indexOfLastClosure == 0) {
                    buffer.deleteCharAt(buffer.length() - 1);
                    if (!this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_invocation")) {
                        buffer.append(" ");
                    }
                }
            } else if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_invocation")) {
                buffer.append(" ");
            }
            this.setContextInformationPosition(buffer.length());
            char[][] namedParameterNames = ((GroovyCompletionProposal)this.fProposal).getNamedParameterNames();
            char[][] regularParameterNames = ((GroovyCompletionProposal)this.fProposal).getRegularParameterNames();
            int namedCount = namedParameterNames.length;
            int totalCount = regularParameterNames.length + namedCount;
            this.computeReplacementProposals(namedParameterNames, regularParameterNames, indexOfLastClosure);
            int i = 0;
            while (i < totalCount) {
                char[] nextType;
                char[] nextName;
                if (i < namedCount) {
                    nextName = namedParameterNames[i];
                    nextType = namedParameterTypes[i];
                } else {
                    nextName = regularParameterNames[i - namedCount];
                    nextType = regularParameterTypes[i - namedCount];
                }
                String nextValue = this.fProposals.get(i)[0].getDisplayString();
                if ((this.fPreferences.isEnabled("org.codehaus.groovy.eclipse.codeassist.arguments.named") || i < namedCount) && i != indexOfLastClosure) {
                    buffer.append(nextName);
                    if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_before_colon_in_labeled_statement")) {
                        buffer.append(" ");
                    }
                    buffer.append(":");
                    if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_after_colon_in_labeled_statement")) {
                        buffer.append(" ");
                    }
                }
                this.fPositions.get(i).setLength(nextValue.length());
                this.fPositions.get(i).setOffset(buffer.length());
                buffer.append(nextValue);
                if (i == indexOfLastClosure - 1 || i != indexOfLastClosure && i == totalCount - 1 && !this.fPreferences.bCommandChaining) {
                    if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_invocation")) {
                        buffer.append(" ");
                    }
                    buffer.append(")");
                    if (i == indexOfLastClosure - 1 && (!this.fPreferences.isEnabled("org.codehaus.groovy.eclipse.codeassist.closures.literals") || this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_block"))) {
                        buffer.append(" ");
                    }
                } else if (i < totalCount - 1) {
                    if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments")) {
                        buffer.append(" ");
                    }
                    buffer.append(",");
                    if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments")) {
                        buffer.append(" ");
                    }
                } else if (!this.fPreferences.bCommandChaining) {
                    this.fPositions.remove(i);
                    this.setCursorPosition(buffer.length() - (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_before_closing_brace_in_array_initializer") ? 2 : 1));
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    protected String recomputeReplacementString() throws JavaModelException {
        char[][] paramTypes;
        if (this.fProposals != null) {
            this.fProposals.remove(this.fProposals.size() - 1);
        } else {
            assert (this.fPositions == null);
            this.fPositions = new ArrayList<Position>();
            this.fProposals = Collections.EMPTY_LIST;
            this.fPositions.add(new Position(this.getContextInformationPosition()));
            if (Signature.getParameterCount((char[])this.fProposal.getSignature()) > 1) {
                this.fPositions.add(new Position(this.getContextInformationPosition()));
            }
        }
        int last = this.fPositions.size() - 1;
        String head = this.getReplacementString().substring(0, this.fPositions.get(last).getOffset());
        String tail = this.getReplacementString().substring(this.fPositions.get(last).getOffset() + this.fPositions.get(last).getLength());
        if (this.fPreferences.isEnabled("org.codehaus.groovy.eclipse.codeassist.closures.noparens")) {
            if (!tail.isEmpty()) {
                head = last == 0 ? head.substring(0, head.lastIndexOf("(")) : String.valueOf(head.substring(0, Math.max(head.lastIndexOf(","), head.lastIndexOf("(") + 1))) + tail;
                if (!head.endsWith(" ") && this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_block")) {
                    head = String.valueOf(head) + " ";
                }
                tail = "";
            } else if (head.endsWith(" ") && !this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_before_opening_brace_in_block")) {
                head = head.substring(head.length() - 1);
            }
        }
        StringBuffer buffer = new StringBuffer(head);
        buffer.append("{");
        if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_after_opening_brace_in_array_initializer")) {
            buffer.append(" ");
        }
        if (!this.lastParamIsClosure(paramTypes = Signature.getParameterTypes((char[])this.fProposal.getSignature()))) {
            IMethod sam = this.findSingleAbstractMethod(paramTypes[paramTypes.length - 1]);
            String[] names = sam.getParameterNames();
            int n = names.length;
            int i = 0;
            while (i < n) {
                if (i > 0) {
                    if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_before_comma_in_array_initializer")) {
                        buffer.append(" ");
                    }
                    buffer.append(",");
                    if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_after_comma_in_array_initializer")) {
                        buffer.append(" ");
                    }
                }
                this.fPositions.add(last, new Position(buffer.length(), names[i].length()));
                buffer.append(names[i]);
                ++last;
                ++i;
            }
            if (n > 0) {
                buffer.append(" ");
            }
            buffer.append("->");
        }
        this.fPositions.get(last).setLength(0);
        this.fPositions.get(last).setOffset(buffer.length());
        if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_before_closing_brace_in_array_initializer")) {
            buffer.append(" ");
        }
        buffer.append("}");
        buffer.append(tail);
        return buffer.toString();
    }

    protected LazyJavaCompletionProposal createRequiredTypeCompletionProposal(CompletionProposal completionProposal, JavaContentAssistInvocationContext invocationContext) {
        LazyJavaCompletionProposal requiredProposal = super.createRequiredTypeCompletionProposal(completionProposal, invocationContext);
        if (this.fProposal.getKind() == 26 && requiredProposal instanceof LazyJavaTypeCompletionProposal) {
            if (this.fImportRewite != null) {
                ReflectionUtils.setPrivateField(LazyJavaTypeCompletionProposal.class, (String)"fImportRewrite", (Object)requiredProposal, (Object)this.fImportRewite);
            }
            if (requiredProposal instanceof LazyGenericTypeProposal) {
                try {
                    ReflectionUtils.setPrivateField(LazyGenericTypeProposal.class, (String)"fTypeArgumentProposals", (Object)requiredProposal, (Object)Array.newInstance(Class.forName("org.eclipse.jdt.internal.ui.text.java.LazyGenericTypeProposal$TypeArgumentProposal"), 0));
                }
                catch (Exception e) {
                    GroovyContentAssist.logError(e);
                }
            }
        }
        return requiredProposal;
    }

    protected char[] computeTriggerCharacters() {
        if (this.hasParameters()) {
            return ProposalUtils.METHOD_WITH_ARGUMENTS_TRIGGERS;
        }
        if (this.fPrefix.isEmpty() && ProposalUtils.isContentAssistAutoActiavted()) {
            return ProposalUtils.getContentAssistContext(this.fInvocationContext).map(context -> {
                String q = context.getQualifiedCompletionExpression();
                if (q.endsWith(".") && q.indexOf(46) == q.lastIndexOf(46)) {
                    return CharOperation.remove((char[])ProposalUtils.METHOD_TRIGGERS, (char)'.');
                }
                return null;
            }).orElse(ProposalUtils.METHOD_TRIGGERS);
        }
        return ProposalUtils.METHOD_TRIGGERS;
    }

    public int getContextInformationPosition() {
        return this.fContextInformationPosition;
    }

    protected int getPatternMatchRule(String pattern, String string) {
        if (string.charAt(0) == '\"') {
            string = string.substring(1);
        }
        return super.getPatternMatchRule(pattern, string);
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion != null) {
            return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
        }
        return super.getSelection(document);
    }

    protected boolean isPrefix(String prefix, String string) {
        if (!this.hasParameters()) {
            ReflectionUtils.setPrivateField(LazyJavaCompletionProposal.class, (String)"fTriggerCharactersComputed", (Object)((Object)this), (Object)Boolean.FALSE);
        }
        this.fPrefix = prefix;
        return super.isPrefix(prefix, string);
    }

    protected boolean needsLinkedMode() {
        return DefaultGroovyMethods.asBoolean(this.fPositions);
    }

    protected void setUpLinkedMode(IDocument document, char closingCharacter) {
        if (this.getTextViewer() != null) {
            try {
                int baseOffset = this.getReplacementOffset();
                LinkedModeModel model = new LinkedModeModel();
                if (this.fPositions == null) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, baseOffset + this.fContextInformationPosition, 0));
                    model.addGroup(group);
                } else {
                    int i = 0;
                    int n = this.fPositions.size();
                    while (i < n) {
                        Position position = this.fPositions.get(i);
                        position.setOffset(baseOffset + position.getOffset());
                        LinkedPositionGroup group = new LinkedPositionGroup();
                        if (this.fProposals.size() <= i || this.fProposals.get(i).length <= 1) {
                            group.addPosition(new LinkedPosition(document, position.getOffset(), position.getLength(), -1));
                        } else {
                            this.ensurePositionCategoryInstalled(document, model);
                            document.addPosition(this.fPositionCategory, position);
                            group.addPosition((LinkedPosition)new ProposalPosition(document, position.getOffset(), position.getLength(), -1, this.fProposals.get(i)));
                        }
                        model.addGroup(group);
                        ++i;
                    }
                }
                JavaEditor editor = this.getJavaEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                ui.setDoContextInfo(true);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new AbstractJavaCompletionProposal.ExitPolicy(closingCharacter, document));
                ui.setExitPosition(this.getTextViewer(), baseOffset + this.getCursorPosition(), 0, Integer.MAX_VALUE);
                ui.enter();
            }
            catch (BadLocationException | BadPositionCategoryException e) {
                GroovyContentAssist.logError(e);
            }
        }
    }

    protected void computeReplacementProposals(char[][] namedParameterNames, char[][] positionalParameterNames, int indexOfLastClosure) {
        boolean guess = this.fInvocationContext.getCoreContext().isExtended() && this.fPreferences.isEnabled("content_assist_guess_method_arguments");
        char[][] parameterTypes = Signature.getParameterTypes((char[])this.fProposal.getSignature());
        int npc = namedParameterNames.length;
        int n = npc + positionalParameterNames.length;
        this.fPositions = new ArrayList<Position>(n);
        this.fProposals = new ArrayList<ICompletionProposal[]>(n);
        int i = 0;
        while (i < n) {
            ICompletionProposal[] vals;
            boolean isCodeBlock;
            this.fPositions.add(new Position(0));
            char[] name = i < npc ? namedParameterNames[i] : positionalParameterNames[i - npc];
            char[] type = Signature.getTypeErasure((char[])parameterTypes[i]);
            boolean bl = isCodeBlock = i == indexOfLastClosure && i + 1 == n && this.fPreferences.isEnabled("org.codehaus.groovy.eclipse.codeassist.closures.noparens");
            if (guess && !isCodeBlock) {
                boolean fillBestGuess = true;
                String typeSignature = String.valueOf(type);
                IJavaElement[] visibleElements = this.fInvocationContext.getCoreContext().getVisibleElements(typeSignature);
                vals = new ParameterGuesserDelegate(this.getEnclosingElement(), this.fInvocationContext).parameterProposals(Signature.toString((String)typeSignature), String.valueOf(name), this.fPositions.get(i), visibleElements, fillBestGuess);
            } else {
                boolean isClosure;
                StringBuilder buffer = new StringBuilder();
                boolean bl2 = isClosure = i == indexOfLastClosure || CharOperation.equals((char[])CLOSURE_TYPE_SIGNATURE, (char[])type, (int)1, (int)type.length);
                if (isClosure && (this.fPreferences.isEnabled("org.codehaus.groovy.eclipse.codeassist.closures.literals") || isCodeBlock)) {
                    buffer.append("{");
                    if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_after_opening_brace_in_array_initializer")) {
                        buffer.append(" ");
                    }
                    if (this.fPreferences.isEnabled("org.eclipse.jdt.core.formatter.insert_space_before_closing_brace_in_array_initializer")) {
                        buffer.append(" ");
                    }
                    buffer.append("}");
                } else {
                    buffer.append(name);
                }
                vals = new ICompletionProposal[]{new JavaCompletionProposal(buffer.toString(), 0, buffer.length(), null, buffer.toString(), 1)};
            }
            this.fProposals.add(vals);
            ++i;
        }
    }

    private void ensurePositionCategoryInstalled(final IDocument document, LinkedModeModel model) {
        this.fPositionCategory = "ParameterGuessingProposal_" + this.toString();
        if (!document.containsPositionCategory(this.fPositionCategory)) {
            this.fUpdater = new InclusivePositionUpdater(this.fPositionCategory);
            document.addPositionCategory(this.fPositionCategory);
            document.addPositionUpdater(this.fUpdater);
            model.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel environment, int flags) {
                    GroovyJavaMethodCompletionProposal.this.ensurePositionCategoryRemoved(document);
                }

                public void suspend(LinkedModeModel environment) {
                }

                public void resume(LinkedModeModel environment, int flags) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument document) {
        if (document.containsPositionCategory(this.fPositionCategory)) {
            try {
                document.removePositionCategory(this.fPositionCategory);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            document.removePositionUpdater(this.fUpdater);
        }
        this.fUpdater = null;
    }

    protected final IMethod findSingleAbstractMethod(char[] typeSignature) throws JavaModelException {
        char[] name = CharOperation.concat((char[])Signature.getSignatureQualifier((char[])typeSignature), (char[])Signature.getSignatureSimpleName((char[])Signature.getTypeErasure((char[])typeSignature)), (char)'.');
        IType type = this.fInvocationContext.getProject().getJavaProject().findType(String.valueOf(name));
        if (type.exists()) {
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                if (Flags.isAbstract((int)m.getFlags())) {
                    return m;
                }
                ++n2;
            }
        }
        return null;
    }

    protected final IJavaElement getEnclosingElement() {
        if (this.fInvocationContext.getCoreContext().isExtended()) {
            return this.fInvocationContext.getCoreContext().getEnclosingElement();
        }
        return null;
    }

    protected final JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    protected final boolean lastParamAcceptsClosure(char[][] parameterSignatures) {
        char[] lastType;
        if (this.lastParamIsClosure(parameterSignatures)) {
            return true;
        }
        int n = parameterSignatures.length;
        if (n > 0 && this.fInvocationContext.getCoreContext().isExtended() && Signature.getArrayCount((char[])(lastType = Signature.getTypeErasure((char[])parameterSignatures[n - 1]))) == 0) {
            GroovyExtendedCompletionContext groovyContext = (GroovyExtendedCompletionContext)((Object)ReflectionUtils.getPrivateField(InternalCompletionContext.class, (String)"extendedContext", (Object)this.fInvocationContext.getCoreContext()));
            return ClassHelper.isSAMType((ClassNode)groovyContext.toClassNode(lastType));
        }
        return false;
    }

    protected final boolean lastParamIsClosure(char[][] parameterSignatures) {
        char[] lastType;
        int n = parameterSignatures.length;
        return n > 0 && CharOperation.equals((char[])CLOSURE_TYPE_SIGNATURE, (char[])(lastType = Signature.getTypeErasure((char[])parameterSignatures[n - 1])), (int)1, (int)lastType.length);
    }

    protected final boolean lastParamIsClosure(char[][] parameterTypeNames, char[][] namedParameterTypeNames) {
        if (DefaultGroovyMethods.asBoolean((Object[])parameterTypeNames)) {
            char[] lastTypeName = parameterTypeNames[parameterTypeNames.length - 1];
            return CharOperation.equals((char[])lastTypeName, (char[])CLOSURE_TYPE_SIGNATURE, (int)0, (int)(CLOSURE_TYPE_SIGNATURE.length - 1));
        }
        return false;
    }

    public List<ICompletionProposal[]> getChoices() {
        return this.fProposals;
    }

    protected static class ReplacementPreferences {
        public final boolean bCommandChaining;
        private final Map<String, Boolean> cache = new HashMap<String, Boolean>(32);
        private final Function<String, Boolean> computer;
        private Map<String, String> defaults;

        public ReplacementPreferences(ProposalFormattingOptions opts, LazyJavaCompletionProposal.FormatterPrefs prefs, IJavaProject project) {
            this.bCommandChaining = opts.noParens;
            this.cache.put("org.codehaus.groovy.eclipse.codeassist.arguments.named", opts.useNamedArguments);
            this.cache.put("org.codehaus.groovy.eclipse.codeassist.closures.literals", opts.useBracketsForClosures);
            this.cache.put("org.codehaus.groovy.eclipse.codeassist.closures.noparens", opts.noParensAroundClosures);
            this.cache.put("org.eclipse.jdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", prefs.beforeOpeningParen);
            this.cache.put("org.eclipse.jdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", prefs.afterOpeningParen);
            this.cache.put("org.eclipse.jdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments", prefs.beforeComma);
            this.cache.put("org.eclipse.jdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments", prefs.afterComma);
            this.cache.put("org.eclipse.jdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", prefs.beforeClosingParen);
            this.cache.put("org.eclipse.jdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", prefs.inEmptyList);
            this.cache.put("org.eclipse.jdt.core.formatter.insert_space_before_comma_in_parameterized_type_reference", prefs.beforeTypeArgumentComma);
            this.cache.put("org.eclipse.jdt.core.formatter.insert_space_after_comma_in_parameterized_type_reference", prefs.afterTypeArgumentComma);
            this.cache.put("org.eclipse.jdt.core.formatter.insert_space_before_opening_angle_bracket_in_parameterized_type_reference", prefs.beforeOpeningBracket);
            this.cache.put("org.eclipse.jdt.core.formatter.insert_space_after_opening_angle_bracket_in_parameterized_type_reference", prefs.afterOpeningBracket);
            this.cache.put("org.eclipse.jdt.core.formatter.insert_space_before_closing_angle_bracket_in_parameterized_type_reference", prefs.beforeClosingBracket);
            IPreferenceStore uiPrefs = JavaPlugin.getDefault().getPreferenceStore();
            boolean fillArgs = uiPrefs.getBoolean("content_assist_fill_method_arguments");
            this.cache.put("content_assist_fill_method_arguments", fillArgs);
            this.cache.put("content_assist_guess_method_arguments", fillArgs && uiPrefs.getBoolean("content_assist_guess_method_arguments"));
            this.computer = key -> {
                boolean def = this.getDefaultOptions().get(key).matches("enabled|insert");
                Boolean val = (Boolean)ReflectionUtils.executePrivateMethod(LazyJavaCompletionProposal.FormatterPrefs.class, (String)"getCoreOption", (Class[])new Class[]{IJavaProject.class, String.class, Boolean.TYPE}, (Object)prefs, (Object[])new Object[]{project, key, def});
                return val;
            };
        }

        private Map<String, String> getDefaultOptions() {
            if (this.defaults == null) {
                this.defaults = JavaCore.getDefaultOptions();
            }
            return this.defaults;
        }

        public final boolean isEnabled(String key) {
            return this.cache.computeIfAbsent(key, this.computer);
        }
    }
}

