/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CFFStandardString;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.cff.CFFDataReader;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OTFSubSetWriter;

public class OTFSubSetFile
extends OTFSubSetWriter {
    protected Map<Integer, Integer> subsetGlyphs = new LinkedHashMap<Integer, Integer>();
    protected Map<Integer, Integer> gidToSID;
    protected CFFDataReader.CFFIndexData localIndexSubr;
    protected CFFDataReader.CFFIndexData globalIndexSubr;
    protected List<byte[]> subsetLocalIndexSubr;
    protected List<byte[]> subsetGlobalIndexSubr;
    private List<List<byte[]>> fdSubrs;
    private Map<Integer, FDIndexReference> subsetFDSelect;
    protected List<Integer> localUniques;
    protected List<Integer> globalUniques;
    protected int subsetLocalSubrCount;
    protected int subsetGlobalSubrCount;
    protected List<byte[]> subsetCharStringsIndex;
    protected String embeddedName;
    protected List<byte[]> stringIndexData = new ArrayList<byte[]>();
    protected CFFDataReader cffReader;
    private MultiByteFont mbFont;
    public static final int NUM_STANDARD_STRINGS = 391;
    private static final int LOCAL_SUBROUTINE = 10;
    private static final int GLOBAL_SUBROUTINE = 29;
    private Type2Parser type2Parser;

    public void readFont(FontFileReader in, String embeddedName, String header, MultiByteFont mbFont) throws IOException {
        this.mbFont = mbFont;
        this.readFont(in, embeddedName, header, mbFont.getUsedGlyphs());
    }

    void readFont(FontFileReader in, String embeddedName, String header, Map<Integer, Integer> usedGlyphs) throws IOException {
        this.fontFile = in;
        this.currentPos = 0;
        this.realSize = 0;
        this.embeddedName = embeddedName;
        this.subsetGlyphs = this.sortByValue(usedGlyphs);
        this.output = new byte[in.getFileSize()];
        this.initializeFont(in);
        this.cffReader = new CFFDataReader(this.fontFile);
        this.createCFF();
    }

    private Map<Integer, Integer> sortByValue(Map<Integer, Integer> map) {
        ArrayList<Map.Entry<Integer, Integer>> list = new ArrayList<Map.Entry<Integer, Integer>>(map.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Integer, Integer>>(){

            @Override
            public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap<Integer, Integer> result = new LinkedHashMap<Integer, Integer>();
        for (Map.Entry entry : list) {
            result.put((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        return result;
    }

    protected void createCFF() throws IOException {
        this.writeBytes(this.cffReader.getHeader());
        this.writeIndex(Arrays.asList(new byte[][]{this.embedFontName.getBytes()}));
        int topDictOffset = this.currentPos;
        byte[] topDictIndex = this.cffReader.getTopDictIndex().getByteData();
        byte offSize = topDictIndex[2];
        this.writeBytes(topDictIndex, 0, 3 + offSize * 2);
        int topDictDataOffset = this.currentPos;
        this.writeTopDICT();
        if (this.cffReader.getFDSelect() == null) {
            this.createCharStringData();
        } else {
            this.createCharStringDataCID();
        }
        List<Integer> fontNameSIDs = null;
        List<Integer> subsetFDFonts = null;
        if (this.cffReader.getFDSelect() != null) {
            subsetFDFonts = this.getUsedFDFonts();
            fontNameSIDs = this.storeFDStrings(subsetFDFonts);
        }
        this.writeStringIndex();
        this.writeIndex(this.subsetGlobalIndexSubr);
        int encodingOffset = this.currentPos;
        int charsetOffset = this.currentPos;
        this.writeCharsetTable(this.cffReader.getFDSelect() != null);
        int fdSelectOffset = this.currentPos;
        if (this.cffReader.getFDSelect() != null) {
            this.writeFDSelect();
        }
        int charStringOffset = this.currentPos;
        this.writeIndex(this.subsetCharStringsIndex);
        if (this.cffReader.getFDSelect() == null) {
            int privateDictOffset = this.currentPos;
            this.writePrivateDict();
            int localIndexOffset = this.currentPos;
            this.writeIndex(this.subsetLocalIndexSubr);
            this.updateOffsets(topDictOffset, charsetOffset, charStringOffset, privateDictOffset, localIndexOffset, encodingOffset);
        } else {
            List<Integer> privateDictOffsets = this.writeCIDDictsAndSubrs(subsetFDFonts);
            int fdArrayOffset = this.writeFDArray(subsetFDFonts, privateDictOffsets, fontNameSIDs);
            this.updateCIDOffsets(topDictDataOffset, fdArrayOffset, fdSelectOffset, charsetOffset, charStringOffset, encodingOffset);
        }
    }

    protected List<Integer> storeFDStrings(List<Integer> uniqueNewRefs) throws IOException {
        ArrayList<Integer> fontNameSIDs = new ArrayList<Integer>();
        List<CFFDataReader.FontDict> fdFonts = this.cffReader.getFDFonts();
        for (Integer uniqueNewRef : uniqueNewRefs) {
            CFFDataReader.FontDict fdFont = fdFonts.get(uniqueNewRef);
            byte[] fdFontByteData = fdFont.getByteData();
            LinkedHashMap<String, CFFDataReader.DICTEntry> fdFontDict = this.cffReader.parseDictData(fdFontByteData);
            fontNameSIDs.add(this.stringIndexData.size() + 391);
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(((CFFDataReader.DICTEntry)fdFontDict.get("FontName")).getOperands().get(0).intValue() - 391));
        }
        return fontNameSIDs;
    }

    protected void writeTopDICT() throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        List<String> topDictStringEntries = Arrays.asList("version", "Notice", "Copyright", "FullName", "FamilyName", "Weight", "PostScript");
        for (Map.Entry dictEntry : topDICT.entrySet()) {
            String dictKey = (String)dictEntry.getKey();
            CFFDataReader.DICTEntry entry = (CFFDataReader.DICTEntry)dictEntry.getValue();
            if (dictKey.equals("ROS")) {
                this.writeROSEntry(entry);
                continue;
            }
            if (dictKey.equals("CIDCount")) {
                this.writeCIDCount(entry);
                continue;
            }
            if (topDictStringEntries.contains(dictKey)) {
                this.writeTopDictStringEntry(entry);
                continue;
            }
            this.writeBytes(entry.getByteData());
        }
    }

    private void writeROSEntry(CFFDataReader.DICTEntry dictEntry) throws IOException {
        int sidA = dictEntry.getOperands().get(0).intValue();
        if (sidA > 390) {
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(sidA - 391));
        }
        int sidAStringIndex = this.stringIndexData.size() + 390;
        int sidB = dictEntry.getOperands().get(1).intValue();
        if (sidB > 390) {
            this.stringIndexData.add("Identity".getBytes());
        }
        int sidBStringIndex = this.stringIndexData.size() + 390;
        byte[] cidEntryByteData = dictEntry.getByteData();
        this.updateOffset(cidEntryByteData, 0, dictEntry.getOperandLengths().get(0), sidAStringIndex);
        this.updateOffset(cidEntryByteData, dictEntry.getOperandLengths().get(0), dictEntry.getOperandLengths().get(1), sidBStringIndex);
        this.updateOffset(cidEntryByteData, dictEntry.getOperandLengths().get(0) + dictEntry.getOperandLengths().get(1), dictEntry.getOperandLengths().get(2), 0);
        this.writeBytes(cidEntryByteData);
    }

    protected void writeCIDCount(CFFDataReader.DICTEntry dictEntry) throws IOException {
        byte[] cidCountByteData = dictEntry.getByteData();
        this.updateOffset(cidCountByteData, 0, dictEntry.getOperandLengths().get(0), this.subsetGlyphs.size());
        this.writeBytes(cidCountByteData);
    }

    private void writeTopDictStringEntry(CFFDataReader.DICTEntry dictEntry) throws IOException {
        int sid = dictEntry.getOperands().get(0).intValue();
        if (sid > 391) {
            this.stringIndexData.add(this.cffReader.getStringIndex().getValue(sid - 391));
        }
        byte[] newDictEntry = OTFSubSetFile.createNewRef(this.stringIndexData.size() + 390, dictEntry.getOperator(), dictEntry.getOperandLength(), true);
        this.writeBytes(newDictEntry);
    }

    private void writeStringIndex() throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        int charsetOffset = ((CFFDataReader.DICTEntry)topDICT.get("charset")).getOperands().get(0).intValue();
        this.gidToSID = new LinkedHashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> subsetGlyph : this.subsetGlyphs.entrySet()) {
            int gid = subsetGlyph.getKey();
            int sid = this.cffReader.getSIDFromGID(charsetOffset, gid);
            if (sid < 391) {
                this.gidToSID.put(subsetGlyph.getValue(), sid);
                if (this.mbFont == null) continue;
                this.mbFont.mapUsedGlyphName(subsetGlyph.getValue(), CFFStandardString.getName((int)sid));
                continue;
            }
            int index = sid - 391;
            if (index < this.cffReader.getStringIndex().getNumObjects()) {
                if (this.mbFont != null) {
                    this.mbFont.mapUsedGlyphName(subsetGlyph.getValue(), new String(this.cffReader.getStringIndex().getValue(index)));
                }
                this.gidToSID.put(subsetGlyph.getValue(), this.stringIndexData.size() + 391);
                this.stringIndexData.add(this.cffReader.getStringIndex().getValue(index));
                continue;
            }
            if (this.mbFont != null) {
                this.mbFont.mapUsedGlyphName(subsetGlyph.getValue(), ".notdef");
            }
            this.gidToSID.put(subsetGlyph.getValue(), index);
        }
        this.writeIndex(this.stringIndexData);
    }

    protected void createCharStringDataCID() throws IOException {
        CFFDataReader.CFFIndexData charStringsIndex = this.cffReader.getCharStringIndex();
        CFFDataReader.FDSelect fontDictionary = this.cffReader.getFDSelect();
        if (fontDictionary instanceof CFFDataReader.Format0FDSelect) {
            throw new UnsupportedOperationException("OTF CFF CID Format0 currently not implemented");
        }
        if (fontDictionary instanceof CFFDataReader.Format3FDSelect) {
            CFFDataReader.Format3FDSelect fdSelect = (CFFDataReader.Format3FDSelect)fontDictionary;
            HashMap<Integer, Integer> subsetGroups = new HashMap<Integer, Integer>();
            ArrayList<Integer> uniqueGroups = new ArrayList<Integer>();
            for (int gid : this.subsetGlyphs.keySet()) {
                Set<Integer> rangeKeys = fdSelect.getRanges().keySet();
                Integer[] integerArray = rangeKeys.toArray(new Integer[rangeKeys.size()]);
                for (int i = 0; i < integerArray.length; ++i) {
                    int nextRange = -1;
                    nextRange = i < integerArray.length - 1 ? integerArray[i + 1].intValue() : fdSelect.getSentinelGID();
                    if (gid < integerArray[i] || gid >= nextRange) continue;
                    subsetGroups.put(gid, fdSelect.getRanges().get(integerArray[i]));
                    if (uniqueGroups.contains(fdSelect.getRanges().get(integerArray[i]))) continue;
                    uniqueGroups.add(fdSelect.getRanges().get(integerArray[i]));
                }
            }
            this.globalIndexSubr = this.cffReader.getGlobalIndexSubr();
            this.subsetCharStringsIndex = new ArrayList<byte[]>();
            this.globalUniques = new ArrayList<Integer>();
            this.subsetFDSelect = new LinkedHashMap<Integer, FDIndexReference>();
            ArrayList foundLocalUniques = new ArrayList();
            for (Integer uniqueGroup1 : uniqueGroups) {
                foundLocalUniques.add(new ArrayList());
            }
            HashMap<Integer, Integer> gidHintMaskLengths = new HashMap<Integer, Integer>();
            for (Map.Entry<Integer, Integer> entry : this.subsetGlyphs.entrySet()) {
                int n = entry.getKey();
                int group = (Integer)subsetGroups.get(n);
                this.localIndexSubr = this.cffReader.getFDFonts().get(group).getLocalSubrData();
                this.localUniques = (List)foundLocalUniques.get(uniqueGroups.indexOf(group));
                this.type2Parser = new Type2Parser();
                FDIndexReference newFDReference = new FDIndexReference(uniqueGroups.indexOf(group), group);
                this.subsetFDSelect.put(entry.getValue(), newFDReference);
                byte[] data = charStringsIndex.getValue(n);
                this.preScanForSubsetIndexSize(data);
                gidHintMaskLengths.put(n, this.type2Parser.getMaskLength());
            }
            this.subsetGlobalIndexSubr = new ArrayList<byte[]>();
            this.fdSubrs = new ArrayList<List<byte[]>>();
            this.subsetGlobalSubrCount = this.globalUniques.size();
            this.globalUniques.clear();
            this.localUniques = null;
            for (List list : foundLocalUniques) {
                this.fdSubrs.add(new ArrayList());
            }
            ArrayList foundLocalUniquesB = new ArrayList();
            for (Integer n : uniqueGroups) {
                foundLocalUniquesB.add(new ArrayList());
            }
            for (Map.Entry<Integer, Integer> entry : this.subsetGlyphs.entrySet()) {
                int gid = entry.getKey();
                int value = entry.getValue();
                int group = (Integer)subsetGroups.get(gid);
                this.localIndexSubr = this.cffReader.getFDFonts().get(group).getLocalSubrData();
                this.localUniques = (List)foundLocalUniquesB.get(this.subsetFDSelect.get(value).getNewFDIndex());
                byte[] data = charStringsIndex.getValue(gid);
                this.subsetLocalIndexSubr = this.fdSubrs.get(this.subsetFDSelect.get(value).getNewFDIndex());
                this.subsetLocalSubrCount = ((List)foundLocalUniques.get(this.subsetFDSelect.get(value).getNewFDIndex())).size();
                this.type2Parser = new Type2Parser();
                this.type2Parser.setMaskLength((Integer)gidHintMaskLengths.get(gid));
                data = this.readCharStringData(data, this.subsetLocalSubrCount);
                this.subsetCharStringsIndex.add(data);
            }
        }
    }

    protected void writeFDSelect() {
        if (this.cffReader.getTopDictEntries().get("CharStrings").getOperandLength() == 2) {
            Map<Integer, Integer> indexs = this.getFormat3Index();
            this.writeByte(3);
            this.writeCard16(indexs.size());
            int count = 0;
            for (Map.Entry<Integer, Integer> x : indexs.entrySet()) {
                this.writeCard16(count);
                this.writeByte(x.getKey());
                count += x.getValue().intValue();
            }
            this.writeCard16(this.subsetFDSelect.size());
        } else {
            this.writeByte(0);
            for (FDIndexReference e : this.subsetFDSelect.values()) {
                this.writeByte(e.getNewFDIndex());
            }
        }
    }

    private Map<Integer, Integer> getFormat3Index() {
        LinkedHashMap<Integer, Integer> indexs = new LinkedHashMap<Integer, Integer>();
        int last = -1;
        int count = 0;
        for (FDIndexReference e : this.subsetFDSelect.values()) {
            int i = e.getNewFDIndex();
            ++count;
            if (i != last) {
                indexs.put(i, count);
                count = 1;
            }
            last = i;
        }
        indexs.put(last, count);
        return indexs;
    }

    protected List<Integer> getUsedFDFonts() {
        ArrayList<Integer> uniqueNewRefs = new ArrayList<Integer>();
        for (FDIndexReference e : this.subsetFDSelect.values()) {
            int fdIndex = e.getOldFDIndex();
            if (uniqueNewRefs.contains(fdIndex)) continue;
            uniqueNewRefs.add(fdIndex);
        }
        return uniqueNewRefs;
    }

    protected List<Integer> writeCIDDictsAndSubrs(List<Integer> uniqueNewRefs) throws IOException {
        ArrayList<Integer> privateDictOffsets = new ArrayList<Integer>();
        List<CFFDataReader.FontDict> fdFonts = this.cffReader.getFDFonts();
        for (int i = 0; i < uniqueNewRefs.size(); ++i) {
            CFFDataReader.FontDict curFDFont = fdFonts.get(uniqueNewRefs.get(i));
            LinkedHashMap<String, CFFDataReader.DICTEntry> fdPrivateDict = this.cffReader.parseDictData(curFDFont.getPrivateDictData());
            int privateDictOffset = this.currentPos;
            privateDictOffsets.add(privateDictOffset);
            byte[] fdPrivateDictByteData = curFDFont.getPrivateDictData();
            if (fdPrivateDict.get("Subrs") != null) {
                this.updateOffset(fdPrivateDictByteData, ((CFFDataReader.DICTEntry)fdPrivateDict.get("Subrs")).getOffset(), ((CFFDataReader.DICTEntry)fdPrivateDict.get("Subrs")).getOperandLength(), fdPrivateDictByteData.length);
            }
            this.writeBytes(fdPrivateDictByteData);
            this.writeIndex(this.fdSubrs.get(i));
        }
        return privateDictOffsets;
    }

    protected int writeFDArray(List<Integer> uniqueNewRefs, List<Integer> privateDictOffsets, List<Integer> fontNameSIDs) throws IOException {
        int offset = this.currentPos;
        List<CFFDataReader.FontDict> fdFonts = this.cffReader.getFDFonts();
        this.writeCard16(uniqueNewRefs.size());
        this.writeByte(1);
        this.writeByte(1);
        int count = 1;
        for (Integer uniqueNewRef : uniqueNewRefs) {
            CFFDataReader.FontDict fdFont = fdFonts.get(uniqueNewRef);
            this.writeByte(count += fdFont.getByteData().length);
        }
        for (int i = 0; i < uniqueNewRefs.size(); ++i) {
            CFFDataReader.FontDict fdFont = fdFonts.get(uniqueNewRefs.get(i));
            byte[] fdFontByteData = fdFont.getByteData();
            LinkedHashMap<String, CFFDataReader.DICTEntry> fdFontDict = this.cffReader.parseDictData(fdFontByteData);
            this.updateOffset(fdFontByteData, ((CFFDataReader.DICTEntry)fdFontDict.get("FontName")).getOffset() - 1, ((CFFDataReader.DICTEntry)fdFontDict.get("FontName")).getOperandLengths().get(0), fontNameSIDs.get(i));
            this.updateOffset(fdFontByteData, ((CFFDataReader.DICTEntry)fdFontDict.get("Private")).getOffset() + ((CFFDataReader.DICTEntry)fdFontDict.get("Private")).getOperandLengths().get(0), ((CFFDataReader.DICTEntry)fdFontDict.get("Private")).getOperandLengths().get(1), privateDictOffsets.get(i));
            this.writeBytes(fdFontByteData);
        }
        return offset;
    }

    private void createCharStringData() throws IOException {
        byte[] data;
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        CFFDataReader.CFFIndexData charStringsIndex = this.cffReader.getCharStringIndex();
        CFFDataReader.DICTEntry privateEntry = (CFFDataReader.DICTEntry)topDICT.get("Private");
        if (privateEntry != null) {
            int privateOffset = privateEntry.getOperands().get(1).intValue();
            Map<String, CFFDataReader.DICTEntry> privateDICT = this.cffReader.getPrivateDict(privateEntry);
            if (privateDICT.get("Subrs") != null) {
                int localSubrOffset = privateOffset + privateDICT.get("Subrs").getOperands().get(0).intValue();
                this.localIndexSubr = this.cffReader.readIndex(localSubrOffset);
            } else {
                this.localIndexSubr = this.cffReader.readIndex(null);
            }
        }
        this.globalIndexSubr = this.cffReader.getGlobalIndexSubr();
        this.subsetLocalIndexSubr = new ArrayList<byte[]>();
        this.subsetGlobalIndexSubr = new ArrayList<byte[]>();
        this.subsetCharStringsIndex = new ArrayList<byte[]>();
        this.localUniques = new ArrayList<Integer>();
        this.globalUniques = new ArrayList<Integer>();
        HashMap<Integer, Integer> gidHintMaskLengths = new HashMap<Integer, Integer>();
        for (int gid : this.subsetGlyphs.keySet()) {
            this.type2Parser = new Type2Parser();
            data = charStringsIndex.getValue(gid);
            this.preScanForSubsetIndexSize(data);
            gidHintMaskLengths.put(gid, this.type2Parser.getMaskLength());
        }
        this.subsetLocalSubrCount = this.localUniques.size();
        this.subsetGlobalSubrCount = this.globalUniques.size();
        this.localUniques.clear();
        this.globalUniques.clear();
        for (int gid : this.subsetGlyphs.keySet()) {
            data = charStringsIndex.getValue(gid);
            this.type2Parser = new Type2Parser();
            this.type2Parser.setMaskLength((Integer)gidHintMaskLengths.get(gid));
            data = this.readCharStringData(data, this.subsetLocalSubrCount);
            this.subsetCharStringsIndex.add(data);
        }
    }

    private void preScanForSubsetIndexSize(byte[] data) throws IOException {
        boolean hasLocalSubroutines = this.localIndexSubr != null && this.localIndexSubr.getNumObjects() > 0;
        boolean hasGlobalSubroutines = this.globalIndexSubr != null && this.globalIndexSubr.getNumObjects() > 0;
        for (int dataPos = 0; dataPos < data.length; ++dataPos) {
            byte[] subr;
            int subrNumber;
            int b0 = data[dataPos] & 0xFF;
            if (b0 == 10 && hasLocalSubroutines) {
                subrNumber = this.getSubrNumber(this.localIndexSubr.getNumObjects(), this.type2Parser.popOperand().getNumber());
                if (!this.localUniques.contains(subrNumber) && subrNumber < this.localIndexSubr.getNumObjects()) {
                    this.localUniques.add(subrNumber);
                }
                if (subrNumber < this.localIndexSubr.getNumObjects()) {
                    subr = this.localIndexSubr.getValue(subrNumber);
                    this.preScanForSubsetIndexSize(subr);
                    continue;
                }
                throw new IllegalArgumentException("callsubr out of range");
            }
            if (b0 == 29 && hasGlobalSubroutines) {
                subrNumber = this.getSubrNumber(this.globalIndexSubr.getNumObjects(), this.type2Parser.popOperand().getNumber());
                if (!this.globalUniques.contains(subrNumber) && subrNumber < this.globalIndexSubr.getNumObjects()) {
                    this.globalUniques.add(subrNumber);
                }
                if (subrNumber < this.globalIndexSubr.getNumObjects()) {
                    subr = this.globalIndexSubr.getValue(subrNumber);
                    this.preScanForSubsetIndexSize(subr);
                    continue;
                }
                throw new IllegalArgumentException("callgsubr out of range");
            }
            dataPos += this.type2Parser.exec(b0, data, dataPos);
        }
    }

    private int getSubrNumber(int numSubroutines, int operand) {
        int bias = this.getBias(numSubroutines);
        return bias + operand;
    }

    private byte[] readCharStringData(byte[] data, int subsetLocalSubrCount) throws IOException {
        boolean hasLocalSubroutines = this.localIndexSubr != null && this.localIndexSubr.getNumObjects() > 0;
        boolean hasGlobalSubroutines = this.globalIndexSubr != null && this.globalIndexSubr.getNumObjects() > 0;
        for (int dataPos = 0; dataPos < data.length; ++dataPos) {
            byte[] newData;
            int newRef;
            int subrNumber;
            BytesNumber operand;
            int b0 = data[dataPos] & 0xFF;
            if (b0 == 10 && hasLocalSubroutines) {
                operand = this.type2Parser.popOperand();
                subrNumber = this.getSubrNumber(this.localIndexSubr.getNumObjects(), operand.getNumber());
                newRef = this.getNewRefForReference(subrNumber, this.localUniques, this.localIndexSubr, this.subsetLocalIndexSubr, subsetLocalSubrCount);
                if (newRef == -1) continue;
                newData = this.constructNewRefData(dataPos, data, operand, subsetLocalSubrCount, newRef, new int[]{10});
                dataPos -= data.length - newData.length;
                data = newData;
                continue;
            }
            if (b0 == 29 && hasGlobalSubroutines) {
                operand = this.type2Parser.popOperand();
                subrNumber = this.getSubrNumber(this.globalIndexSubr.getNumObjects(), operand.getNumber());
                newRef = this.getNewRefForReference(subrNumber, this.globalUniques, this.globalIndexSubr, this.subsetGlobalIndexSubr, this.subsetGlobalSubrCount);
                if (newRef == -1) continue;
                newData = this.constructNewRefData(dataPos, data, operand, this.subsetGlobalSubrCount, newRef, new int[]{29});
                dataPos -= data.length - newData.length;
                data = newData;
                continue;
            }
            dataPos += this.type2Parser.exec(b0, data, dataPos);
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getNewRefForReference(int subrNumber, List<Integer> uniquesArray, CFFDataReader.CFFIndexData indexSubr, List<byte[]> subsetIndexSubr, int subrCount) throws IOException {
        if (uniquesArray.contains(subrNumber)) return uniquesArray.indexOf(subrNumber);
        if (subrNumber >= indexSubr.getNumObjects()) throw new IllegalArgumentException("subrNumber out of range");
        byte[] subr = indexSubr.getValue(subrNumber);
        subr = this.readCharStringData(subr, subrCount);
        uniquesArray.add(subrNumber);
        subsetIndexSubr.add(subr);
        return subsetIndexSubr.size() - 1;
    }

    private int getBias(int subrCount) {
        if (subrCount < 1240) {
            return 107;
        }
        if (subrCount < 33900) {
            return 1131;
        }
        return 32768;
    }

    private byte[] constructNewRefData(int curDataPos, byte[] currentData, BytesNumber operand, int fullSubsetIndexSize, int curSubsetIndexSize, int[] operatorCode) throws IOException {
        ByteArrayOutputStream newData = new ByteArrayOutputStream();
        int startRef = curDataPos - operand.getNumBytes();
        int length = operand.getNumBytes() + 1;
        int newBias = this.getBias(fullSubsetIndexSize);
        int newRef = curSubsetIndexSize - newBias;
        byte[] newRefBytes = OTFSubSetFile.createNewRef(newRef, operatorCode, -1, false);
        newData.write(currentData, 0, startRef);
        newData.write(newRefBytes);
        newData.write(currentData, startRef + length, currentData.length - (startRef + length));
        return newData.toByteArray();
    }

    public static byte[] createNewRef(int newRef, int[] operatorCode, int forceLength, boolean isDict) {
        ByteArrayOutputStream newRefBytes = new ByteArrayOutputStream();
        if (forceLength == -1 && newRef >= -107 && newRef <= 107 || forceLength == 1) {
            newRefBytes.write(newRef + 139);
            for (int i : operatorCode) {
                newRefBytes.write(i);
            }
        } else if (forceLength == -1 && newRef >= -1131 && newRef <= 1131 || forceLength == 2) {
            if (newRef <= -876) {
                newRefBytes.write(254);
            } else if (newRef <= -620) {
                newRefBytes.write(253);
            } else if (newRef <= -364) {
                newRefBytes.write(252);
            } else if (newRef <= -108) {
                newRefBytes.write(251);
            } else if (newRef <= 363) {
                newRefBytes.write(247);
            } else if (newRef <= 619) {
                newRefBytes.write(248);
            } else if (newRef <= 875) {
                newRefBytes.write(249);
            } else {
                newRefBytes.write(250);
            }
            if (newRef > 0) {
                newRefBytes.write(newRef - 108);
            } else {
                newRefBytes.write(-newRef - 108);
            }
            for (int i : operatorCode) {
                newRefBytes.write(i);
            }
        } else if (forceLength == -1 && newRef >= Short.MIN_VALUE && newRef <= Short.MAX_VALUE || forceLength == 3) {
            newRefBytes.write(28);
            newRefBytes.write(newRef >> 8);
            newRefBytes.write(newRef);
            for (int i : operatorCode) {
                newRefBytes.write(i);
            }
        } else {
            if (isDict) {
                newRefBytes.write(29);
            } else {
                newRefBytes.write(255);
            }
            newRefBytes.write(newRef >> 24);
            newRefBytes.write(newRef >> 16);
            newRefBytes.write(newRef >> 8);
            newRefBytes.write(newRef);
            for (int i : operatorCode) {
                newRefBytes.write(i);
            }
        }
        return newRefBytes.toByteArray();
    }

    protected int writeIndex(List<byte[]> dataArray) {
        int hdrTotal = 3;
        this.writeCard16(dataArray.size());
        int totLength = 1;
        for (byte[] aDataArray1 : dataArray) {
            totLength += aDataArray1.length;
        }
        int offSize = this.getOffSize(totLength);
        this.writeByte(offSize);
        hdrTotal += offSize;
        int total = 0;
        block7: for (int i = 0; i < dataArray.size(); ++i) {
            hdrTotal += offSize;
            int length = dataArray.get(i).length;
            switch (offSize) {
                case 1: {
                    if (i == 0) {
                        this.writeByte(1);
                    }
                    this.writeByte((total += length) + 1);
                    continue block7;
                }
                case 2: {
                    if (i == 0) {
                        this.writeCard16(1);
                    }
                    this.writeCard16((total += length) + 1);
                    continue block7;
                }
                case 3: {
                    if (i == 0) {
                        this.writeThreeByteNumber(1);
                    }
                    this.writeThreeByteNumber((total += length) + 1);
                    continue block7;
                }
                case 4: {
                    if (i == 0) {
                        this.writeULong(1);
                    }
                    this.writeULong((total += length) + 1);
                    continue block7;
                }
                default: {
                    throw new AssertionError((Object)"Offset Size was not an expected value.");
                }
            }
        }
        for (byte[] aDataArray : dataArray) {
            this.writeBytes(aDataArray);
        }
        return hdrTotal + total;
    }

    private int getOffSize(int totLength) {
        int offSize = 1;
        offSize = totLength < 256 ? 1 : (totLength < 65536 ? 2 : (totLength < 0x1000000 ? 3 : 4));
        return offSize;
    }

    private void writeCharsetTable(boolean cidFont) throws IOException {
        if (cidFont) {
            this.writeByte(2);
            for (int entry : this.gidToSID.keySet()) {
                if (entry == 0) continue;
                this.writeCard16(entry);
                this.writeCard16(this.gidToSID.size() - 1);
                break;
            }
        } else {
            this.writeByte(0);
            for (int entry : this.gidToSID.values()) {
                this.writeCard16(entry);
            }
        }
    }

    protected void writePrivateDict() throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        CFFDataReader.DICTEntry privateEntry = (CFFDataReader.DICTEntry)topDICT.get("Private");
        if (privateEntry != null) {
            this.writeBytes(this.cffReader.getPrivateDictBytes(privateEntry));
        }
    }

    protected void updateOffsets(int topDictOffset, int charsetOffset, int charStringOffset, int privateDictOffset, int localIndexOffset, int encodingOffset) throws IOException {
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDICT = this.cffReader.getTopDictEntries();
        Map<String, CFFDataReader.DICTEntry> privateDICT = null;
        CFFDataReader.DICTEntry privateEntry = (CFFDataReader.DICTEntry)topDICT.get("Private");
        if (privateEntry != null) {
            privateDICT = this.cffReader.getPrivateDict(privateEntry);
        }
        int dataPos = 3 + this.cffReader.getTopDictIndex().getOffSize() * this.cffReader.getTopDictIndex().getOffsets().length;
        int dataTopDictOffset = topDictOffset + dataPos;
        this.updateFixedOffsets(topDICT, dataTopDictOffset, charsetOffset, charStringOffset, encodingOffset);
        if (privateDICT != null) {
            int oldPrivateOffset = dataTopDictOffset + privateEntry.getOffset();
            this.updateOffset(this.output, oldPrivateOffset + privateEntry.getOperandLengths().get(0), privateEntry.getOperandLengths().get(1), privateDictOffset);
            CFFDataReader.DICTEntry subroutines = privateDICT.get("Subrs");
            if (subroutines != null) {
                int oldLocalSubrOffset = privateDictOffset + subroutines.getOffset();
                this.updateOffset(this.output, oldLocalSubrOffset, subroutines.getOperandLength(), localIndexOffset - privateDictOffset);
            }
        }
    }

    protected void updateFixedOffsets(Map<String, CFFDataReader.DICTEntry> topDICT, int dataTopDictOffset, int charsetOffset, int charStringOffset, int encodingOffset) {
        CFFDataReader.DICTEntry charset = topDICT.get("charset");
        int oldCharsetOffset = dataTopDictOffset + charset.getOffset();
        this.updateOffset(this.output, oldCharsetOffset, charset.getOperandLength(), charsetOffset);
        CFFDataReader.DICTEntry charString = topDICT.get("CharStrings");
        int oldCharStringOffset = dataTopDictOffset + charString.getOffset();
        this.updateOffset(this.output, oldCharStringOffset, charString.getOperandLength(), charStringOffset);
        CFFDataReader.DICTEntry encodingEntry = topDICT.get("Encoding");
        if (encodingEntry != null && encodingEntry.getOperands().get(0).intValue() != 0 && encodingEntry.getOperands().get(0).intValue() != 1) {
            int oldEncodingOffset = dataTopDictOffset + encodingEntry.getOffset();
            this.updateOffset(this.output, oldEncodingOffset, encodingEntry.getOperandLength(), encodingOffset);
        }
    }

    protected void updateCIDOffsets(int topDictDataOffset, int fdArrayOffset, int fdSelectOffset, int charsetOffset, int charStringOffset, int encodingOffset) {
        CFFDataReader.DICTEntry fdSelect;
        LinkedHashMap<String, CFFDataReader.DICTEntry> topDict = this.cffReader.getTopDictEntries();
        CFFDataReader.DICTEntry fdArrayEntry = (CFFDataReader.DICTEntry)topDict.get("FDArray");
        if (fdArrayEntry != null) {
            this.updateOffset(this.output, topDictDataOffset + fdArrayEntry.getOffset() - 1, fdArrayEntry.getOperandLength(), fdArrayOffset);
        }
        if ((fdSelect = (CFFDataReader.DICTEntry)topDict.get("FDSelect")) != null) {
            this.updateOffset(this.output, topDictDataOffset + fdSelect.getOffset() - 1, fdSelect.getOperandLength(), fdSelectOffset);
        }
        this.updateFixedOffsets(topDict, topDictDataOffset, charsetOffset, charStringOffset, encodingOffset);
    }

    protected void updateOffset(byte[] out, int position, int length, int replacement) {
        switch (length) {
            case 1: {
                out[position] = (byte)(replacement + 139);
                break;
            }
            case 2: {
                out[position] = replacement <= -876 ? -2 : (replacement <= -620 ? -3 : (replacement <= -364 ? -4 : (replacement <= -108 ? -5 : (replacement <= 363 ? -9 : (replacement <= 619 ? -8 : (replacement <= 875 ? -7 : -6))))));
                if (replacement > 0) {
                    out[position + 1] = (byte)(replacement - 108);
                    break;
                }
                out[position + 1] = (byte)(-replacement - 108);
                break;
            }
            case 3: {
                out[position] = 28;
                out[position + 1] = (byte)(replacement >> 8 & 0xFF);
                out[position + 2] = (byte)(replacement & 0xFF);
                break;
            }
            case 5: {
                out[position] = 29;
                out[position + 1] = (byte)(replacement >> 24 & 0xFF);
                out[position + 2] = (byte)(replacement >> 16 & 0xFF);
                out[position + 3] = (byte)(replacement >> 8 & 0xFF);
                out[position + 4] = (byte)(replacement & 0xFF);
                break;
            }
        }
    }

    public CFFDataReader getCFFReader() {
        return this.cffReader;
    }

    static class BytesNumber {
        private int number;
        private int numBytes;

        public BytesNumber(int number, int numBytes) {
            this.number = number;
            this.numBytes = numBytes;
        }

        public int getNumber() {
            return this.number;
        }

        public int getNumBytes() {
            return this.numBytes;
        }

        public void clearNumber() {
            this.number = -1;
            this.numBytes = -1;
        }

        public String toString() {
            return Integer.toString(this.number);
        }

        public boolean equals(Object entry) {
            assert (entry instanceof BytesNumber);
            BytesNumber bnEntry = (BytesNumber)entry;
            return this.number == bnEntry.getNumber() && this.numBytes == bnEntry.getNumBytes();
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 17 + this.number;
            hash = hash * 31 + this.numBytes;
            return hash;
        }
    }

    private static class FDIndexReference {
        private int newFDIndex;
        private int oldFDIndex;

        public FDIndexReference(int newFDIndex, int oldFDIndex) {
            this.newFDIndex = newFDIndex;
            this.oldFDIndex = oldFDIndex;
        }

        public int getNewFDIndex() {
            return this.newFDIndex;
        }

        public int getOldFDIndex() {
            return this.oldFDIndex;
        }
    }

    static class Type2Parser {
        protected Log log = LogFactory.getLog(Type2Parser.class);
        private List<BytesNumber> stack = new ArrayList<BytesNumber>();
        private int hstemCount;
        private int vstemCount;
        private int lastOp = -1;
        private int maskLength = -1;

        Type2Parser() {
        }

        public void pushOperand(BytesNumber v) {
            this.stack.add(v);
        }

        public BytesNumber popOperand() {
            return this.stack.remove(this.stack.size() - 1);
        }

        public void clearStack() {
            this.stack.clear();
        }

        public int[] getOperands(int numbers) {
            int[] ret = new int[numbers];
            while (numbers > 0) {
                ret[--numbers] = this.popOperand().getNumber();
            }
            return ret;
        }

        public void setMaskLength(int maskLength) {
            this.maskLength = maskLength;
        }

        public int getMaskLength() {
            if (this.maskLength > 0) {
                return this.maskLength;
            }
            return 1 + (this.hstemCount + this.vstemCount - 1) / 8;
        }

        public int exec(int b0, byte[] data, int dataPos) {
            int posDelta = 0;
            if (b0 >= 0 && b0 <= 27 || b0 >= 29 && b0 <= 31) {
                if (b0 == 12) {
                    this.log.warn((Object)"May not guess the operand count correctly.");
                    posDelta = 1;
                } else if (b0 == 1 || b0 == 18) {
                    this.hstemCount += this.stack.size() / 2;
                    this.clearStack();
                } else if (b0 == 19 || b0 == 20) {
                    if (this.lastOp == 1 || this.lastOp == 18) {
                        this.vstemCount += this.stack.size() / 2;
                    }
                    this.clearStack();
                    posDelta = this.getMaskLength();
                } else if (b0 == 3 || b0 == 23) {
                    this.vstemCount += this.stack.size() / 2;
                    this.clearStack();
                }
                if (b0 != 11 && b0 != 12) {
                    this.lastOp = b0;
                }
            } else if (b0 == 28 || b0 >= 32 && b0 <= 255) {
                BytesNumber operand = this.readNumber(b0, data, dataPos);
                this.pushOperand(operand);
                posDelta = operand.getNumBytes() - 1;
            } else {
                throw new UnsupportedOperationException("Operator:" + b0 + " is not supported");
            }
            return posDelta;
        }

        private BytesNumber readNumber(int b0, byte[] input, int curPos) {
            if (b0 == 28) {
                int b1 = input[curPos + 1] & 0xFF;
                int b2 = input[curPos + 2] & 0xFF;
                return new BytesNumber((short)(b1 << 8 | b2), 3);
            }
            if (b0 >= 32 && b0 <= 246) {
                return new BytesNumber(b0 - 139, 1);
            }
            if (b0 >= 247 && b0 <= 250) {
                int b1 = input[curPos + 1] & 0xFF;
                return new BytesNumber((b0 - 247) * 256 + b1 + 108, 2);
            }
            if (b0 >= 251 && b0 <= 254) {
                int b1 = input[curPos + 1] & 0xFF;
                return new BytesNumber(-(b0 - 251) * 256 - b1 - 108, 2);
            }
            if (b0 == 255) {
                int b1 = input[curPos + 1] & 0xFF;
                int b2 = input[curPos + 2] & 0xFF;
                int b3 = input[curPos + 3] & 0xFF;
                int b4 = input[curPos + 4] & 0xFF;
                return new BytesNumber(b1 << 24 | b2 << 16 | b3 << 8 | b4, 5);
            }
            throw new IllegalArgumentException();
        }
    }
}

