/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import net.sourceforge.plantuml.ugraphic.ColorChangerMonochrome;
import net.sourceforge.plantuml.ugraphic.UShape;

public class UImage
implements UShape {
    private final BufferedImage image;
    private final String formula;

    public UImage(BufferedImage image) {
        this(image, null);
    }

    public UImage(BufferedImage image, String formula) {
        this.image = image;
        this.formula = formula;
    }

    public UImage scale(double scale) {
        return this.scale(scale, 2);
    }

    public UImage scaleNearestNeighbor(double scale) {
        return this.scale(scale, 1);
    }

    private UImage scale(double scale, int type) {
        if (scale == 1.0) {
            return this;
        }
        int w = (int)Math.round((double)this.image.getWidth() * scale);
        int h = (int)Math.round((double)this.image.getHeight() * scale);
        BufferedImage after = new BufferedImage(w, h, this.image.getType());
        AffineTransform at = new AffineTransform();
        at.scale(scale, scale);
        AffineTransformOp scaleOp = new AffineTransformOp(at, type);
        return new UImage(scaleOp.filter(this.image, after), this.formula);
    }

    public final BufferedImage getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.image.getWidth() - 1;
    }

    public int getHeight() {
        return this.image.getHeight() - 1;
    }

    public final String getFormula() {
        return this.formula;
    }

    public UImage muteColor(Color newColor) {
        if (newColor == null) {
            return this;
        }
        int darker = -1;
        for (int i = 0; i < this.image.getWidth(); ++i) {
            for (int j = 0; j < this.image.getHeight(); ++j) {
                int color = this.image.getRGB(i, j);
                if (this.isTransparent(color)) continue;
                int grey = ColorChangerMonochrome.getGrayScale(color);
                if (darker != -1 && grey >= ColorChangerMonochrome.getGrayScale(darker)) continue;
                darker = color;
            }
        }
        BufferedImage copy = UImage.deepCopy(this.image);
        for (int i = 0; i < this.image.getWidth(); ++i) {
            for (int j = 0; j < this.image.getHeight(); ++j) {
                if (copy.getRGB(i, j) != darker) continue;
                copy.setRGB(i, j, newColor.getRGB());
            }
        }
        return new UImage(copy, this.formula);
    }

    private boolean isTransparent(int color) {
        return color == 0;
    }

    private static BufferedImage deepCopy(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(bi.getRaster().createCompatibleWritableRaster());
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }
}

