/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.util.List;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandBoxStart
extends SingleLineCommand<SequenceDiagram> {
    public CommandBoxStart() {
        super("(?i)^box(?:[%s]+[%g]([^%g]+)[%g])?(?:[%s]+(#\\w+))?$");
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, List<String> arg) {
        if (diagram.isBoxPending()) {
            return CommandExecutionResult.error("Box cannot be nested");
        }
        HtmlColor color = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get(1));
        String title = arg.get(0) == null ? "" : arg.get(0);
        diagram.boxStart(Display.getWithNewlines(title), color);
        return CommandExecutionResult.ok();
    }
}

