/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.project3.ComplementColors;
import net.sourceforge.plantuml.project3.Instant;
import net.sourceforge.plantuml.project3.TaskDraw;
import net.sourceforge.plantuml.project3.TaskImpl;
import net.sourceforge.plantuml.project3.TimeScale;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TaskDrawRegular
implements TaskDraw {
    private final TaskImpl task;
    private final TimeScale timeScale;
    private final double y;
    private ComplementColors colors;
    private final double margin = 2.0;

    public TaskDrawRegular(TaskImpl task, TimeScale timeScale, double y) {
        this.y = y;
        this.task = task;
        this.timeScale = timeScale;
    }

    @Override
    public void drawTitle(UGraphic ug) {
        TextBlock title = Display.getWithNewlines(this.task.getPrettyDisplay()).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        title.drawU(ug.apply(new UTranslate(this.timeScale.getEndingPosition(this.task.getStart()), 0.0)));
    }

    private FontConfiguration getFontConfiguration() {
        UFont font = UFont.serif(11);
        return new FontConfiguration(font, HtmlColorUtils.BLACK, HtmlColorUtils.BLACK, false);
    }

    @Override
    public void drawU(UGraphic ug1) {
        double start = this.timeScale.getStartingPosition(this.task.getStart());
        ug1 = this.applyColors(ug1);
        UGraphic ug2 = ug1.apply(new UTranslate(start + 2.0, 2.0));
        UShape shapeFull = this.getShape(100);
        if (shapeFull instanceof UPolygon) {
            ug2.draw(shapeFull);
        } else {
            double fullHeight = ((URectangle)shapeFull).getHeight();
            ug2.apply(new UChangeBackColor(HtmlColorUtils.WHITE)).apply(new UChangeColor(HtmlColorUtils.WHITE)).draw(shapeFull);
            this.drawInside(ug1, fullHeight);
            ug2.apply(new UChangeBackColor(null)).draw(shapeFull);
        }
    }

    private void drawInside(UGraphic ug, double fullHeight) {
        Instant i = this.task.getStart();
        while (i.compareTo(this.task.getEnd()) <= 0) {
            int load = this.task.getLoadAt(i);
            URectangle shapeLoad = this.getShapeInside(load, i);
            double diffHeight = fullHeight - shapeLoad.getHeight();
            double start = this.timeScale.getStartingPosition(i);
            ug.apply(new UChangeColor(null)).apply(new UTranslate(start, diffHeight + 2.0)).draw(shapeLoad);
            i = i.increment();
        }
    }

    private UGraphic applyColors(UGraphic ug) {
        if (this.colors != null && this.colors.isOk()) {
            return this.colors.apply(ug);
        }
        if (this.isDiamond()) {
            return ug.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UChangeBackColor(HtmlColorUtils.BLACK));
        }
        return ug.apply(new UChangeColor(HtmlColorUtils.BLUE)).apply(new UChangeBackColor(HtmlColorUtils.COL_84BE84));
    }

    private URectangle getShapeInside(int load, Instant instant) {
        double start = this.timeScale.getStartingPosition(instant);
        double end = this.timeScale.getEndingPosition(instant);
        double height = (this.getHeight() - 4.0) * (double)load / 100.0;
        return new URectangle(end - start, height);
    }

    private UShape getShape(int load) {
        if (this.isDiamond()) {
            return this.getDiamond();
        }
        Instant instantStart = this.task.getStart();
        Instant instantEnd = this.task.getEnd();
        double start = this.timeScale.getStartingPosition(instantStart);
        double end = this.timeScale.getEndingPosition(instantEnd);
        double height = (this.getHeight() - 4.0) * (double)load / 100.0;
        return new URectangle(end - start - 4.0, height, 8.0, 8.0);
    }

    private boolean isDiamond() {
        Instant instantEnd;
        Instant instantStart = this.task.getStart();
        return instantStart.compareTo(instantEnd = this.task.getEnd()) == 0;
    }

    private UShape getDiamond() {
        double h = this.getHeight() - 4.0;
        UPolygon result = new UPolygon();
        result.addPoint(h / 2.0, 0.0);
        result.addPoint(h, h / 2.0);
        result.addPoint(h / 2.0, h);
        result.addPoint(0.0, h / 2.0);
        return result;
    }

    @Override
    public double getHeight() {
        return 16.0;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getY(Direction direction) {
        if (direction == Direction.UP) {
            return this.y;
        }
        if (direction == Direction.DOWN) {
            return this.y + this.getHeight();
        }
        return this.y + this.getHeight() / 2.0;
    }

    @Override
    public void setColors(ComplementColors colors) {
        this.colors = colors;
    }
}

