/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.project.Duration;
import net.sourceforge.plantuml.project.Instant;
import net.sourceforge.plantuml.project.Item;
import net.sourceforge.plantuml.project.Load;
import net.sourceforge.plantuml.project.NumericNumber;

public class ParentItem
implements Item {
    private final String code;
    private final Item parent;
    private final List<Item> children = new ArrayList<Item>();

    public ParentItem(String code, Item parent) {
        this.code = code;
        this.parent = parent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.code + " {");
        Iterator<Item> it = this.children.iterator();
        while (it.hasNext()) {
            Item child = it.next();
            sb.append(child.getCode());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public Instant getBegin() {
        Instant result = null;
        for (Item it : this.children) {
            if (result != null && result.compareTo(it.getBegin()) <= 0) continue;
            result = it.getBegin();
        }
        return result;
    }

    @Override
    public Instant getCompleted() {
        Instant result = null;
        for (Item it : this.children) {
            if (result != null && result.compareTo(it.getCompleted()) >= 0) continue;
            result = it.getCompleted();
        }
        return result;
    }

    @Override
    public Duration getDuration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Load getLoad() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NumericNumber getWork() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Item getParent() {
        return this.parent;
    }

    @Override
    public List<Item> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void addChild(Item child) {
        this.children.add(child);
    }

    @Override
    public boolean isValid() {
        if (this.children.size() == 0) {
            return false;
        }
        for (Item it : this.children) {
            if (it.isValid()) continue;
            return false;
        }
        return true;
    }
}

