/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.StringCompressorNone;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends AbstractPSystem {
    public static final String DONORS = "6v8802mEp3EZtv0iGcz-fvJYI4HCdvyvFoLZ70fX42Pji_Rj7u5_xF8MOOgGwCb2hYywcqt8cZ7fvZdBUKOHB9z6h9SwR7EpNwh8AC6pcc_-6SNudZjfQ4BQdR1i1_B_wLu53WLaSJR5GnWEsFmBC_QWEUnUABLhwMBt2ze2ZMdqOyjAyTtoFPIoRgV0R9HytwmWOV4FnnLLiXJZBf5YgXDROEAE6SdMwKxm3RVRVzHDQj7QceQ4Zm1Y6obiROzzBIuBEJw5WH74e0umG8G3AOVw8ATuUy41HAyQCUApcCPwgtUUA4321XLQy8-SLESMiZpBa0bYS3CGCFaEd03iJKabcEtS1kHfWHP53PRgrdKd8ZFU34y9MJHSHGuOHD0Ag4AGDq47-2vjorkCnvWLCVpHFHWVtX3aJHQUI2yM-dhhmK3usLqrazNjJcrg8SGbxtMSjJR0iuQC7EsXzxXaCnxhrrmAmsyjG7uBz5BlY1X_Szqi945mBgatd7ME7D-c28Gsbef5xcBAQy8PNNQsfgZlBLYOb_phrg4immXTgRW5y0ijZvDrlb3SDDH_BxaQEdu5rdWqt5k1ijFcOlvxsItDZD83jDc5pT1L4U6USMXLA2P31AuG-ZxW8KdEfDh7v57zMBx4F_Od8Rn5uO2LDZFQdrLN98eSLa4Mb3lQn08mtIJQ0M9q9s44r0NTXYhdy0nttRi9UTfcO-hQeOPZDy8OrBVf9FaWOZUNZ9A67bas2ukr7t2Mu1mkajVFFHor2c0zqhlhPcc-mK2yXJdT8js6vML9koMYg2D4bjCMh-hYh-wsykUXCtyuvx5ew8tpJvvVXun7yoLzQQb7bBbhqFtj25dUpaXHPjWEr-503MHy2hXUDNccaYCGlUaCXqPi967M1w-T1OTm1nVHMATiBqrBaAtdwcEW6Vo8tCcGIZrm9n7hk0jmXl4eij-Ozygek_eyf4Gje60C4vobGjX7I54DsxOWGyRuwHcCJhxoeIqMy6dioSmw53vXebt31ZQc48iMzOEu2S3rtjUebpGcIi3NlFocUioiWvu_iwKLuW1EAGa1g63uy1rdfqgRhMcij-Zzs3HzBHj__MUkCi4f5VkyMu1K1p7vBuSWCX7VbTqZy5daOudHHaRWM2lRMBcqz3Z0i22JbXbgcfyPyUbQADVN1ZHhVIZFVvHLdh6dvmK0";

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        UDrawable result = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, this.getMetadata(), null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    private UDrawable getGraphicStrings() throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 7, 5);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(new UTranslate(0.0, header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(new UTranslate(x, 0.0)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(PSystemVersion.getPlantumlImage());
                ug.apply(new UTranslate(lastX, y - (double)logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        TranscoderImpl t = new TranscoderImpl(new AsciiEncoder(), new StringCompressorNone(), new CompressionBrotli());
        String s = t.decode(DONORS).replace('*', '.');
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            lines.add(st.nextToken());
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

